/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.codedeploy.transform.ApplicationInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ApplicationInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, ApplicationInfo> {
    private final String applicationId;
    private final String applicationName;
    private final Date createTime;
    private final Boolean linkedToGitHub;
    private final String gitHubAccountName;

    private ApplicationInfo(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.applicationName = builder.applicationName;
        this.createTime = builder.createTime;
        this.linkedToGitHub = builder.linkedToGitHub;
        this.gitHubAccountName = builder.gitHubAccountName;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public Date createTime() {
        return this.createTime;
    }

    public Boolean linkedToGitHub() {
        return this.linkedToGitHub;
    }

    public String gitHubAccountName() {
        return this.gitHubAccountName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationId() == null ? 0 : this.applicationId().hashCode());
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.createTime() == null ? 0 : this.createTime().hashCode());
        hashCode = 31 * hashCode + (this.linkedToGitHub() == null ? 0 : this.linkedToGitHub().hashCode());
        hashCode = 31 * hashCode + (this.gitHubAccountName() == null ? 0 : this.gitHubAccountName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationInfo)) {
            return false;
        }
        ApplicationInfo other = (ApplicationInfo)obj;
        if (other.applicationId() == null ^ this.applicationId() == null) {
            return false;
        }
        if (other.applicationId() != null && !other.applicationId().equals(this.applicationId())) {
            return false;
        }
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.createTime() == null ^ this.createTime() == null) {
            return false;
        }
        if (other.createTime() != null && !other.createTime().equals(this.createTime())) {
            return false;
        }
        if (other.linkedToGitHub() == null ^ this.linkedToGitHub() == null) {
            return false;
        }
        if (other.linkedToGitHub() != null && !other.linkedToGitHub().equals(this.linkedToGitHub())) {
            return false;
        }
        if (other.gitHubAccountName() == null ^ this.gitHubAccountName() == null) {
            return false;
        }
        return other.gitHubAccountName() == null || other.gitHubAccountName().equals(this.gitHubAccountName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.createTime() != null) {
            sb.append("CreateTime: ").append(this.createTime()).append(",");
        }
        if (this.linkedToGitHub() != null) {
            sb.append("LinkedToGitHub: ").append(this.linkedToGitHub()).append(",");
        }
        if (this.gitHubAccountName() != null) {
            sb.append("GitHubAccountName: ").append(this.gitHubAccountName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String applicationName;
        private Date createTime;
        private Boolean linkedToGitHub;
        private String gitHubAccountName;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationInfo model) {
            this.setApplicationId(model.applicationId);
            this.setApplicationName(model.applicationName);
            this.setCreateTime(model.createTime);
            this.setLinkedToGitHub(model.linkedToGitHub);
            this.setGitHubAccountName(model.gitHubAccountName);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Date getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Date createTime) {
            this.createTime = StandardMemberCopier.copy((Date)createTime);
            return this;
        }

        public final void setCreateTime(Date createTime) {
            this.createTime = StandardMemberCopier.copy((Date)createTime);
        }

        public final Boolean getLinkedToGitHub() {
            return this.linkedToGitHub;
        }

        @Override
        public final Builder linkedToGitHub(Boolean linkedToGitHub) {
            this.linkedToGitHub = linkedToGitHub;
            return this;
        }

        public final void setLinkedToGitHub(Boolean linkedToGitHub) {
            this.linkedToGitHub = linkedToGitHub;
        }

        public final String getGitHubAccountName() {
            return this.gitHubAccountName;
        }

        @Override
        public final Builder gitHubAccountName(String gitHubAccountName) {
            this.gitHubAccountName = gitHubAccountName;
            return this;
        }

        public final void setGitHubAccountName(String gitHubAccountName) {
            this.gitHubAccountName = gitHubAccountName;
        }

        public ApplicationInfo build() {
            return new ApplicationInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ApplicationInfo> {
        public Builder applicationId(String var1);

        public Builder applicationName(String var1);

        public Builder createTime(Date var1);

        public Builder linkedToGitHub(Boolean var1);

        public Builder gitHubAccountName(String var1);
    }
}

