/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeconnections.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeconnections.model.CodeConnectionsRequest;
import software.amazon.awssdk.services.codeconnections.model.SyncConfigurationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRepositorySyncStatusRequest
extends CodeConnectionsRequest
implements ToCopyableBuilder<Builder, GetRepositorySyncStatusRequest> {
    private static final SdkField<String> BRANCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Branch").getter(GetRepositorySyncStatusRequest.getter(GetRepositorySyncStatusRequest::branch)).setter(GetRepositorySyncStatusRequest.setter(Builder::branch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Branch").build()}).build();
    private static final SdkField<String> REPOSITORY_LINK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RepositoryLinkId").getter(GetRepositorySyncStatusRequest.getter(GetRepositorySyncStatusRequest::repositoryLinkId)).setter(GetRepositorySyncStatusRequest.setter(Builder::repositoryLinkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryLinkId").build()}).build();
    private static final SdkField<String> SYNC_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SyncType").getter(GetRepositorySyncStatusRequest.getter(GetRepositorySyncStatusRequest::syncTypeAsString)).setter(GetRepositorySyncStatusRequest.setter(Builder::syncType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCH_FIELD, REPOSITORY_LINK_ID_FIELD, SYNC_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetRepositorySyncStatusRequest.memberNameToFieldInitializer();
    private final String branch;
    private final String repositoryLinkId;
    private final String syncType;

    private GetRepositorySyncStatusRequest(BuilderImpl builder) {
        super(builder);
        this.branch = builder.branch;
        this.repositoryLinkId = builder.repositoryLinkId;
        this.syncType = builder.syncType;
    }

    public final String branch() {
        return this.branch;
    }

    public final String repositoryLinkId() {
        return this.repositoryLinkId;
    }

    public final SyncConfigurationType syncType() {
        return SyncConfigurationType.fromValue(this.syncType);
    }

    public final String syncTypeAsString() {
        return this.syncType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.branch());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryLinkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRepositorySyncStatusRequest)) {
            return false;
        }
        GetRepositorySyncStatusRequest other = (GetRepositorySyncStatusRequest)((Object)obj);
        return Objects.equals(this.branch(), other.branch()) && Objects.equals(this.repositoryLinkId(), other.repositoryLinkId()) && Objects.equals(this.syncTypeAsString(), other.syncTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetRepositorySyncStatusRequest").add("Branch", (Object)this.branch()).add("RepositoryLinkId", (Object)this.repositoryLinkId()).add("SyncType", (Object)this.syncTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Branch": {
                return Optional.ofNullable(clazz.cast(this.branch()));
            }
            case "RepositoryLinkId": {
                return Optional.ofNullable(clazz.cast(this.repositoryLinkId()));
            }
            case "SyncType": {
                return Optional.ofNullable(clazz.cast(this.syncTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Branch", BRANCH_FIELD);
        map.put("RepositoryLinkId", REPOSITORY_LINK_ID_FIELD);
        map.put("SyncType", SYNC_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRepositorySyncStatusRequest, T> g) {
        return obj -> g.apply((GetRepositorySyncStatusRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeConnectionsRequest.BuilderImpl
    implements Builder {
        private String branch;
        private String repositoryLinkId;
        private String syncType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRepositorySyncStatusRequest model) {
            super(model);
            this.branch(model.branch);
            this.repositoryLinkId(model.repositoryLinkId);
            this.syncType(model.syncType);
        }

        public final String getBranch() {
            return this.branch;
        }

        public final void setBranch(String branch) {
            this.branch = branch;
        }

        @Override
        public final Builder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public final String getRepositoryLinkId() {
            return this.repositoryLinkId;
        }

        public final void setRepositoryLinkId(String repositoryLinkId) {
            this.repositoryLinkId = repositoryLinkId;
        }

        @Override
        public final Builder repositoryLinkId(String repositoryLinkId) {
            this.repositoryLinkId = repositoryLinkId;
            return this;
        }

        public final String getSyncType() {
            return this.syncType;
        }

        public final void setSyncType(String syncType) {
            this.syncType = syncType;
        }

        @Override
        public final Builder syncType(String syncType) {
            this.syncType = syncType;
            return this;
        }

        @Override
        public final Builder syncType(SyncConfigurationType syncType) {
            this.syncType(syncType == null ? null : syncType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRepositorySyncStatusRequest build() {
            return new GetRepositorySyncStatusRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeConnectionsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRepositorySyncStatusRequest> {
        public Builder branch(String var1);

        public Builder repositoryLinkId(String var1);

        public Builder syncType(String var1);

        public Builder syncType(SyncConfigurationType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

