/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeconnections.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codeconnections.CodeConnectionsAsyncClient;
import software.amazon.awssdk.services.codeconnections.internal.UserAgentUtils;
import software.amazon.awssdk.services.codeconnections.model.ListHostsRequest;
import software.amazon.awssdk.services.codeconnections.model.ListHostsResponse;

public class ListHostsPublisher
implements SdkPublisher<ListHostsResponse> {
    private final CodeConnectionsAsyncClient client;
    private final ListHostsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListHostsPublisher(CodeConnectionsAsyncClient client, ListHostsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListHostsPublisher(CodeConnectionsAsyncClient client, ListHostsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListHostsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListHostsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListHostsResponseFetcher
    implements AsyncPageFetcher<ListHostsResponse> {
        private ListHostsResponseFetcher() {
        }

        public boolean hasNextPage(ListHostsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListHostsResponse> nextPage(ListHostsResponse previousPage) {
            if (previousPage == null) {
                return ListHostsPublisher.this.client.listHosts(ListHostsPublisher.this.firstRequest);
            }
            return ListHostsPublisher.this.client.listHosts((ListHostsRequest)((Object)ListHostsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

