/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeconnections.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeconnections.model.CodeConnectionsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRepositoryLinkRequest
extends CodeConnectionsRequest
implements ToCopyableBuilder<Builder, UpdateRepositoryLinkRequest> {
    private static final SdkField<String> CONNECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionArn").getter(UpdateRepositoryLinkRequest.getter(UpdateRepositoryLinkRequest::connectionArn)).setter(UpdateRepositoryLinkRequest.setter(Builder::connectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionArn").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionKeyArn").getter(UpdateRepositoryLinkRequest.getter(UpdateRepositoryLinkRequest::encryptionKeyArn)).setter(UpdateRepositoryLinkRequest.setter(Builder::encryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()}).build();
    private static final SdkField<String> REPOSITORY_LINK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RepositoryLinkId").getter(UpdateRepositoryLinkRequest.getter(UpdateRepositoryLinkRequest::repositoryLinkId)).setter(UpdateRepositoryLinkRequest.setter(Builder::repositoryLinkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryLinkId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ARN_FIELD, ENCRYPTION_KEY_ARN_FIELD, REPOSITORY_LINK_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ConnectionArn", CONNECTION_ARN_FIELD);
            this.put("EncryptionKeyArn", ENCRYPTION_KEY_ARN_FIELD);
            this.put("RepositoryLinkId", REPOSITORY_LINK_ID_FIELD);
        }
    });
    private final String connectionArn;
    private final String encryptionKeyArn;
    private final String repositoryLinkId;

    private UpdateRepositoryLinkRequest(BuilderImpl builder) {
        super(builder);
        this.connectionArn = builder.connectionArn;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.repositoryLinkId = builder.repositoryLinkId;
    }

    public final String connectionArn() {
        return this.connectionArn;
    }

    public final String encryptionKeyArn() {
        return this.encryptionKeyArn;
    }

    public final String repositoryLinkId() {
        return this.repositoryLinkId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryLinkId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRepositoryLinkRequest)) {
            return false;
        }
        UpdateRepositoryLinkRequest other = (UpdateRepositoryLinkRequest)((Object)obj);
        return Objects.equals(this.connectionArn(), other.connectionArn()) && Objects.equals(this.encryptionKeyArn(), other.encryptionKeyArn()) && Objects.equals(this.repositoryLinkId(), other.repositoryLinkId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRepositoryLinkRequest").add("ConnectionArn", (Object)this.connectionArn()).add("EncryptionKeyArn", (Object)this.encryptionKeyArn()).add("RepositoryLinkId", (Object)this.repositoryLinkId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionArn": {
                return Optional.ofNullable(clazz.cast(this.connectionArn()));
            }
            case "EncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.encryptionKeyArn()));
            }
            case "RepositoryLinkId": {
                return Optional.ofNullable(clazz.cast(this.repositoryLinkId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRepositoryLinkRequest, T> g) {
        return obj -> g.apply((UpdateRepositoryLinkRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeConnectionsRequest.BuilderImpl
    implements Builder {
        private String connectionArn;
        private String encryptionKeyArn;
        private String repositoryLinkId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRepositoryLinkRequest model) {
            super(model);
            this.connectionArn(model.connectionArn);
            this.encryptionKeyArn(model.encryptionKeyArn);
            this.repositoryLinkId(model.repositoryLinkId);
        }

        public final String getConnectionArn() {
            return this.connectionArn;
        }

        public final void setConnectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
        }

        @Override
        public final Builder connectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        public final String getEncryptionKeyArn() {
            return this.encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final String getRepositoryLinkId() {
            return this.repositoryLinkId;
        }

        public final void setRepositoryLinkId(String repositoryLinkId) {
            this.repositoryLinkId = repositoryLinkId;
        }

        @Override
        public final Builder repositoryLinkId(String repositoryLinkId) {
            this.repositoryLinkId = repositoryLinkId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRepositoryLinkRequest build() {
            return new UpdateRepositoryLinkRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeConnectionsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRepositoryLinkRequest> {
        public Builder connectionArn(String var1);

        public Builder encryptionKeyArn(String var1);

        public Builder repositoryLinkId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

