/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about a merge or potential merge between a source reference and a destination reference in a pull
 * request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MergeMetadata implements SdkPojo, Serializable, ToCopyableBuilder<MergeMetadata.Builder, MergeMetadata> {
    private static final SdkField<Boolean> IS_MERGED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isMerged").getter(getter(MergeMetadata::isMerged)).setter(setter(Builder::isMerged))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isMerged").build()).build();

    private static final SdkField<String> MERGED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mergedBy").getter(getter(MergeMetadata::mergedBy)).setter(setter(Builder::mergedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergedBy").build()).build();

    private static final SdkField<String> MERGE_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mergeCommitId").getter(getter(MergeMetadata::mergeCommitId)).setter(setter(Builder::mergeCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeCommitId").build()).build();

    private static final SdkField<String> MERGE_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mergeOption").getter(getter(MergeMetadata::mergeOptionAsString)).setter(setter(Builder::mergeOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeOption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_MERGED_FIELD,
            MERGED_BY_FIELD, MERGE_COMMIT_ID_FIELD, MERGE_OPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean isMerged;

    private final String mergedBy;

    private final String mergeCommitId;

    private final String mergeOption;

    private MergeMetadata(BuilderImpl builder) {
        this.isMerged = builder.isMerged;
        this.mergedBy = builder.mergedBy;
        this.mergeCommitId = builder.mergeCommitId;
        this.mergeOption = builder.mergeOption;
    }

    /**
     * <p>
     * A Boolean value indicating whether the merge has been made.
     * </p>
     * 
     * @return A Boolean value indicating whether the merge has been made.
     */
    public final Boolean isMerged() {
        return isMerged;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user who merged the branches.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user who merged the branches.
     */
    public final String mergedBy() {
        return mergedBy;
    }

    /**
     * <p>
     * The commit ID for the merge commit, if any.
     * </p>
     * 
     * @return The commit ID for the merge commit, if any.
     */
    public final String mergeCommitId() {
        return mergeCommitId;
    }

    /**
     * <p>
     * The merge strategy used in the merge.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mergeOption} will
     * return {@link MergeOptionTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #mergeOptionAsString}.
     * </p>
     * 
     * @return The merge strategy used in the merge.
     * @see MergeOptionTypeEnum
     */
    public final MergeOptionTypeEnum mergeOption() {
        return MergeOptionTypeEnum.fromValue(mergeOption);
    }

    /**
     * <p>
     * The merge strategy used in the merge.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mergeOption} will
     * return {@link MergeOptionTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #mergeOptionAsString}.
     * </p>
     * 
     * @return The merge strategy used in the merge.
     * @see MergeOptionTypeEnum
     */
    public final String mergeOptionAsString() {
        return mergeOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isMerged());
        hashCode = 31 * hashCode + Objects.hashCode(mergedBy());
        hashCode = 31 * hashCode + Objects.hashCode(mergeCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(mergeOptionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergeMetadata)) {
            return false;
        }
        MergeMetadata other = (MergeMetadata) obj;
        return Objects.equals(isMerged(), other.isMerged()) && Objects.equals(mergedBy(), other.mergedBy())
                && Objects.equals(mergeCommitId(), other.mergeCommitId())
                && Objects.equals(mergeOptionAsString(), other.mergeOptionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MergeMetadata").add("IsMerged", isMerged()).add("MergedBy", mergedBy())
                .add("MergeCommitId", mergeCommitId()).add("MergeOption", mergeOptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "isMerged":
            return Optional.ofNullable(clazz.cast(isMerged()));
        case "mergedBy":
            return Optional.ofNullable(clazz.cast(mergedBy()));
        case "mergeCommitId":
            return Optional.ofNullable(clazz.cast(mergeCommitId()));
        case "mergeOption":
            return Optional.ofNullable(clazz.cast(mergeOptionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("isMerged", IS_MERGED_FIELD);
        map.put("mergedBy", MERGED_BY_FIELD);
        map.put("mergeCommitId", MERGE_COMMIT_ID_FIELD);
        map.put("mergeOption", MERGE_OPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MergeMetadata, T> g) {
        return obj -> g.apply((MergeMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MergeMetadata> {
        /**
         * <p>
         * A Boolean value indicating whether the merge has been made.
         * </p>
         * 
         * @param isMerged
         *        A Boolean value indicating whether the merge has been made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isMerged(Boolean isMerged);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user who merged the branches.
         * </p>
         * 
         * @param mergedBy
         *        The Amazon Resource Name (ARN) of the user who merged the branches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergedBy(String mergedBy);

        /**
         * <p>
         * The commit ID for the merge commit, if any.
         * </p>
         * 
         * @param mergeCommitId
         *        The commit ID for the merge commit, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergeCommitId(String mergeCommitId);

        /**
         * <p>
         * The merge strategy used in the merge.
         * </p>
         * 
         * @param mergeOption
         *        The merge strategy used in the merge.
         * @see MergeOptionTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MergeOptionTypeEnum
         */
        Builder mergeOption(String mergeOption);

        /**
         * <p>
         * The merge strategy used in the merge.
         * </p>
         * 
         * @param mergeOption
         *        The merge strategy used in the merge.
         * @see MergeOptionTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MergeOptionTypeEnum
         */
        Builder mergeOption(MergeOptionTypeEnum mergeOption);
    }

    static final class BuilderImpl implements Builder {
        private Boolean isMerged;

        private String mergedBy;

        private String mergeCommitId;

        private String mergeOption;

        private BuilderImpl() {
        }

        private BuilderImpl(MergeMetadata model) {
            isMerged(model.isMerged);
            mergedBy(model.mergedBy);
            mergeCommitId(model.mergeCommitId);
            mergeOption(model.mergeOption);
        }

        public final Boolean getIsMerged() {
            return isMerged;
        }

        public final void setIsMerged(Boolean isMerged) {
            this.isMerged = isMerged;
        }

        @Override
        public final Builder isMerged(Boolean isMerged) {
            this.isMerged = isMerged;
            return this;
        }

        public final String getMergedBy() {
            return mergedBy;
        }

        public final void setMergedBy(String mergedBy) {
            this.mergedBy = mergedBy;
        }

        @Override
        public final Builder mergedBy(String mergedBy) {
            this.mergedBy = mergedBy;
            return this;
        }

        public final String getMergeCommitId() {
            return mergeCommitId;
        }

        public final void setMergeCommitId(String mergeCommitId) {
            this.mergeCommitId = mergeCommitId;
        }

        @Override
        public final Builder mergeCommitId(String mergeCommitId) {
            this.mergeCommitId = mergeCommitId;
            return this;
        }

        public final String getMergeOption() {
            return mergeOption;
        }

        public final void setMergeOption(String mergeOption) {
            this.mergeOption = mergeOption;
        }

        @Override
        public final Builder mergeOption(String mergeOption) {
            this.mergeOption = mergeOption;
            return this;
        }

        @Override
        public final Builder mergeOption(MergeOptionTypeEnum mergeOption) {
            this.mergeOption(mergeOption == null ? null : mergeOption.toString());
            return this;
        }

        @Override
        public MergeMetadata build() {
            return new MergeMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
