/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class MergeBranchesByFastForwardResponse extends CodeCommitResponse implements
        ToCopyableBuilder<MergeBranchesByFastForwardResponse.Builder, MergeBranchesByFastForwardResponse> {
    private static final SdkField<String> COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commitId").getter(getter(MergeBranchesByFastForwardResponse::commitId))
            .setter(setter(Builder::commitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitId").build()).build();

    private static final SdkField<String> TREE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("treeId")
            .getter(getter(MergeBranchesByFastForwardResponse::treeId)).setter(setter(Builder::treeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treeId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(COMMIT_ID_FIELD, TREE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String commitId;

    private final String treeId;

    private MergeBranchesByFastForwardResponse(BuilderImpl builder) {
        super(builder);
        this.commitId = builder.commitId;
        this.treeId = builder.treeId;
    }

    /**
     * <p>
     * The commit ID of the merge in the destination or target branch.
     * </p>
     * 
     * @return The commit ID of the merge in the destination or target branch.
     */
    public final String commitId() {
        return commitId;
    }

    /**
     * <p>
     * The tree ID of the merge in the destination or target branch.
     * </p>
     * 
     * @return The tree ID of the merge in the destination or target branch.
     */
    public final String treeId() {
        return treeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(commitId());
        hashCode = 31 * hashCode + Objects.hashCode(treeId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergeBranchesByFastForwardResponse)) {
            return false;
        }
        MergeBranchesByFastForwardResponse other = (MergeBranchesByFastForwardResponse) obj;
        return Objects.equals(commitId(), other.commitId()) && Objects.equals(treeId(), other.treeId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MergeBranchesByFastForwardResponse").add("CommitId", commitId()).add("TreeId", treeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "commitId":
            return Optional.ofNullable(clazz.cast(commitId()));
        case "treeId":
            return Optional.ofNullable(clazz.cast(treeId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("commitId", COMMIT_ID_FIELD);
        map.put("treeId", TREE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MergeBranchesByFastForwardResponse, T> g) {
        return obj -> g.apply((MergeBranchesByFastForwardResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CodeCommitResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, MergeBranchesByFastForwardResponse> {
        /**
         * <p>
         * The commit ID of the merge in the destination or target branch.
         * </p>
         * 
         * @param commitId
         *        The commit ID of the merge in the destination or target branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitId(String commitId);

        /**
         * <p>
         * The tree ID of the merge in the destination or target branch.
         * </p>
         * 
         * @param treeId
         *        The tree ID of the merge in the destination or target branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treeId(String treeId);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private String commitId;

        private String treeId;

        private BuilderImpl() {
        }

        private BuilderImpl(MergeBranchesByFastForwardResponse model) {
            super(model);
            commitId(model.commitId);
            treeId(model.treeId);
        }

        public final String getCommitId() {
            return commitId;
        }

        public final void setCommitId(String commitId) {
            this.commitId = commitId;
        }

        @Override
        public final Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public final String getTreeId() {
            return treeId;
        }

        public final void setTreeId(String treeId) {
            this.treeId = treeId;
        }

        @Override
        public final Builder treeId(String treeId) {
            this.treeId = treeId;
            return this;
        }

        @Override
        public MergeBranchesByFastForwardResponse build() {
            return new MergeBranchesByFastForwardResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
