/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about the approval rules applied to a pull request and whether conditions have been met.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Evaluation implements SdkPojo, Serializable, ToCopyableBuilder<Evaluation.Builder, Evaluation> {
    private static final SdkField<Boolean> APPROVED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("approved").getter(getter(Evaluation::approved)).setter(setter(Builder::approved))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approved").build()).build();

    private static final SdkField<Boolean> OVERRIDDEN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("overridden").getter(getter(Evaluation::overridden)).setter(setter(Builder::overridden))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overridden").build()).build();

    private static final SdkField<List<String>> APPROVAL_RULES_SATISFIED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("approvalRulesSatisfied")
            .getter(getter(Evaluation::approvalRulesSatisfied))
            .setter(setter(Builder::approvalRulesSatisfied))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRulesSatisfied").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> APPROVAL_RULES_NOT_SATISFIED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("approvalRulesNotSatisfied")
            .getter(getter(Evaluation::approvalRulesNotSatisfied))
            .setter(setter(Builder::approvalRulesNotSatisfied))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRulesNotSatisfied").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPROVED_FIELD,
            OVERRIDDEN_FIELD, APPROVAL_RULES_SATISFIED_FIELD, APPROVAL_RULES_NOT_SATISFIED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean approved;

    private final Boolean overridden;

    private final List<String> approvalRulesSatisfied;

    private final List<String> approvalRulesNotSatisfied;

    private Evaluation(BuilderImpl builder) {
        this.approved = builder.approved;
        this.overridden = builder.overridden;
        this.approvalRulesSatisfied = builder.approvalRulesSatisfied;
        this.approvalRulesNotSatisfied = builder.approvalRulesNotSatisfied;
    }

    /**
     * <p>
     * Whether the state of the pull request is approved.
     * </p>
     * 
     * @return Whether the state of the pull request is approved.
     */
    public final Boolean approved() {
        return approved;
    }

    /**
     * <p>
     * Whether the approval rule requirements for the pull request have been overridden and no longer need to be met.
     * </p>
     * 
     * @return Whether the approval rule requirements for the pull request have been overridden and no longer need to be
     *         met.
     */
    public final Boolean overridden() {
        return overridden;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApprovalRulesSatisfied property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasApprovalRulesSatisfied() {
        return approvalRulesSatisfied != null && !(approvalRulesSatisfied instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the approval rules that have had their conditions met.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApprovalRulesSatisfied} method.
     * </p>
     * 
     * @return The names of the approval rules that have had their conditions met.
     */
    public final List<String> approvalRulesSatisfied() {
        return approvalRulesSatisfied;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApprovalRulesNotSatisfied property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasApprovalRulesNotSatisfied() {
        return approvalRulesNotSatisfied != null && !(approvalRulesNotSatisfied instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the approval rules that have not had their conditions met.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApprovalRulesNotSatisfied} method.
     * </p>
     * 
     * @return The names of the approval rules that have not had their conditions met.
     */
    public final List<String> approvalRulesNotSatisfied() {
        return approvalRulesNotSatisfied;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(approved());
        hashCode = 31 * hashCode + Objects.hashCode(overridden());
        hashCode = 31 * hashCode + Objects.hashCode(hasApprovalRulesSatisfied() ? approvalRulesSatisfied() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasApprovalRulesNotSatisfied() ? approvalRulesNotSatisfied() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Evaluation)) {
            return false;
        }
        Evaluation other = (Evaluation) obj;
        return Objects.equals(approved(), other.approved()) && Objects.equals(overridden(), other.overridden())
                && hasApprovalRulesSatisfied() == other.hasApprovalRulesSatisfied()
                && Objects.equals(approvalRulesSatisfied(), other.approvalRulesSatisfied())
                && hasApprovalRulesNotSatisfied() == other.hasApprovalRulesNotSatisfied()
                && Objects.equals(approvalRulesNotSatisfied(), other.approvalRulesNotSatisfied());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Evaluation").add("Approved", approved()).add("Overridden", overridden())
                .add("ApprovalRulesSatisfied", hasApprovalRulesSatisfied() ? approvalRulesSatisfied() : null)
                .add("ApprovalRulesNotSatisfied", hasApprovalRulesNotSatisfied() ? approvalRulesNotSatisfied() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "approved":
            return Optional.ofNullable(clazz.cast(approved()));
        case "overridden":
            return Optional.ofNullable(clazz.cast(overridden()));
        case "approvalRulesSatisfied":
            return Optional.ofNullable(clazz.cast(approvalRulesSatisfied()));
        case "approvalRulesNotSatisfied":
            return Optional.ofNullable(clazz.cast(approvalRulesNotSatisfied()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("approved", APPROVED_FIELD);
        map.put("overridden", OVERRIDDEN_FIELD);
        map.put("approvalRulesSatisfied", APPROVAL_RULES_SATISFIED_FIELD);
        map.put("approvalRulesNotSatisfied", APPROVAL_RULES_NOT_SATISFIED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Evaluation, T> g) {
        return obj -> g.apply((Evaluation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Evaluation> {
        /**
         * <p>
         * Whether the state of the pull request is approved.
         * </p>
         * 
         * @param approved
         *        Whether the state of the pull request is approved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approved(Boolean approved);

        /**
         * <p>
         * Whether the approval rule requirements for the pull request have been overridden and no longer need to be
         * met.
         * </p>
         * 
         * @param overridden
         *        Whether the approval rule requirements for the pull request have been overridden and no longer need to
         *        be met.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overridden(Boolean overridden);

        /**
         * <p>
         * The names of the approval rules that have had their conditions met.
         * </p>
         * 
         * @param approvalRulesSatisfied
         *        The names of the approval rules that have had their conditions met.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRulesSatisfied(Collection<String> approvalRulesSatisfied);

        /**
         * <p>
         * The names of the approval rules that have had their conditions met.
         * </p>
         * 
         * @param approvalRulesSatisfied
         *        The names of the approval rules that have had their conditions met.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRulesSatisfied(String... approvalRulesSatisfied);

        /**
         * <p>
         * The names of the approval rules that have not had their conditions met.
         * </p>
         * 
         * @param approvalRulesNotSatisfied
         *        The names of the approval rules that have not had their conditions met.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRulesNotSatisfied(Collection<String> approvalRulesNotSatisfied);

        /**
         * <p>
         * The names of the approval rules that have not had their conditions met.
         * </p>
         * 
         * @param approvalRulesNotSatisfied
         *        The names of the approval rules that have not had their conditions met.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRulesNotSatisfied(String... approvalRulesNotSatisfied);
    }

    static final class BuilderImpl implements Builder {
        private Boolean approved;

        private Boolean overridden;

        private List<String> approvalRulesSatisfied = DefaultSdkAutoConstructList.getInstance();

        private List<String> approvalRulesNotSatisfied = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Evaluation model) {
            approved(model.approved);
            overridden(model.overridden);
            approvalRulesSatisfied(model.approvalRulesSatisfied);
            approvalRulesNotSatisfied(model.approvalRulesNotSatisfied);
        }

        public final Boolean getApproved() {
            return approved;
        }

        public final void setApproved(Boolean approved) {
            this.approved = approved;
        }

        @Override
        public final Builder approved(Boolean approved) {
            this.approved = approved;
            return this;
        }

        public final Boolean getOverridden() {
            return overridden;
        }

        public final void setOverridden(Boolean overridden) {
            this.overridden = overridden;
        }

        @Override
        public final Builder overridden(Boolean overridden) {
            this.overridden = overridden;
            return this;
        }

        public final Collection<String> getApprovalRulesSatisfied() {
            if (approvalRulesSatisfied instanceof SdkAutoConstructList) {
                return null;
            }
            return approvalRulesSatisfied;
        }

        public final void setApprovalRulesSatisfied(Collection<String> approvalRulesSatisfied) {
            this.approvalRulesSatisfied = ApprovalRulesSatisfiedListCopier.copy(approvalRulesSatisfied);
        }

        @Override
        public final Builder approvalRulesSatisfied(Collection<String> approvalRulesSatisfied) {
            this.approvalRulesSatisfied = ApprovalRulesSatisfiedListCopier.copy(approvalRulesSatisfied);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvalRulesSatisfied(String... approvalRulesSatisfied) {
            approvalRulesSatisfied(Arrays.asList(approvalRulesSatisfied));
            return this;
        }

        public final Collection<String> getApprovalRulesNotSatisfied() {
            if (approvalRulesNotSatisfied instanceof SdkAutoConstructList) {
                return null;
            }
            return approvalRulesNotSatisfied;
        }

        public final void setApprovalRulesNotSatisfied(Collection<String> approvalRulesNotSatisfied) {
            this.approvalRulesNotSatisfied = ApprovalRulesNotSatisfiedListCopier.copy(approvalRulesNotSatisfied);
        }

        @Override
        public final Builder approvalRulesNotSatisfied(Collection<String> approvalRulesNotSatisfied) {
            this.approvalRulesNotSatisfied = ApprovalRulesNotSatisfiedListCopier.copy(approvalRulesNotSatisfied);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvalRulesNotSatisfied(String... approvalRulesNotSatisfied) {
            approvalRulesNotSatisfied(Arrays.asList(approvalRulesNotSatisfied));
            return this;
        }

        @Override
        public Evaluation build() {
            return new Evaluation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
