/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecatalyst.model.CodeCatalystResponse;
import software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentAccessDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartDevEnvironmentSessionResponse
extends CodeCatalystResponse
implements ToCopyableBuilder<Builder, StartDevEnvironmentSessionResponse> {
    private static final SdkField<DevEnvironmentAccessDetails> ACCESS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("accessDetails").getter(StartDevEnvironmentSessionResponse.getter(StartDevEnvironmentSessionResponse::accessDetails)).setter(StartDevEnvironmentSessionResponse.setter(Builder::accessDetails)).constructor(DevEnvironmentAccessDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessDetails").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(StartDevEnvironmentSessionResponse.getter(StartDevEnvironmentSessionResponse::sessionId)).setter(StartDevEnvironmentSessionResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<String> SPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spaceName").getter(StartDevEnvironmentSessionResponse.getter(StartDevEnvironmentSessionResponse::spaceName)).setter(StartDevEnvironmentSessionResponse.setter(Builder::spaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spaceName").build()}).build();
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectName").getter(StartDevEnvironmentSessionResponse.getter(StartDevEnvironmentSessionResponse::projectName)).setter(StartDevEnvironmentSessionResponse.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(StartDevEnvironmentSessionResponse.getter(StartDevEnvironmentSessionResponse::id)).setter(StartDevEnvironmentSessionResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_DETAILS_FIELD, SESSION_ID_FIELD, SPACE_NAME_FIELD, PROJECT_NAME_FIELD, ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartDevEnvironmentSessionResponse.memberNameToFieldInitializer();
    private final DevEnvironmentAccessDetails accessDetails;
    private final String sessionId;
    private final String spaceName;
    private final String projectName;
    private final String id;

    private StartDevEnvironmentSessionResponse(BuilderImpl builder) {
        super(builder);
        this.accessDetails = builder.accessDetails;
        this.sessionId = builder.sessionId;
        this.spaceName = builder.spaceName;
        this.projectName = builder.projectName;
        this.id = builder.id;
    }

    public final DevEnvironmentAccessDetails accessDetails() {
        return this.accessDetails;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String spaceName() {
        return this.spaceName;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final String id() {
        return this.id;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accessDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDevEnvironmentSessionResponse)) {
            return false;
        }
        StartDevEnvironmentSessionResponse other = (StartDevEnvironmentSessionResponse)((Object)obj);
        return Objects.equals(this.accessDetails(), other.accessDetails()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.spaceName(), other.spaceName()) && Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.id(), other.id());
    }

    public final String toString() {
        return ToString.builder((String)"StartDevEnvironmentSessionResponse").add("AccessDetails", (Object)(this.accessDetails() == null ? null : "*** Sensitive Data Redacted ***")).add("SessionId", (Object)this.sessionId()).add("SpaceName", (Object)this.spaceName()).add("ProjectName", (Object)this.projectName()).add("Id", (Object)this.id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessDetails": {
                return Optional.ofNullable(clazz.cast(this.accessDetails()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "spaceName": {
                return Optional.ofNullable(clazz.cast(this.spaceName()));
            }
            case "projectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accessDetails", ACCESS_DETAILS_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("spaceName", SPACE_NAME_FIELD);
        map.put("projectName", PROJECT_NAME_FIELD);
        map.put("id", ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartDevEnvironmentSessionResponse, T> g) {
        return obj -> g.apply((StartDevEnvironmentSessionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCatalystResponse.BuilderImpl
    implements Builder {
        private DevEnvironmentAccessDetails accessDetails;
        private String sessionId;
        private String spaceName;
        private String projectName;
        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDevEnvironmentSessionResponse model) {
            super(model);
            this.accessDetails(model.accessDetails);
            this.sessionId(model.sessionId);
            this.spaceName(model.spaceName);
            this.projectName(model.projectName);
            this.id(model.id);
        }

        public final DevEnvironmentAccessDetails.Builder getAccessDetails() {
            return this.accessDetails != null ? this.accessDetails.toBuilder() : null;
        }

        public final void setAccessDetails(DevEnvironmentAccessDetails.BuilderImpl accessDetails) {
            this.accessDetails = accessDetails != null ? accessDetails.build() : null;
        }

        @Override
        public final Builder accessDetails(DevEnvironmentAccessDetails accessDetails) {
            this.accessDetails = accessDetails;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getSpaceName() {
            return this.spaceName;
        }

        public final void setSpaceName(String spaceName) {
            this.spaceName = spaceName;
        }

        @Override
        public final Builder spaceName(String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public StartDevEnvironmentSessionResponse build() {
            return new StartDevEnvironmentSessionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeCatalystResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartDevEnvironmentSessionResponse> {
        public Builder accessDetails(DevEnvironmentAccessDetails var1);

        default public Builder accessDetails(Consumer<DevEnvironmentAccessDetails.Builder> accessDetails) {
            return this.accessDetails((DevEnvironmentAccessDetails)((DevEnvironmentAccessDetails.Builder)DevEnvironmentAccessDetails.builder().applyMutation(accessDetails)).build());
        }

        public Builder sessionId(String var1);

        public Builder spaceName(String var1);

        public Builder projectName(String var1);

        public Builder id(String var1);
    }
}

