/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecatalyst.CodeCatalystAsyncClient;
import software.amazon.awssdk.services.codecatalyst.internal.UserAgentUtils;
import software.amazon.awssdk.services.codecatalyst.model.AccessTokenSummary;
import software.amazon.awssdk.services.codecatalyst.model.ListAccessTokensRequest;
import software.amazon.awssdk.services.codecatalyst.model.ListAccessTokensResponse;

public class ListAccessTokensPublisher
implements SdkPublisher<ListAccessTokensResponse> {
    private final CodeCatalystAsyncClient client;
    private final ListAccessTokensRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccessTokensPublisher(CodeCatalystAsyncClient client, ListAccessTokensRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccessTokensPublisher(CodeCatalystAsyncClient client, ListAccessTokensRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccessTokensResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccessTokensResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AccessTokenSummary> items() {
        Function<ListAccessTokensResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAccessTokensResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAccessTokensResponseFetcher
    implements AsyncPageFetcher<ListAccessTokensResponse> {
        private ListAccessTokensResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessTokensResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAccessTokensResponse> nextPage(ListAccessTokensResponse previousPage) {
            if (previousPage == null) {
                return ListAccessTokensPublisher.this.client.listAccessTokens(ListAccessTokensPublisher.this.firstRequest);
            }
            return ListAccessTokensPublisher.this.client.listAccessTokens((ListAccessTokensRequest)((Object)ListAccessTokensPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

