/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecatalyst.model.CodeCatalystResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDevEnvironmentResponse
extends CodeCatalystResponse
implements ToCopyableBuilder<Builder, CreateDevEnvironmentResponse> {
    private static final SdkField<String> SPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spaceName").getter(CreateDevEnvironmentResponse.getter(CreateDevEnvironmentResponse::spaceName)).setter(CreateDevEnvironmentResponse.setter(Builder::spaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spaceName").build()}).build();
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectName").getter(CreateDevEnvironmentResponse.getter(CreateDevEnvironmentResponse::projectName)).setter(CreateDevEnvironmentResponse.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(CreateDevEnvironmentResponse.getter(CreateDevEnvironmentResponse::id)).setter(CreateDevEnvironmentResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> VPC_CONNECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vpcConnectionName").getter(CreateDevEnvironmentResponse.getter(CreateDevEnvironmentResponse::vpcConnectionName)).setter(CreateDevEnvironmentResponse.setter(Builder::vpcConnectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConnectionName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPACE_NAME_FIELD, PROJECT_NAME_FIELD, ID_FIELD, VPC_CONNECTION_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDevEnvironmentResponse.memberNameToFieldInitializer();
    private final String spaceName;
    private final String projectName;
    private final String id;
    private final String vpcConnectionName;

    private CreateDevEnvironmentResponse(BuilderImpl builder) {
        super(builder);
        this.spaceName = builder.spaceName;
        this.projectName = builder.projectName;
        this.id = builder.id;
        this.vpcConnectionName = builder.vpcConnectionName;
    }

    public final String spaceName() {
        return this.spaceName;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final String id() {
        return this.id;
    }

    public final String vpcConnectionName() {
        return this.vpcConnectionName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConnectionName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDevEnvironmentResponse)) {
            return false;
        }
        CreateDevEnvironmentResponse other = (CreateDevEnvironmentResponse)((Object)obj);
        return Objects.equals(this.spaceName(), other.spaceName()) && Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.vpcConnectionName(), other.vpcConnectionName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDevEnvironmentResponse").add("SpaceName", (Object)this.spaceName()).add("ProjectName", (Object)this.projectName()).add("Id", (Object)this.id()).add("VpcConnectionName", (Object)this.vpcConnectionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "spaceName": {
                return Optional.ofNullable(clazz.cast(this.spaceName()));
            }
            case "projectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "vpcConnectionName": {
                return Optional.ofNullable(clazz.cast(this.vpcConnectionName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("spaceName", SPACE_NAME_FIELD);
        map.put("projectName", PROJECT_NAME_FIELD);
        map.put("id", ID_FIELD);
        map.put("vpcConnectionName", VPC_CONNECTION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDevEnvironmentResponse, T> g) {
        return obj -> g.apply((CreateDevEnvironmentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCatalystResponse.BuilderImpl
    implements Builder {
        private String spaceName;
        private String projectName;
        private String id;
        private String vpcConnectionName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDevEnvironmentResponse model) {
            super(model);
            this.spaceName(model.spaceName);
            this.projectName(model.projectName);
            this.id(model.id);
            this.vpcConnectionName(model.vpcConnectionName);
        }

        public final String getSpaceName() {
            return this.spaceName;
        }

        public final void setSpaceName(String spaceName) {
            this.spaceName = spaceName;
        }

        @Override
        public final Builder spaceName(String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getVpcConnectionName() {
            return this.vpcConnectionName;
        }

        public final void setVpcConnectionName(String vpcConnectionName) {
            this.vpcConnectionName = vpcConnectionName;
        }

        @Override
        public final Builder vpcConnectionName(String vpcConnectionName) {
            this.vpcConnectionName = vpcConnectionName;
            return this;
        }

        @Override
        public CreateDevEnvironmentResponse build() {
            return new CreateDevEnvironmentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeCatalystResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDevEnvironmentResponse> {
        public Builder spaceName(String var1);

        public Builder projectName(String var1);

        public Builder id(String var1);

        public Builder vpcConnectionName(String var1);
    }
}

