/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecatalyst.model.CodeCatalystRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartWorkflowRunRequest
extends CodeCatalystRequest
implements ToCopyableBuilder<Builder, StartWorkflowRunRequest> {
    private static final SdkField<String> SPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spaceName").getter(StartWorkflowRunRequest.getter(StartWorkflowRunRequest::spaceName)).setter(StartWorkflowRunRequest.setter(Builder::spaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("spaceName").build()}).build();
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectName").getter(StartWorkflowRunRequest.getter(StartWorkflowRunRequest::projectName)).setter(StartWorkflowRunRequest.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("projectName").build()}).build();
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowId").getter(StartWorkflowRunRequest.getter(StartWorkflowRunRequest::workflowId)).setter(StartWorkflowRunRequest.setter(Builder::workflowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("workflowId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(StartWorkflowRunRequest.getter(StartWorkflowRunRequest::clientToken)).setter(StartWorkflowRunRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPACE_NAME_FIELD, PROJECT_NAME_FIELD, WORKFLOW_ID_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartWorkflowRunRequest.memberNameToFieldInitializer();
    private final String spaceName;
    private final String projectName;
    private final String workflowId;
    private final String clientToken;

    private StartWorkflowRunRequest(BuilderImpl builder) {
        super(builder);
        this.spaceName = builder.spaceName;
        this.projectName = builder.projectName;
        this.workflowId = builder.workflowId;
        this.clientToken = builder.clientToken;
    }

    public final String spaceName() {
        return this.spaceName;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final String workflowId() {
        return this.workflowId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartWorkflowRunRequest)) {
            return false;
        }
        StartWorkflowRunRequest other = (StartWorkflowRunRequest)((Object)obj);
        return Objects.equals(this.spaceName(), other.spaceName()) && Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.workflowId(), other.workflowId()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"StartWorkflowRunRequest").add("SpaceName", (Object)this.spaceName()).add("ProjectName", (Object)this.projectName()).add("WorkflowId", (Object)this.workflowId()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "spaceName": {
                return Optional.ofNullable(clazz.cast(this.spaceName()));
            }
            case "projectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "workflowId": {
                return Optional.ofNullable(clazz.cast(this.workflowId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("spaceName", SPACE_NAME_FIELD);
        map.put("projectName", PROJECT_NAME_FIELD);
        map.put("workflowId", WORKFLOW_ID_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartWorkflowRunRequest, T> g) {
        return obj -> g.apply((StartWorkflowRunRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCatalystRequest.BuilderImpl
    implements Builder {
        private String spaceName;
        private String projectName;
        private String workflowId;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartWorkflowRunRequest model) {
            super(model);
            this.spaceName(model.spaceName);
            this.projectName(model.projectName);
            this.workflowId(model.workflowId);
            this.clientToken(model.clientToken);
        }

        public final String getSpaceName() {
            return this.spaceName;
        }

        public final void setSpaceName(String spaceName) {
            this.spaceName = spaceName;
        }

        @Override
        public final Builder spaceName(String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getWorkflowId() {
            return this.workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartWorkflowRunRequest build() {
            return new StartWorkflowRunRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeCatalystRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartWorkflowRunRequest> {
        public Builder spaceName(String var1);

        public Builder projectName(String var1);

        public Builder workflowId(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

