/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecatalyst.CodeCatalystClient;
import software.amazon.awssdk.services.codecatalyst.internal.UserAgentUtils;
import software.amazon.awssdk.services.codecatalyst.model.AccessTokenSummary;
import software.amazon.awssdk.services.codecatalyst.model.ListAccessTokensRequest;
import software.amazon.awssdk.services.codecatalyst.model.ListAccessTokensResponse;

public class ListAccessTokensIterable
implements SdkIterable<ListAccessTokensResponse> {
    private final CodeCatalystClient client;
    private final ListAccessTokensRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccessTokensIterable(CodeCatalystClient client, ListAccessTokensRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAccessTokensResponseFetcher();
    }

    public Iterator<ListAccessTokensResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccessTokenSummary> items() {
        Function<ListAccessTokensResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAccessTokensResponseFetcher
    implements SyncPageFetcher<ListAccessTokensResponse> {
        private ListAccessTokensResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessTokensResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAccessTokensResponse nextPage(ListAccessTokensResponse previousPage) {
            if (previousPage == null) {
                return ListAccessTokensIterable.this.client.listAccessTokens(ListAccessTokensIterable.this.firstRequest);
            }
            return ListAccessTokensIterable.this.client.listAccessTokens((ListAccessTokensRequest)((Object)ListAccessTokensIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

