/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecatalyst.model.CodeCatalystRequest;
import software.amazon.awssdk.services.codecatalyst.model.IdeConfiguration;
import software.amazon.awssdk.services.codecatalyst.model.IdeConfigurationListCopier;
import software.amazon.awssdk.services.codecatalyst.model.InstanceType;
import software.amazon.awssdk.services.codecatalyst.model.PersistentStorageConfiguration;
import software.amazon.awssdk.services.codecatalyst.model.RepositoriesInputCopier;
import software.amazon.awssdk.services.codecatalyst.model.RepositoryInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDevEnvironmentRequest
extends CodeCatalystRequest
implements ToCopyableBuilder<Builder, CreateDevEnvironmentRequest> {
    private static final SdkField<String> SPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spaceName").getter(CreateDevEnvironmentRequest.getter(CreateDevEnvironmentRequest::spaceName)).setter(CreateDevEnvironmentRequest.setter(Builder::spaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("spaceName").build()}).build();
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectName").getter(CreateDevEnvironmentRequest.getter(CreateDevEnvironmentRequest::projectName)).setter(CreateDevEnvironmentRequest.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("projectName").build()}).build();
    private static final SdkField<List<RepositoryInput>> REPOSITORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("repositories").getter(CreateDevEnvironmentRequest.getter(CreateDevEnvironmentRequest::repositories)).setter(CreateDevEnvironmentRequest.setter(Builder::repositories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RepositoryInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateDevEnvironmentRequest.getter(CreateDevEnvironmentRequest::clientToken)).setter(CreateDevEnvironmentRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alias").getter(CreateDevEnvironmentRequest.getter(CreateDevEnvironmentRequest::alias)).setter(CreateDevEnvironmentRequest.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()}).build();
    private static final SdkField<List<IdeConfiguration>> IDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ides").getter(CreateDevEnvironmentRequest.getter(CreateDevEnvironmentRequest::ides)).setter(CreateDevEnvironmentRequest.setter(Builder::ides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ides").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IdeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceType").getter(CreateDevEnvironmentRequest.getter(CreateDevEnvironmentRequest::instanceTypeAsString)).setter(CreateDevEnvironmentRequest.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final SdkField<Integer> INACTIVITY_TIMEOUT_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("inactivityTimeoutMinutes").getter(CreateDevEnvironmentRequest.getter(CreateDevEnvironmentRequest::inactivityTimeoutMinutes)).setter(CreateDevEnvironmentRequest.setter(Builder::inactivityTimeoutMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inactivityTimeoutMinutes").build()}).build();
    private static final SdkField<PersistentStorageConfiguration> PERSISTENT_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("persistentStorage").getter(CreateDevEnvironmentRequest.getter(CreateDevEnvironmentRequest::persistentStorage)).setter(CreateDevEnvironmentRequest.setter(Builder::persistentStorage)).constructor(PersistentStorageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("persistentStorage").build()}).build();
    private static final SdkField<String> VPC_CONNECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vpcConnectionName").getter(CreateDevEnvironmentRequest.getter(CreateDevEnvironmentRequest::vpcConnectionName)).setter(CreateDevEnvironmentRequest.setter(Builder::vpcConnectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConnectionName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPACE_NAME_FIELD, PROJECT_NAME_FIELD, REPOSITORIES_FIELD, CLIENT_TOKEN_FIELD, ALIAS_FIELD, IDES_FIELD, INSTANCE_TYPE_FIELD, INACTIVITY_TIMEOUT_MINUTES_FIELD, PERSISTENT_STORAGE_FIELD, VPC_CONNECTION_NAME_FIELD));
    private final String spaceName;
    private final String projectName;
    private final List<RepositoryInput> repositories;
    private final String clientToken;
    private final String alias;
    private final List<IdeConfiguration> ides;
    private final String instanceType;
    private final Integer inactivityTimeoutMinutes;
    private final PersistentStorageConfiguration persistentStorage;
    private final String vpcConnectionName;

    private CreateDevEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.spaceName = builder.spaceName;
        this.projectName = builder.projectName;
        this.repositories = builder.repositories;
        this.clientToken = builder.clientToken;
        this.alias = builder.alias;
        this.ides = builder.ides;
        this.instanceType = builder.instanceType;
        this.inactivityTimeoutMinutes = builder.inactivityTimeoutMinutes;
        this.persistentStorage = builder.persistentStorage;
        this.vpcConnectionName = builder.vpcConnectionName;
    }

    public final String spaceName() {
        return this.spaceName;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final boolean hasRepositories() {
        return this.repositories != null && !(this.repositories instanceof SdkAutoConstructList);
    }

    public final List<RepositoryInput> repositories() {
        return this.repositories;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String alias() {
        return this.alias;
    }

    public final boolean hasIdes() {
        return this.ides != null && !(this.ides instanceof SdkAutoConstructList);
    }

    public final List<IdeConfiguration> ides() {
        return this.ides;
    }

    public final InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final Integer inactivityTimeoutMinutes() {
        return this.inactivityTimeoutMinutes;
    }

    public final PersistentStorageConfiguration persistentStorage() {
        return this.persistentStorage;
    }

    public final String vpcConnectionName() {
        return this.vpcConnectionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRepositories() ? this.repositories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdes() ? this.ides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inactivityTimeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.persistentStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConnectionName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDevEnvironmentRequest)) {
            return false;
        }
        CreateDevEnvironmentRequest other = (CreateDevEnvironmentRequest)((Object)obj);
        return Objects.equals(this.spaceName(), other.spaceName()) && Objects.equals(this.projectName(), other.projectName()) && this.hasRepositories() == other.hasRepositories() && Objects.equals(this.repositories(), other.repositories()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.alias(), other.alias()) && this.hasIdes() == other.hasIdes() && Objects.equals(this.ides(), other.ides()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.inactivityTimeoutMinutes(), other.inactivityTimeoutMinutes()) && Objects.equals(this.persistentStorage(), other.persistentStorage()) && Objects.equals(this.vpcConnectionName(), other.vpcConnectionName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDevEnvironmentRequest").add("SpaceName", (Object)this.spaceName()).add("ProjectName", (Object)this.projectName()).add("Repositories", this.hasRepositories() ? this.repositories() : null).add("ClientToken", (Object)this.clientToken()).add("Alias", (Object)this.alias()).add("Ides", this.hasIdes() ? this.ides() : null).add("InstanceType", (Object)this.instanceTypeAsString()).add("InactivityTimeoutMinutes", (Object)this.inactivityTimeoutMinutes()).add("PersistentStorage", (Object)this.persistentStorage()).add("VpcConnectionName", (Object)this.vpcConnectionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "spaceName": {
                return Optional.ofNullable(clazz.cast(this.spaceName()));
            }
            case "projectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "repositories": {
                return Optional.ofNullable(clazz.cast(this.repositories()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "ides": {
                return Optional.ofNullable(clazz.cast(this.ides()));
            }
            case "instanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "inactivityTimeoutMinutes": {
                return Optional.ofNullable(clazz.cast(this.inactivityTimeoutMinutes()));
            }
            case "persistentStorage": {
                return Optional.ofNullable(clazz.cast(this.persistentStorage()));
            }
            case "vpcConnectionName": {
                return Optional.ofNullable(clazz.cast(this.vpcConnectionName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDevEnvironmentRequest, T> g) {
        return obj -> g.apply((CreateDevEnvironmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCatalystRequest.BuilderImpl
    implements Builder {
        private String spaceName;
        private String projectName;
        private List<RepositoryInput> repositories = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private String alias;
        private List<IdeConfiguration> ides = DefaultSdkAutoConstructList.getInstance();
        private String instanceType;
        private Integer inactivityTimeoutMinutes;
        private PersistentStorageConfiguration persistentStorage;
        private String vpcConnectionName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDevEnvironmentRequest model) {
            super(model);
            this.spaceName(model.spaceName);
            this.projectName(model.projectName);
            this.repositories(model.repositories);
            this.clientToken(model.clientToken);
            this.alias(model.alias);
            this.ides(model.ides);
            this.instanceType(model.instanceType);
            this.inactivityTimeoutMinutes(model.inactivityTimeoutMinutes);
            this.persistentStorage(model.persistentStorage);
            this.vpcConnectionName(model.vpcConnectionName);
        }

        public final String getSpaceName() {
            return this.spaceName;
        }

        public final void setSpaceName(String spaceName) {
            this.spaceName = spaceName;
        }

        @Override
        public final Builder spaceName(String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final List<RepositoryInput.Builder> getRepositories() {
            List<RepositoryInput.Builder> result = RepositoriesInputCopier.copyToBuilder(this.repositories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRepositories(Collection<RepositoryInput.BuilderImpl> repositories) {
            this.repositories = RepositoriesInputCopier.copyFromBuilder(repositories);
        }

        @Override
        public final Builder repositories(Collection<RepositoryInput> repositories) {
            this.repositories = RepositoriesInputCopier.copy(repositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositories(RepositoryInput ... repositories) {
            this.repositories(Arrays.asList(repositories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositories(Consumer<RepositoryInput.Builder> ... repositories) {
            this.repositories(Stream.of(repositories).map(c -> (RepositoryInput)((RepositoryInput.Builder)RepositoryInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final List<IdeConfiguration.Builder> getIdes() {
            List<IdeConfiguration.Builder> result = IdeConfigurationListCopier.copyToBuilder(this.ides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdes(Collection<IdeConfiguration.BuilderImpl> ides) {
            this.ides = IdeConfigurationListCopier.copyFromBuilder(ides);
        }

        @Override
        public final Builder ides(Collection<IdeConfiguration> ides) {
            this.ides = IdeConfigurationListCopier.copy(ides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ides(IdeConfiguration ... ides) {
            this.ides(Arrays.asList(ides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ides(Consumer<IdeConfiguration.Builder> ... ides) {
            this.ides(Stream.of(ides).map(c -> (IdeConfiguration)((IdeConfiguration.Builder)IdeConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Integer getInactivityTimeoutMinutes() {
            return this.inactivityTimeoutMinutes;
        }

        public final void setInactivityTimeoutMinutes(Integer inactivityTimeoutMinutes) {
            this.inactivityTimeoutMinutes = inactivityTimeoutMinutes;
        }

        @Override
        public final Builder inactivityTimeoutMinutes(Integer inactivityTimeoutMinutes) {
            this.inactivityTimeoutMinutes = inactivityTimeoutMinutes;
            return this;
        }

        public final PersistentStorageConfiguration.Builder getPersistentStorage() {
            return this.persistentStorage != null ? this.persistentStorage.toBuilder() : null;
        }

        public final void setPersistentStorage(PersistentStorageConfiguration.BuilderImpl persistentStorage) {
            this.persistentStorage = persistentStorage != null ? persistentStorage.build() : null;
        }

        @Override
        public final Builder persistentStorage(PersistentStorageConfiguration persistentStorage) {
            this.persistentStorage = persistentStorage;
            return this;
        }

        public final String getVpcConnectionName() {
            return this.vpcConnectionName;
        }

        public final void setVpcConnectionName(String vpcConnectionName) {
            this.vpcConnectionName = vpcConnectionName;
        }

        @Override
        public final Builder vpcConnectionName(String vpcConnectionName) {
            this.vpcConnectionName = vpcConnectionName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDevEnvironmentRequest build() {
            return new CreateDevEnvironmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCatalystRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDevEnvironmentRequest> {
        public Builder spaceName(String var1);

        public Builder projectName(String var1);

        public Builder repositories(Collection<RepositoryInput> var1);

        public Builder repositories(RepositoryInput ... var1);

        public Builder repositories(Consumer<RepositoryInput.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder alias(String var1);

        public Builder ides(Collection<IdeConfiguration> var1);

        public Builder ides(IdeConfiguration ... var1);

        public Builder ides(Consumer<IdeConfiguration.Builder> ... var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder inactivityTimeoutMinutes(Integer var1);

        public Builder persistentStorage(PersistentStorageConfiguration var1);

        default public Builder persistentStorage(Consumer<PersistentStorageConfiguration.Builder> persistentStorage) {
            return this.persistentStorage((PersistentStorageConfiguration)((PersistentStorageConfiguration.Builder)PersistentStorageConfiguration.builder().applyMutation(persistentStorage)).build());
        }

        public Builder vpcConnectionName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

