/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.credentials.TokenUtils;
import software.amazon.awssdk.auth.token.credentials.aws.DefaultAwsTokenProvider;
import software.amazon.awssdk.awscore.client.builder.AwsDefaultClientBuilder;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.awssdk.http.auth.scheme.BearerAuthScheme;
import software.amazon.awssdk.http.auth.scheme.NoAuthAuthScheme;
import software.amazon.awssdk.http.auth.spi.scheme.AuthScheme;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.identity.spi.IdentityProviders;
import software.amazon.awssdk.identity.spi.TokenIdentity;
import software.amazon.awssdk.services.codecatalyst.CodeCatalystBaseClientBuilder;
import software.amazon.awssdk.services.codecatalyst.auth.scheme.CodeCatalystAuthSchemeProvider;
import software.amazon.awssdk.services.codecatalyst.auth.scheme.internal.CodeCatalystAuthSchemeInterceptor;
import software.amazon.awssdk.services.codecatalyst.endpoints.CodeCatalystEndpointProvider;
import software.amazon.awssdk.services.codecatalyst.endpoints.internal.CodeCatalystRequestSetEndpointInterceptor;
import software.amazon.awssdk.services.codecatalyst.endpoints.internal.CodeCatalystResolveEndpointInterceptor;
import software.amazon.awssdk.services.codecatalyst.internal.CodeCatalystServiceClientConfigurationBuilder;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
abstract class DefaultCodeCatalystBaseClientBuilder<B extends CodeCatalystBaseClientBuilder<B, C>, C>
extends AwsDefaultClientBuilder<B, C> {
    private final Map<String, AuthScheme<?>> additionalAuthSchemes = new HashMap();

    DefaultCodeCatalystBaseClientBuilder() {
    }

    protected final String serviceEndpointPrefix() {
        return "codecatalyst";
    }

    protected final String serviceName() {
        return "CodeCatalyst";
    }

    protected final SdkClientConfiguration mergeServiceDefaults(SdkClientConfiguration config) {
        return config.merge(c -> c.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)this.defaultEndpointProvider()).option((ClientOption)SdkClientOption.AUTH_SCHEME_PROVIDER, (Object)this.defaultAuthSchemeProvider()).option((ClientOption)SdkClientOption.AUTH_SCHEMES, this.authSchemes()).option((ClientOption)SdkClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED, (Object)false).lazyOption((ClientOption)AwsClientOption.TOKEN_PROVIDER, p -> TokenUtils.toSdkTokenProvider((IdentityProvider)((IdentityProvider)p.get((AttributeMap.Key)AwsClientOption.TOKEN_IDENTITY_PROVIDER)))).option((ClientOption)AwsClientOption.TOKEN_IDENTITY_PROVIDER, this.defaultTokenProvider()));
    }

    protected final SdkClientConfiguration finalizeServiceConfiguration(SdkClientConfiguration config) {
        ArrayList<Object> endpointInterceptors = new ArrayList<Object>();
        endpointInterceptors.add(new CodeCatalystAuthSchemeInterceptor());
        endpointInterceptors.add(new CodeCatalystResolveEndpointInterceptor());
        endpointInterceptors.add(new CodeCatalystRequestSetEndpointInterceptor());
        ClasspathInterceptorChainFactory interceptorFactory = new ClasspathInterceptorChainFactory();
        List interceptors = interceptorFactory.getInterceptors("software/amazon/awssdk/services/codecatalyst/execution.interceptors");
        ArrayList additionalInterceptors = new ArrayList();
        interceptors = CollectionUtils.mergeLists(endpointInterceptors, (List)interceptors);
        interceptors = CollectionUtils.mergeLists((List)interceptors, additionalInterceptors);
        interceptors = CollectionUtils.mergeLists((List)interceptors, (List)((List)config.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS)));
        SdkClientConfiguration.Builder builder = config.toBuilder();
        builder.lazyOption((ClientOption)SdkClientOption.IDENTITY_PROVIDERS, c -> {
            IdentityProviders.Builder result = IdentityProviders.builder();
            IdentityProvider tokenIdentityProvider = (IdentityProvider)c.get((AttributeMap.Key)AwsClientOption.TOKEN_IDENTITY_PROVIDER);
            if (tokenIdentityProvider != null) {
                result.putIdentityProvider(tokenIdentityProvider);
            }
            return (IdentityProviders)result.build();
        });
        builder.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS, (Object)interceptors);
        return builder.build();
    }

    protected final String signingName() {
        return "codecatalyst";
    }

    private CodeCatalystEndpointProvider defaultEndpointProvider() {
        return CodeCatalystEndpointProvider.defaultProvider();
    }

    public B authSchemeProvider(CodeCatalystAuthSchemeProvider authSchemeProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.AUTH_SCHEME_PROVIDER, (Object)authSchemeProvider);
        return (B)((CodeCatalystBaseClientBuilder)this.thisBuilder());
    }

    private CodeCatalystAuthSchemeProvider defaultAuthSchemeProvider() {
        return CodeCatalystAuthSchemeProvider.defaultProvider();
    }

    public B putAuthScheme(AuthScheme<?> authScheme) {
        this.additionalAuthSchemes.put(authScheme.schemeId(), authScheme);
        return (B)((CodeCatalystBaseClientBuilder)this.thisBuilder());
    }

    private Map<String, AuthScheme<?>> authSchemes() {
        HashMap schemes = new HashMap(2 + this.additionalAuthSchemes.size());
        BearerAuthScheme bearerAuthScheme = BearerAuthScheme.create();
        schemes.put(bearerAuthScheme.schemeId(), (AuthScheme<?>)bearerAuthScheme);
        NoAuthAuthScheme noAuthAuthScheme = NoAuthAuthScheme.create();
        schemes.put(noAuthAuthScheme.schemeId(), (AuthScheme<?>)noAuthAuthScheme);
        schemes.putAll(this.additionalAuthSchemes);
        return schemes;
    }

    private IdentityProvider<? extends TokenIdentity> defaultTokenProvider() {
        return DefaultAwsTokenProvider.create();
    }

    protected SdkClientConfiguration invokePlugins(SdkClientConfiguration config) {
        List<SdkPlugin> internalPlugins = this.internalPlugins();
        List externalPlugins = this.plugins();
        if (internalPlugins.isEmpty() && externalPlugins.isEmpty()) {
            return config;
        }
        List plugins = CollectionUtils.mergeLists(internalPlugins, (List)externalPlugins);
        SdkClientConfiguration.Builder configuration = config.toBuilder();
        CodeCatalystServiceClientConfigurationBuilder serviceConfigBuilder = new CodeCatalystServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        return configuration.build();
    }

    private List<SdkPlugin> internalPlugins() {
        return Collections.emptyList();
    }

    protected static void validateClientOptions(SdkClientConfiguration c) {
        Validate.notNull((Object)((IdentityProvider)c.option((ClientOption)AwsClientOption.TOKEN_IDENTITY_PROVIDER)), (String)"The 'tokenProvider' must be configured in the client builder.", (Object[])new Object[0]);
    }
}

