/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentRepositorySummariesCopier;
import software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentRepositorySummary;
import software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentStatus;
import software.amazon.awssdk.services.codecatalyst.model.Ide;
import software.amazon.awssdk.services.codecatalyst.model.IdesCopier;
import software.amazon.awssdk.services.codecatalyst.model.InstanceType;
import software.amazon.awssdk.services.codecatalyst.model.PersistentStorage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DevEnvironmentSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DevEnvironmentSummary> {
    private static final SdkField<String> SPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spaceName").getter(DevEnvironmentSummary.getter(DevEnvironmentSummary::spaceName)).setter(DevEnvironmentSummary.setter(Builder::spaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spaceName").build()}).build();
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectName").getter(DevEnvironmentSummary.getter(DevEnvironmentSummary::projectName)).setter(DevEnvironmentSummary.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(DevEnvironmentSummary.getter(DevEnvironmentSummary::id)).setter(DevEnvironmentSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedTime").getter(DevEnvironmentSummary.getter(DevEnvironmentSummary::lastUpdatedTime)).setter(DevEnvironmentSummary.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("creatorId").getter(DevEnvironmentSummary.getter(DevEnvironmentSummary::creatorId)).setter(DevEnvironmentSummary.setter(Builder::creatorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creatorId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DevEnvironmentSummary.getter(DevEnvironmentSummary::statusAsString)).setter(DevEnvironmentSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(DevEnvironmentSummary.getter(DevEnvironmentSummary::statusReason)).setter(DevEnvironmentSummary.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<List<DevEnvironmentRepositorySummary>> REPOSITORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("repositories").getter(DevEnvironmentSummary.getter(DevEnvironmentSummary::repositories)).setter(DevEnvironmentSummary.setter(Builder::repositories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DevEnvironmentRepositorySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alias").getter(DevEnvironmentSummary.getter(DevEnvironmentSummary::alias)).setter(DevEnvironmentSummary.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()}).build();
    private static final SdkField<List<Ide>> IDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ides").getter(DevEnvironmentSummary.getter(DevEnvironmentSummary::ides)).setter(DevEnvironmentSummary.setter(Builder::ides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ides").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Ide::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceType").getter(DevEnvironmentSummary.getter(DevEnvironmentSummary::instanceTypeAsString)).setter(DevEnvironmentSummary.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final SdkField<Integer> INACTIVITY_TIMEOUT_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("inactivityTimeoutMinutes").getter(DevEnvironmentSummary.getter(DevEnvironmentSummary::inactivityTimeoutMinutes)).setter(DevEnvironmentSummary.setter(Builder::inactivityTimeoutMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inactivityTimeoutMinutes").build()}).build();
    private static final SdkField<PersistentStorage> PERSISTENT_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("persistentStorage").getter(DevEnvironmentSummary.getter(DevEnvironmentSummary::persistentStorage)).setter(DevEnvironmentSummary.setter(Builder::persistentStorage)).constructor(PersistentStorage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("persistentStorage").build()}).build();
    private static final SdkField<String> VPC_CONNECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vpcConnectionName").getter(DevEnvironmentSummary.getter(DevEnvironmentSummary::vpcConnectionName)).setter(DevEnvironmentSummary.setter(Builder::vpcConnectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConnectionName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPACE_NAME_FIELD, PROJECT_NAME_FIELD, ID_FIELD, LAST_UPDATED_TIME_FIELD, CREATOR_ID_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, REPOSITORIES_FIELD, ALIAS_FIELD, IDES_FIELD, INSTANCE_TYPE_FIELD, INACTIVITY_TIMEOUT_MINUTES_FIELD, PERSISTENT_STORAGE_FIELD, VPC_CONNECTION_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String spaceName;
    private final String projectName;
    private final String id;
    private final Instant lastUpdatedTime;
    private final String creatorId;
    private final String status;
    private final String statusReason;
    private final List<DevEnvironmentRepositorySummary> repositories;
    private final String alias;
    private final List<Ide> ides;
    private final String instanceType;
    private final Integer inactivityTimeoutMinutes;
    private final PersistentStorage persistentStorage;
    private final String vpcConnectionName;

    private DevEnvironmentSummary(BuilderImpl builder) {
        this.spaceName = builder.spaceName;
        this.projectName = builder.projectName;
        this.id = builder.id;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.creatorId = builder.creatorId;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.repositories = builder.repositories;
        this.alias = builder.alias;
        this.ides = builder.ides;
        this.instanceType = builder.instanceType;
        this.inactivityTimeoutMinutes = builder.inactivityTimeoutMinutes;
        this.persistentStorage = builder.persistentStorage;
        this.vpcConnectionName = builder.vpcConnectionName;
    }

    public final String spaceName() {
        return this.spaceName;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final String id() {
        return this.id;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final String creatorId() {
        return this.creatorId;
    }

    public final DevEnvironmentStatus status() {
        return DevEnvironmentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final boolean hasRepositories() {
        return this.repositories != null && !(this.repositories instanceof SdkAutoConstructList);
    }

    public final List<DevEnvironmentRepositorySummary> repositories() {
        return this.repositories;
    }

    public final String alias() {
        return this.alias;
    }

    public final boolean hasIdes() {
        return this.ides != null && !(this.ides instanceof SdkAutoConstructList);
    }

    public final List<Ide> ides() {
        return this.ides;
    }

    public final InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final Integer inactivityTimeoutMinutes() {
        return this.inactivityTimeoutMinutes;
    }

    public final PersistentStorage persistentStorage() {
        return this.persistentStorage;
    }

    public final String vpcConnectionName() {
        return this.vpcConnectionName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRepositories() ? this.repositories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdes() ? this.ides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inactivityTimeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.persistentStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConnectionName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DevEnvironmentSummary)) {
            return false;
        }
        DevEnvironmentSummary other = (DevEnvironmentSummary)obj;
        return Objects.equals(this.spaceName(), other.spaceName()) && Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.creatorId(), other.creatorId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && this.hasRepositories() == other.hasRepositories() && Objects.equals(this.repositories(), other.repositories()) && Objects.equals(this.alias(), other.alias()) && this.hasIdes() == other.hasIdes() && Objects.equals(this.ides(), other.ides()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.inactivityTimeoutMinutes(), other.inactivityTimeoutMinutes()) && Objects.equals(this.persistentStorage(), other.persistentStorage()) && Objects.equals(this.vpcConnectionName(), other.vpcConnectionName());
    }

    public final String toString() {
        return ToString.builder((String)"DevEnvironmentSummary").add("SpaceName", (Object)this.spaceName()).add("ProjectName", (Object)this.projectName()).add("Id", (Object)this.id()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("CreatorId", (Object)this.creatorId()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("Repositories", this.hasRepositories() ? this.repositories() : null).add("Alias", (Object)this.alias()).add("Ides", this.hasIdes() ? this.ides() : null).add("InstanceType", (Object)this.instanceTypeAsString()).add("InactivityTimeoutMinutes", (Object)this.inactivityTimeoutMinutes()).add("PersistentStorage", (Object)this.persistentStorage()).add("VpcConnectionName", (Object)this.vpcConnectionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "spaceName": {
                return Optional.ofNullable(clazz.cast(this.spaceName()));
            }
            case "projectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "creatorId": {
                return Optional.ofNullable(clazz.cast(this.creatorId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "repositories": {
                return Optional.ofNullable(clazz.cast(this.repositories()));
            }
            case "alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "ides": {
                return Optional.ofNullable(clazz.cast(this.ides()));
            }
            case "instanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "inactivityTimeoutMinutes": {
                return Optional.ofNullable(clazz.cast(this.inactivityTimeoutMinutes()));
            }
            case "persistentStorage": {
                return Optional.ofNullable(clazz.cast(this.persistentStorage()));
            }
            case "vpcConnectionName": {
                return Optional.ofNullable(clazz.cast(this.vpcConnectionName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DevEnvironmentSummary, T> g) {
        return obj -> g.apply((DevEnvironmentSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String spaceName;
        private String projectName;
        private String id;
        private Instant lastUpdatedTime;
        private String creatorId;
        private String status;
        private String statusReason;
        private List<DevEnvironmentRepositorySummary> repositories = DefaultSdkAutoConstructList.getInstance();
        private String alias;
        private List<Ide> ides = DefaultSdkAutoConstructList.getInstance();
        private String instanceType;
        private Integer inactivityTimeoutMinutes;
        private PersistentStorage persistentStorage;
        private String vpcConnectionName;

        private BuilderImpl() {
        }

        private BuilderImpl(DevEnvironmentSummary model) {
            this.spaceName(model.spaceName);
            this.projectName(model.projectName);
            this.id(model.id);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.creatorId(model.creatorId);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.repositories(model.repositories);
            this.alias(model.alias);
            this.ides(model.ides);
            this.instanceType(model.instanceType);
            this.inactivityTimeoutMinutes(model.inactivityTimeoutMinutes);
            this.persistentStorage(model.persistentStorage);
            this.vpcConnectionName(model.vpcConnectionName);
        }

        public final String getSpaceName() {
            return this.spaceName;
        }

        public final void setSpaceName(String spaceName) {
            this.spaceName = spaceName;
        }

        @Override
        public final Builder spaceName(String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getCreatorId() {
            return this.creatorId;
        }

        public final void setCreatorId(String creatorId) {
            this.creatorId = creatorId;
        }

        @Override
        public final Builder creatorId(String creatorId) {
            this.creatorId = creatorId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DevEnvironmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final List<DevEnvironmentRepositorySummary.Builder> getRepositories() {
            List<DevEnvironmentRepositorySummary.Builder> result = DevEnvironmentRepositorySummariesCopier.copyToBuilder(this.repositories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRepositories(Collection<DevEnvironmentRepositorySummary.BuilderImpl> repositories) {
            this.repositories = DevEnvironmentRepositorySummariesCopier.copyFromBuilder(repositories);
        }

        @Override
        public final Builder repositories(Collection<DevEnvironmentRepositorySummary> repositories) {
            this.repositories = DevEnvironmentRepositorySummariesCopier.copy(repositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositories(DevEnvironmentRepositorySummary ... repositories) {
            this.repositories(Arrays.asList(repositories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositories(Consumer<DevEnvironmentRepositorySummary.Builder> ... repositories) {
            this.repositories(Stream.of(repositories).map(c -> (DevEnvironmentRepositorySummary)((DevEnvironmentRepositorySummary.Builder)DevEnvironmentRepositorySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final List<Ide.Builder> getIdes() {
            List<Ide.Builder> result = IdesCopier.copyToBuilder(this.ides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdes(Collection<Ide.BuilderImpl> ides) {
            this.ides = IdesCopier.copyFromBuilder(ides);
        }

        @Override
        public final Builder ides(Collection<Ide> ides) {
            this.ides = IdesCopier.copy(ides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ides(Ide ... ides) {
            this.ides(Arrays.asList(ides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ides(Consumer<Ide.Builder> ... ides) {
            this.ides(Stream.of(ides).map(c -> (Ide)((Ide.Builder)Ide.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Integer getInactivityTimeoutMinutes() {
            return this.inactivityTimeoutMinutes;
        }

        public final void setInactivityTimeoutMinutes(Integer inactivityTimeoutMinutes) {
            this.inactivityTimeoutMinutes = inactivityTimeoutMinutes;
        }

        @Override
        public final Builder inactivityTimeoutMinutes(Integer inactivityTimeoutMinutes) {
            this.inactivityTimeoutMinutes = inactivityTimeoutMinutes;
            return this;
        }

        public final PersistentStorage.Builder getPersistentStorage() {
            return this.persistentStorage != null ? this.persistentStorage.toBuilder() : null;
        }

        public final void setPersistentStorage(PersistentStorage.BuilderImpl persistentStorage) {
            this.persistentStorage = persistentStorage != null ? persistentStorage.build() : null;
        }

        @Override
        public final Builder persistentStorage(PersistentStorage persistentStorage) {
            this.persistentStorage = persistentStorage;
            return this;
        }

        public final String getVpcConnectionName() {
            return this.vpcConnectionName;
        }

        public final void setVpcConnectionName(String vpcConnectionName) {
            this.vpcConnectionName = vpcConnectionName;
        }

        @Override
        public final Builder vpcConnectionName(String vpcConnectionName) {
            this.vpcConnectionName = vpcConnectionName;
            return this;
        }

        public DevEnvironmentSummary build() {
            return new DevEnvironmentSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DevEnvironmentSummary> {
        public Builder spaceName(String var1);

        public Builder projectName(String var1);

        public Builder id(String var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder creatorId(String var1);

        public Builder status(String var1);

        public Builder status(DevEnvironmentStatus var1);

        public Builder statusReason(String var1);

        public Builder repositories(Collection<DevEnvironmentRepositorySummary> var1);

        public Builder repositories(DevEnvironmentRepositorySummary ... var1);

        public Builder repositories(Consumer<DevEnvironmentRepositorySummary.Builder> ... var1);

        public Builder alias(String var1);

        public Builder ides(Collection<Ide> var1);

        public Builder ides(Ide ... var1);

        public Builder ides(Consumer<Ide.Builder> ... var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder inactivityTimeoutMinutes(Integer var1);

        public Builder persistentStorage(PersistentStorage var1);

        default public Builder persistentStorage(Consumer<PersistentStorage.Builder> persistentStorage) {
            return this.persistentStorage((PersistentStorage)((PersistentStorage.Builder)PersistentStorage.builder().applyMutation(persistentStorage)).build());
        }

        public Builder vpcConnectionName(String var1);
    }
}

