/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.identity.spi.TokenIdentity;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codecatalyst.CodeCatalystClient;
import software.amazon.awssdk.services.codecatalyst.CodeCatalystClientBuilder;
import software.amazon.awssdk.services.codecatalyst.CodeCatalystServiceClientConfiguration;
import software.amazon.awssdk.services.codecatalyst.DefaultCodeCatalystBaseClientBuilder;
import software.amazon.awssdk.services.codecatalyst.DefaultCodeCatalystClient;
import software.amazon.awssdk.services.codecatalyst.endpoints.CodeCatalystEndpointProvider;

@SdkInternalApi
final class DefaultCodeCatalystClientBuilder
extends DefaultCodeCatalystBaseClientBuilder<CodeCatalystClientBuilder, CodeCatalystClient>
implements CodeCatalystClientBuilder {
    DefaultCodeCatalystClientBuilder() {
    }

    @Override
    public DefaultCodeCatalystClientBuilder endpointProvider(CodeCatalystEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    @Override
    public DefaultCodeCatalystClientBuilder tokenProvider(IdentityProvider<? extends TokenIdentity> tokenProvider) {
        this.clientConfiguration.option((ClientOption)AwsClientOption.TOKEN_IDENTITY_PROVIDER, tokenProvider);
        return this;
    }

    protected final CodeCatalystClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCodeCatalystClientBuilder.validateClientOptions(clientConfiguration);
        CodeCatalystServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCodeCatalystClient client = new DefaultCodeCatalystClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CodeCatalystServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CodeCatalystServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

