/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSessionType;
import software.amazon.awssdk.services.codecatalyst.model.ExecuteCommandSessionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DevEnvironmentSessionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DevEnvironmentSessionConfiguration> {
    private static final SdkField<String> SESSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionType").getter(DevEnvironmentSessionConfiguration.getter(DevEnvironmentSessionConfiguration::sessionTypeAsString)).setter(DevEnvironmentSessionConfiguration.setter(Builder::sessionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionType").build()}).build();
    private static final SdkField<ExecuteCommandSessionConfiguration> EXECUTE_COMMAND_SESSION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("executeCommandSessionConfiguration").getter(DevEnvironmentSessionConfiguration.getter(DevEnvironmentSessionConfiguration::executeCommandSessionConfiguration)).setter(DevEnvironmentSessionConfiguration.setter(Builder::executeCommandSessionConfiguration)).constructor(ExecuteCommandSessionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executeCommandSessionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_TYPE_FIELD, EXECUTE_COMMAND_SESSION_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sessionType;
    private final ExecuteCommandSessionConfiguration executeCommandSessionConfiguration;

    private DevEnvironmentSessionConfiguration(BuilderImpl builder) {
        this.sessionType = builder.sessionType;
        this.executeCommandSessionConfiguration = builder.executeCommandSessionConfiguration;
    }

    public final DevEnvironmentSessionType sessionType() {
        return DevEnvironmentSessionType.fromValue(this.sessionType);
    }

    public final String sessionTypeAsString() {
        return this.sessionType;
    }

    public final ExecuteCommandSessionConfiguration executeCommandSessionConfiguration() {
        return this.executeCommandSessionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executeCommandSessionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DevEnvironmentSessionConfiguration)) {
            return false;
        }
        DevEnvironmentSessionConfiguration other = (DevEnvironmentSessionConfiguration)obj;
        return Objects.equals(this.sessionTypeAsString(), other.sessionTypeAsString()) && Objects.equals(this.executeCommandSessionConfiguration(), other.executeCommandSessionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DevEnvironmentSessionConfiguration").add("SessionType", (Object)this.sessionTypeAsString()).add("ExecuteCommandSessionConfiguration", (Object)this.executeCommandSessionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sessionType": {
                return Optional.ofNullable(clazz.cast(this.sessionTypeAsString()));
            }
            case "executeCommandSessionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.executeCommandSessionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DevEnvironmentSessionConfiguration, T> g) {
        return obj -> g.apply((DevEnvironmentSessionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sessionType;
        private ExecuteCommandSessionConfiguration executeCommandSessionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DevEnvironmentSessionConfiguration model) {
            this.sessionType(model.sessionType);
            this.executeCommandSessionConfiguration(model.executeCommandSessionConfiguration);
        }

        public final String getSessionType() {
            return this.sessionType;
        }

        public final void setSessionType(String sessionType) {
            this.sessionType = sessionType;
        }

        @Override
        public final Builder sessionType(String sessionType) {
            this.sessionType = sessionType;
            return this;
        }

        @Override
        public final Builder sessionType(DevEnvironmentSessionType sessionType) {
            this.sessionType(sessionType == null ? null : sessionType.toString());
            return this;
        }

        public final ExecuteCommandSessionConfiguration.Builder getExecuteCommandSessionConfiguration() {
            return this.executeCommandSessionConfiguration != null ? this.executeCommandSessionConfiguration.toBuilder() : null;
        }

        public final void setExecuteCommandSessionConfiguration(ExecuteCommandSessionConfiguration.BuilderImpl executeCommandSessionConfiguration) {
            this.executeCommandSessionConfiguration = executeCommandSessionConfiguration != null ? executeCommandSessionConfiguration.build() : null;
        }

        @Override
        public final Builder executeCommandSessionConfiguration(ExecuteCommandSessionConfiguration executeCommandSessionConfiguration) {
            this.executeCommandSessionConfiguration = executeCommandSessionConfiguration;
            return this;
        }

        public DevEnvironmentSessionConfiguration build() {
            return new DevEnvironmentSessionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DevEnvironmentSessionConfiguration> {
        public Builder sessionType(String var1);

        public Builder sessionType(DevEnvironmentSessionType var1);

        public Builder executeCommandSessionConfiguration(ExecuteCommandSessionConfiguration var1);

        default public Builder executeCommandSessionConfiguration(Consumer<ExecuteCommandSessionConfiguration.Builder> executeCommandSessionConfiguration) {
            return this.executeCommandSessionConfiguration((ExecuteCommandSessionConfiguration)((ExecuteCommandSessionConfiguration.Builder)ExecuteCommandSessionConfiguration.builder().applyMutation(executeCommandSessionConfiguration)).build());
        }
    }
}

