/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecatalyst.model.CodeCatalystResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSubscriptionResponse
extends CodeCatalystResponse
implements ToCopyableBuilder<Builder, GetSubscriptionResponse> {
    private static final SdkField<String> SUBSCRIPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriptionType").getter(GetSubscriptionResponse.getter(GetSubscriptionResponse::subscriptionType)).setter(GetSubscriptionResponse.setter(Builder::subscriptionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionType").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsAccountName").getter(GetSubscriptionResponse.getter(GetSubscriptionResponse::awsAccountName)).setter(GetSubscriptionResponse.setter(Builder::awsAccountName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTION_TYPE_FIELD, AWS_ACCOUNT_NAME_FIELD));
    private final String subscriptionType;
    private final String awsAccountName;

    private GetSubscriptionResponse(BuilderImpl builder) {
        super(builder);
        this.subscriptionType = builder.subscriptionType;
        this.awsAccountName = builder.awsAccountName;
    }

    public final String subscriptionType() {
        return this.subscriptionType;
    }

    public final String awsAccountName() {
        return this.awsAccountName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionType());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSubscriptionResponse)) {
            return false;
        }
        GetSubscriptionResponse other = (GetSubscriptionResponse)((Object)obj);
        return Objects.equals(this.subscriptionType(), other.subscriptionType()) && Objects.equals(this.awsAccountName(), other.awsAccountName());
    }

    public final String toString() {
        return ToString.builder((String)"GetSubscriptionResponse").add("SubscriptionType", (Object)this.subscriptionType()).add("AwsAccountName", (Object)this.awsAccountName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "subscriptionType": {
                return Optional.ofNullable(clazz.cast(this.subscriptionType()));
            }
            case "awsAccountName": {
                return Optional.ofNullable(clazz.cast(this.awsAccountName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSubscriptionResponse, T> g) {
        return obj -> g.apply((GetSubscriptionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCatalystResponse.BuilderImpl
    implements Builder {
        private String subscriptionType;
        private String awsAccountName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSubscriptionResponse model) {
            super(model);
            this.subscriptionType(model.subscriptionType);
            this.awsAccountName(model.awsAccountName);
        }

        public final String getSubscriptionType() {
            return this.subscriptionType;
        }

        public final void setSubscriptionType(String subscriptionType) {
            this.subscriptionType = subscriptionType;
        }

        @Override
        public final Builder subscriptionType(String subscriptionType) {
            this.subscriptionType = subscriptionType;
            return this;
        }

        public final String getAwsAccountName() {
            return this.awsAccountName;
        }

        public final void setAwsAccountName(String awsAccountName) {
            this.awsAccountName = awsAccountName;
        }

        @Override
        public final Builder awsAccountName(String awsAccountName) {
            this.awsAccountName = awsAccountName;
            return this;
        }

        @Override
        public GetSubscriptionResponse build() {
            return new GetSubscriptionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCatalystResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSubscriptionResponse> {
        public Builder subscriptionType(String var1);

        public Builder awsAccountName(String var1);
    }
}

