/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.token.credentials.SdkTokenProvider;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codecatalyst.CodeCatalystClient;
import software.amazon.awssdk.services.codecatalyst.CodeCatalystClientBuilder;
import software.amazon.awssdk.services.codecatalyst.CodeCatalystServiceClientConfiguration;
import software.amazon.awssdk.services.codecatalyst.DefaultCodeCatalystBaseClientBuilder;
import software.amazon.awssdk.services.codecatalyst.DefaultCodeCatalystClient;
import software.amazon.awssdk.services.codecatalyst.endpoints.CodeCatalystEndpointProvider;

@SdkInternalApi
final class DefaultCodeCatalystClientBuilder
extends DefaultCodeCatalystBaseClientBuilder<CodeCatalystClientBuilder, CodeCatalystClient>
implements CodeCatalystClientBuilder {
    DefaultCodeCatalystClientBuilder() {
    }

    @Override
    public DefaultCodeCatalystClientBuilder endpointProvider(CodeCatalystEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    @Override
    public DefaultCodeCatalystClientBuilder tokenProvider(SdkTokenProvider tokenProvider) {
        this.clientConfiguration.option((ClientOption)AwsClientOption.TOKEN_PROVIDER, (Object)tokenProvider);
        return this;
    }

    protected final CodeCatalystClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCodeCatalystClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        CodeCatalystServiceClientConfiguration serviceClientConfiguration = CodeCatalystServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultCodeCatalystClient(serviceClientConfiguration, clientConfiguration);
    }
}

