/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecatalyst.model.CodeCatalystRequest;
import software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSessionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartDevEnvironmentSessionRequest
extends CodeCatalystRequest
implements ToCopyableBuilder<Builder, StartDevEnvironmentSessionRequest> {
    private static final SdkField<String> SPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spaceName").getter(StartDevEnvironmentSessionRequest.getter(StartDevEnvironmentSessionRequest::spaceName)).setter(StartDevEnvironmentSessionRequest.setter(Builder::spaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("spaceName").build()}).build();
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectName").getter(StartDevEnvironmentSessionRequest.getter(StartDevEnvironmentSessionRequest::projectName)).setter(StartDevEnvironmentSessionRequest.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("projectName").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(StartDevEnvironmentSessionRequest.getter(StartDevEnvironmentSessionRequest::id)).setter(StartDevEnvironmentSessionRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()}).build();
    private static final SdkField<DevEnvironmentSessionConfiguration> SESSION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sessionConfiguration").getter(StartDevEnvironmentSessionRequest.getter(StartDevEnvironmentSessionRequest::sessionConfiguration)).setter(StartDevEnvironmentSessionRequest.setter(Builder::sessionConfiguration)).constructor(DevEnvironmentSessionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPACE_NAME_FIELD, PROJECT_NAME_FIELD, ID_FIELD, SESSION_CONFIGURATION_FIELD));
    private final String spaceName;
    private final String projectName;
    private final String id;
    private final DevEnvironmentSessionConfiguration sessionConfiguration;

    private StartDevEnvironmentSessionRequest(BuilderImpl builder) {
        super(builder);
        this.spaceName = builder.spaceName;
        this.projectName = builder.projectName;
        this.id = builder.id;
        this.sessionConfiguration = builder.sessionConfiguration;
    }

    public final String spaceName() {
        return this.spaceName;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final String id() {
        return this.id;
    }

    public final DevEnvironmentSessionConfiguration sessionConfiguration() {
        return this.sessionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDevEnvironmentSessionRequest)) {
            return false;
        }
        StartDevEnvironmentSessionRequest other = (StartDevEnvironmentSessionRequest)((Object)obj);
        return Objects.equals(this.spaceName(), other.spaceName()) && Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.sessionConfiguration(), other.sessionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"StartDevEnvironmentSessionRequest").add("SpaceName", (Object)this.spaceName()).add("ProjectName", (Object)this.projectName()).add("Id", (Object)this.id()).add("SessionConfiguration", (Object)this.sessionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "spaceName": {
                return Optional.ofNullable(clazz.cast(this.spaceName()));
            }
            case "projectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "sessionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sessionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartDevEnvironmentSessionRequest, T> g) {
        return obj -> g.apply((StartDevEnvironmentSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCatalystRequest.BuilderImpl
    implements Builder {
        private String spaceName;
        private String projectName;
        private String id;
        private DevEnvironmentSessionConfiguration sessionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDevEnvironmentSessionRequest model) {
            super(model);
            this.spaceName(model.spaceName);
            this.projectName(model.projectName);
            this.id(model.id);
            this.sessionConfiguration(model.sessionConfiguration);
        }

        public final String getSpaceName() {
            return this.spaceName;
        }

        public final void setSpaceName(String spaceName) {
            this.spaceName = spaceName;
        }

        @Override
        public final Builder spaceName(String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final DevEnvironmentSessionConfiguration.Builder getSessionConfiguration() {
            return this.sessionConfiguration != null ? this.sessionConfiguration.toBuilder() : null;
        }

        public final void setSessionConfiguration(DevEnvironmentSessionConfiguration.BuilderImpl sessionConfiguration) {
            this.sessionConfiguration = sessionConfiguration != null ? sessionConfiguration.build() : null;
        }

        @Override
        public final Builder sessionConfiguration(DevEnvironmentSessionConfiguration sessionConfiguration) {
            this.sessionConfiguration = sessionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDevEnvironmentSessionRequest build() {
            return new StartDevEnvironmentSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCatalystRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartDevEnvironmentSessionRequest> {
        public Builder spaceName(String var1);

        public Builder projectName(String var1);

        public Builder id(String var1);

        public Builder sessionConfiguration(DevEnvironmentSessionConfiguration var1);

        default public Builder sessionConfiguration(Consumer<DevEnvironmentSessionConfiguration.Builder> sessionConfiguration) {
            return this.sessionConfiguration((DevEnvironmentSessionConfiguration)((DevEnvironmentSessionConfiguration.Builder)DevEnvironmentSessionConfiguration.builder().applyMutation(sessionConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

