/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codebuild.model.ArtifactNamespace;
import software.amazon.awssdk.services.codebuild.model.ArtifactPackaging;
import software.amazon.awssdk.services.codebuild.model.ArtifactsType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProjectArtifacts
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProjectArtifacts> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProjectArtifacts.getter(ProjectArtifacts::typeAsString)).setter(ProjectArtifacts.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProjectArtifacts.getter(ProjectArtifacts::location)).setter(ProjectArtifacts.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProjectArtifacts.getter(ProjectArtifacts::path)).setter(ProjectArtifacts.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()}).build();
    private static final SdkField<String> NAMESPACE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProjectArtifacts.getter(ProjectArtifacts::namespaceTypeAsString)).setter(ProjectArtifacts.setter(Builder::namespaceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceType").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProjectArtifacts.getter(ProjectArtifacts::name)).setter(ProjectArtifacts.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PACKAGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProjectArtifacts.getter(ProjectArtifacts::packagingAsString)).setter(ProjectArtifacts.setter(Builder::packaging)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packaging").build()}).build();
    private static final SdkField<Boolean> OVERRIDE_ARTIFACT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ProjectArtifacts.getter(ProjectArtifacts::overrideArtifactName)).setter(ProjectArtifacts.setter(Builder::overrideArtifactName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideArtifactName").build()}).build();
    private static final SdkField<Boolean> ENCRYPTION_DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ProjectArtifacts.getter(ProjectArtifacts::encryptionDisabled)).setter(ProjectArtifacts.setter(Builder::encryptionDisabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionDisabled").build()}).build();
    private static final SdkField<String> ARTIFACT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProjectArtifacts.getter(ProjectArtifacts::artifactIdentifier)).setter(ProjectArtifacts.setter(Builder::artifactIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, LOCATION_FIELD, PATH_FIELD, NAMESPACE_TYPE_FIELD, NAME_FIELD, PACKAGING_FIELD, OVERRIDE_ARTIFACT_NAME_FIELD, ENCRYPTION_DISABLED_FIELD, ARTIFACT_IDENTIFIER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String location;
    private final String path;
    private final String namespaceType;
    private final String name;
    private final String packaging;
    private final Boolean overrideArtifactName;
    private final Boolean encryptionDisabled;
    private final String artifactIdentifier;

    private ProjectArtifacts(BuilderImpl builder) {
        this.type = builder.type;
        this.location = builder.location;
        this.path = builder.path;
        this.namespaceType = builder.namespaceType;
        this.name = builder.name;
        this.packaging = builder.packaging;
        this.overrideArtifactName = builder.overrideArtifactName;
        this.encryptionDisabled = builder.encryptionDisabled;
        this.artifactIdentifier = builder.artifactIdentifier;
    }

    public ArtifactsType type() {
        return ArtifactsType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String location() {
        return this.location;
    }

    public String path() {
        return this.path;
    }

    public ArtifactNamespace namespaceType() {
        return ArtifactNamespace.fromValue(this.namespaceType);
    }

    public String namespaceTypeAsString() {
        return this.namespaceType;
    }

    public String name() {
        return this.name;
    }

    public ArtifactPackaging packaging() {
        return ArtifactPackaging.fromValue(this.packaging);
    }

    public String packagingAsString() {
        return this.packaging;
    }

    public Boolean overrideArtifactName() {
        return this.overrideArtifactName;
    }

    public Boolean encryptionDisabled() {
        return this.encryptionDisabled;
    }

    public String artifactIdentifier() {
        return this.artifactIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.packagingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideArtifactName());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactIdentifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectArtifacts)) {
            return false;
        }
        ProjectArtifacts other = (ProjectArtifacts)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.namespaceTypeAsString(), other.namespaceTypeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.packagingAsString(), other.packagingAsString()) && Objects.equals(this.overrideArtifactName(), other.overrideArtifactName()) && Objects.equals(this.encryptionDisabled(), other.encryptionDisabled()) && Objects.equals(this.artifactIdentifier(), other.artifactIdentifier());
    }

    public String toString() {
        return ToString.builder((String)"ProjectArtifacts").add("Type", (Object)this.typeAsString()).add("Location", (Object)this.location()).add("Path", (Object)this.path()).add("NamespaceType", (Object)this.namespaceTypeAsString()).add("Name", (Object)this.name()).add("Packaging", (Object)this.packagingAsString()).add("OverrideArtifactName", (Object)this.overrideArtifactName()).add("EncryptionDisabled", (Object)this.encryptionDisabled()).add("ArtifactIdentifier", (Object)this.artifactIdentifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "namespaceType": {
                return Optional.ofNullable(clazz.cast(this.namespaceTypeAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "packaging": {
                return Optional.ofNullable(clazz.cast(this.packagingAsString()));
            }
            case "overrideArtifactName": {
                return Optional.ofNullable(clazz.cast(this.overrideArtifactName()));
            }
            case "encryptionDisabled": {
                return Optional.ofNullable(clazz.cast(this.encryptionDisabled()));
            }
            case "artifactIdentifier": {
                return Optional.ofNullable(clazz.cast(this.artifactIdentifier()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProjectArtifacts, T> g) {
        return obj -> g.apply((ProjectArtifacts)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String location;
        private String path;
        private String namespaceType;
        private String name;
        private String packaging;
        private Boolean overrideArtifactName;
        private Boolean encryptionDisabled;
        private String artifactIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectArtifacts model) {
            this.type(model.type);
            this.location(model.location);
            this.path(model.path);
            this.namespaceType(model.namespaceType);
            this.name(model.name);
            this.packaging(model.packaging);
            this.overrideArtifactName(model.overrideArtifactName);
            this.encryptionDisabled(model.encryptionDisabled);
            this.artifactIdentifier(model.artifactIdentifier);
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ArtifactsType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getNamespaceTypeAsString() {
            return this.namespaceType;
        }

        @Override
        public final Builder namespaceType(String namespaceType) {
            this.namespaceType = namespaceType;
            return this;
        }

        @Override
        public final Builder namespaceType(ArtifactNamespace namespaceType) {
            this.namespaceType(namespaceType.toString());
            return this;
        }

        public final void setNamespaceType(String namespaceType) {
            this.namespaceType = namespaceType;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getPackagingAsString() {
            return this.packaging;
        }

        @Override
        public final Builder packaging(String packaging) {
            this.packaging = packaging;
            return this;
        }

        @Override
        public final Builder packaging(ArtifactPackaging packaging) {
            this.packaging(packaging.toString());
            return this;
        }

        public final void setPackaging(String packaging) {
            this.packaging = packaging;
        }

        public final Boolean getOverrideArtifactName() {
            return this.overrideArtifactName;
        }

        @Override
        public final Builder overrideArtifactName(Boolean overrideArtifactName) {
            this.overrideArtifactName = overrideArtifactName;
            return this;
        }

        public final void setOverrideArtifactName(Boolean overrideArtifactName) {
            this.overrideArtifactName = overrideArtifactName;
        }

        public final Boolean getEncryptionDisabled() {
            return this.encryptionDisabled;
        }

        @Override
        public final Builder encryptionDisabled(Boolean encryptionDisabled) {
            this.encryptionDisabled = encryptionDisabled;
            return this;
        }

        public final void setEncryptionDisabled(Boolean encryptionDisabled) {
            this.encryptionDisabled = encryptionDisabled;
        }

        public final String getArtifactIdentifier() {
            return this.artifactIdentifier;
        }

        @Override
        public final Builder artifactIdentifier(String artifactIdentifier) {
            this.artifactIdentifier = artifactIdentifier;
            return this;
        }

        public final void setArtifactIdentifier(String artifactIdentifier) {
            this.artifactIdentifier = artifactIdentifier;
        }

        public ProjectArtifacts build() {
            return new ProjectArtifacts(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProjectArtifacts> {
        public Builder type(String var1);

        public Builder type(ArtifactsType var1);

        public Builder location(String var1);

        public Builder path(String var1);

        public Builder namespaceType(String var1);

        public Builder namespaceType(ArtifactNamespace var1);

        public Builder name(String var1);

        public Builder packaging(String var1);

        public Builder packaging(ArtifactPackaging var1);

        public Builder overrideArtifactName(Boolean var1);

        public Builder encryptionDisabled(Boolean var1);

        public Builder artifactIdentifier(String var1);
    }
}

