/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProjectBadge
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProjectBadge> {
    private static final SdkField<Boolean> BADGE_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ProjectBadge.getter(ProjectBadge::badgeEnabled)).setter(ProjectBadge.setter(Builder::badgeEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("badgeEnabled").build()}).build();
    private static final SdkField<String> BADGE_REQUEST_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProjectBadge.getter(ProjectBadge::badgeRequestUrl)).setter(ProjectBadge.setter(Builder::badgeRequestUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("badgeRequestUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BADGE_ENABLED_FIELD, BADGE_REQUEST_URL_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean badgeEnabled;
    private final String badgeRequestUrl;

    private ProjectBadge(BuilderImpl builder) {
        this.badgeEnabled = builder.badgeEnabled;
        this.badgeRequestUrl = builder.badgeRequestUrl;
    }

    public Boolean badgeEnabled() {
        return this.badgeEnabled;
    }

    public String badgeRequestUrl() {
        return this.badgeRequestUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.badgeEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.badgeRequestUrl());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectBadge)) {
            return false;
        }
        ProjectBadge other = (ProjectBadge)obj;
        return Objects.equals(this.badgeEnabled(), other.badgeEnabled()) && Objects.equals(this.badgeRequestUrl(), other.badgeRequestUrl());
    }

    public String toString() {
        return ToString.builder((String)"ProjectBadge").add("BadgeEnabled", (Object)this.badgeEnabled()).add("BadgeRequestUrl", (Object)this.badgeRequestUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "badgeEnabled": {
                return Optional.ofNullable(clazz.cast(this.badgeEnabled()));
            }
            case "badgeRequestUrl": {
                return Optional.ofNullable(clazz.cast(this.badgeRequestUrl()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProjectBadge, T> g) {
        return obj -> g.apply((ProjectBadge)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean badgeEnabled;
        private String badgeRequestUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectBadge model) {
            this.badgeEnabled(model.badgeEnabled);
            this.badgeRequestUrl(model.badgeRequestUrl);
        }

        public final Boolean getBadgeEnabled() {
            return this.badgeEnabled;
        }

        @Override
        public final Builder badgeEnabled(Boolean badgeEnabled) {
            this.badgeEnabled = badgeEnabled;
            return this;
        }

        public final void setBadgeEnabled(Boolean badgeEnabled) {
            this.badgeEnabled = badgeEnabled;
        }

        public final String getBadgeRequestUrl() {
            return this.badgeRequestUrl;
        }

        @Override
        public final Builder badgeRequestUrl(String badgeRequestUrl) {
            this.badgeRequestUrl = badgeRequestUrl;
            return this;
        }

        public final void setBadgeRequestUrl(String badgeRequestUrl) {
            this.badgeRequestUrl = badgeRequestUrl;
        }

        public ProjectBadge build() {
            return new ProjectBadge(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProjectBadge> {
        public Builder badgeEnabled(Boolean var1);

        public Builder badgeRequestUrl(String var1);
    }
}

