/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codebuild.model.AuthType;
import software.amazon.awssdk.services.codebuild.model.ServerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceCredentialsInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceCredentialsInfo> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(SourceCredentialsInfo.getter(SourceCredentialsInfo::arn)).setter(SourceCredentialsInfo.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> SERVER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serverType").getter(SourceCredentialsInfo.getter(SourceCredentialsInfo::serverTypeAsString)).setter(SourceCredentialsInfo.setter(Builder::serverType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverType").build()}).build();
    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authType").getter(SourceCredentialsInfo.getter(SourceCredentialsInfo::authTypeAsString)).setter(SourceCredentialsInfo.setter(Builder::authType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authType").build()}).build();
    private static final SdkField<String> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resource").getter(SourceCredentialsInfo.getter(SourceCredentialsInfo::resource)).setter(SourceCredentialsInfo.setter(Builder::resource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, SERVER_TYPE_FIELD, AUTH_TYPE_FIELD, RESOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SourceCredentialsInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String serverType;
    private final String authType;
    private final String resource;

    private SourceCredentialsInfo(BuilderImpl builder) {
        this.arn = builder.arn;
        this.serverType = builder.serverType;
        this.authType = builder.authType;
        this.resource = builder.resource;
    }

    public final String arn() {
        return this.arn;
    }

    public final ServerType serverType() {
        return ServerType.fromValue(this.serverType);
    }

    public final String serverTypeAsString() {
        return this.serverType;
    }

    public final AuthType authType() {
        return AuthType.fromValue(this.authType);
    }

    public final String authTypeAsString() {
        return this.authType;
    }

    public final String resource() {
        return this.resource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceCredentialsInfo)) {
            return false;
        }
        SourceCredentialsInfo other = (SourceCredentialsInfo)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.serverTypeAsString(), other.serverTypeAsString()) && Objects.equals(this.authTypeAsString(), other.authTypeAsString()) && Objects.equals(this.resource(), other.resource());
    }

    public final String toString() {
        return ToString.builder((String)"SourceCredentialsInfo").add("Arn", (Object)this.arn()).add("ServerType", (Object)this.serverTypeAsString()).add("AuthType", (Object)this.authTypeAsString()).add("Resource", (Object)this.resource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "serverType": {
                return Optional.ofNullable(clazz.cast(this.serverTypeAsString()));
            }
            case "authType": {
                return Optional.ofNullable(clazz.cast(this.authTypeAsString()));
            }
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("arn", ARN_FIELD);
        map.put("serverType", SERVER_TYPE_FIELD);
        map.put("authType", AUTH_TYPE_FIELD);
        map.put("resource", RESOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceCredentialsInfo, T> g) {
        return obj -> g.apply((SourceCredentialsInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String serverType;
        private String authType;
        private String resource;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceCredentialsInfo model) {
            this.arn(model.arn);
            this.serverType(model.serverType);
            this.authType(model.authType);
            this.resource(model.resource);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getServerType() {
            return this.serverType;
        }

        public final void setServerType(String serverType) {
            this.serverType = serverType;
        }

        @Override
        public final Builder serverType(String serverType) {
            this.serverType = serverType;
            return this;
        }

        @Override
        public final Builder serverType(ServerType serverType) {
            this.serverType(serverType == null ? null : serverType.toString());
            return this;
        }

        public final String getAuthType() {
            return this.authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(AuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final String getResource() {
            return this.resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public SourceCredentialsInfo build() {
            return new SourceCredentialsInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceCredentialsInfo> {
        public Builder arn(String var1);

        public Builder serverType(String var1);

        public Builder serverType(ServerType var1);

        public Builder authType(String var1);

        public Builder authType(AuthType var1);

        public Builder resource(String var1);
    }
}

