/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.CodeBuildRequest;
import software.amazon.awssdk.services.codebuild.model.CommandExecutionIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetCommandExecutionsRequest
extends CodeBuildRequest
implements ToCopyableBuilder<Builder, BatchGetCommandExecutionsRequest> {
    private static final SdkField<String> SANDBOX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sandboxId").getter(BatchGetCommandExecutionsRequest.getter(BatchGetCommandExecutionsRequest::sandboxId)).setter(BatchGetCommandExecutionsRequest.setter(Builder::sandboxId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sandboxId").build()}).build();
    private static final SdkField<List<String>> COMMAND_EXECUTION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("commandExecutionIds").getter(BatchGetCommandExecutionsRequest.getter(BatchGetCommandExecutionsRequest::commandExecutionIds)).setter(BatchGetCommandExecutionsRequest.setter(Builder::commandExecutionIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commandExecutionIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SANDBOX_ID_FIELD, COMMAND_EXECUTION_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetCommandExecutionsRequest.memberNameToFieldInitializer();
    private final String sandboxId;
    private final List<String> commandExecutionIds;

    private BatchGetCommandExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.sandboxId = builder.sandboxId;
        this.commandExecutionIds = builder.commandExecutionIds;
    }

    public final String sandboxId() {
        return this.sandboxId;
    }

    public final boolean hasCommandExecutionIds() {
        return this.commandExecutionIds != null && !(this.commandExecutionIds instanceof SdkAutoConstructList);
    }

    public final List<String> commandExecutionIds() {
        return this.commandExecutionIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sandboxId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommandExecutionIds() ? this.commandExecutionIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCommandExecutionsRequest)) {
            return false;
        }
        BatchGetCommandExecutionsRequest other = (BatchGetCommandExecutionsRequest)((Object)obj);
        return Objects.equals(this.sandboxId(), other.sandboxId()) && this.hasCommandExecutionIds() == other.hasCommandExecutionIds() && Objects.equals(this.commandExecutionIds(), other.commandExecutionIds());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetCommandExecutionsRequest").add("SandboxId", (Object)this.sandboxId()).add("CommandExecutionIds", this.hasCommandExecutionIds() ? this.commandExecutionIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sandboxId": {
                return Optional.ofNullable(clazz.cast(this.sandboxId()));
            }
            case "commandExecutionIds": {
                return Optional.ofNullable(clazz.cast(this.commandExecutionIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sandboxId", SANDBOX_ID_FIELD);
        map.put("commandExecutionIds", COMMAND_EXECUTION_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCommandExecutionsRequest, T> g) {
        return obj -> g.apply((BatchGetCommandExecutionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildRequest.BuilderImpl
    implements Builder {
        private String sandboxId;
        private List<String> commandExecutionIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCommandExecutionsRequest model) {
            super(model);
            this.sandboxId(model.sandboxId);
            this.commandExecutionIds(model.commandExecutionIds);
        }

        public final String getSandboxId() {
            return this.sandboxId;
        }

        public final void setSandboxId(String sandboxId) {
            this.sandboxId = sandboxId;
        }

        @Override
        public final Builder sandboxId(String sandboxId) {
            this.sandboxId = sandboxId;
            return this;
        }

        public final Collection<String> getCommandExecutionIds() {
            if (this.commandExecutionIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.commandExecutionIds;
        }

        public final void setCommandExecutionIds(Collection<String> commandExecutionIds) {
            this.commandExecutionIds = CommandExecutionIdsCopier.copy(commandExecutionIds);
        }

        @Override
        public final Builder commandExecutionIds(Collection<String> commandExecutionIds) {
            this.commandExecutionIds = CommandExecutionIdsCopier.copy(commandExecutionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandExecutionIds(String ... commandExecutionIds) {
            this.commandExecutionIds(Arrays.asList(commandExecutionIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetCommandExecutionsRequest build() {
            return new BatchGetCommandExecutionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeBuildRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetCommandExecutionsRequest> {
        public Builder sandboxId(String var1);

        public Builder commandExecutionIds(Collection<String> var1);

        public Builder commandExecutionIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

