/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.LogsConfig;
import software.amazon.awssdk.services.codebuild.model.ProjectEnvironment;
import software.amazon.awssdk.services.codebuild.model.ProjectFileSystemLocation;
import software.amazon.awssdk.services.codebuild.model.ProjectFileSystemLocationsCopier;
import software.amazon.awssdk.services.codebuild.model.ProjectSecondarySourceVersionsCopier;
import software.amazon.awssdk.services.codebuild.model.ProjectSource;
import software.amazon.awssdk.services.codebuild.model.ProjectSourceVersion;
import software.amazon.awssdk.services.codebuild.model.ProjectSourcesCopier;
import software.amazon.awssdk.services.codebuild.model.SandboxSession;
import software.amazon.awssdk.services.codebuild.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Sandbox
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Sandbox> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Sandbox.getter(Sandbox::id)).setter(Sandbox.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Sandbox.getter(Sandbox::arn)).setter(Sandbox.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectName").getter(Sandbox.getter(Sandbox::projectName)).setter(Sandbox.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()}).build();
    private static final SdkField<Instant> REQUEST_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("requestTime").getter(Sandbox.getter(Sandbox::requestTime)).setter(Sandbox.setter(Builder::requestTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestTime").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(Sandbox.getter(Sandbox::startTime)).setter(Sandbox.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(Sandbox.getter(Sandbox::endTime)).setter(Sandbox.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Sandbox.getter(Sandbox::status)).setter(Sandbox.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<ProjectSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("source").getter(Sandbox.getter(Sandbox::source)).setter(Sandbox.setter(Builder::source)).constructor(ProjectSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> SOURCE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceVersion").getter(Sandbox.getter(Sandbox::sourceVersion)).setter(Sandbox.setter(Builder::sourceVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceVersion").build()}).build();
    private static final SdkField<List<ProjectSource>> SECONDARY_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("secondarySources").getter(Sandbox.getter(Sandbox::secondarySources)).setter(Sandbox.setter(Builder::secondarySources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondarySources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ProjectSourceVersion>> SECONDARY_SOURCE_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("secondarySourceVersions").getter(Sandbox.getter(Sandbox::secondarySourceVersions)).setter(Sandbox.setter(Builder::secondarySourceVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondarySourceVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectSourceVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProjectEnvironment> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("environment").getter(Sandbox.getter(Sandbox::environment)).setter(Sandbox.setter(Builder::environment)).constructor(ProjectEnvironment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environment").build()}).build();
    private static final SdkField<List<ProjectFileSystemLocation>> FILE_SYSTEM_LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fileSystemLocations").getter(Sandbox.getter(Sandbox::fileSystemLocations)).setter(Sandbox.setter(Builder::fileSystemLocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSystemLocations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectFileSystemLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> TIMEOUT_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("timeoutInMinutes").getter(Sandbox.getter(Sandbox::timeoutInMinutes)).setter(Sandbox.setter(Builder::timeoutInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInMinutes").build()}).build();
    private static final SdkField<Integer> QUEUED_TIMEOUT_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("queuedTimeoutInMinutes").getter(Sandbox.getter(Sandbox::queuedTimeoutInMinutes)).setter(Sandbox.setter(Builder::queuedTimeoutInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queuedTimeoutInMinutes").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpcConfig").getter(Sandbox.getter(Sandbox::vpcConfig)).setter(Sandbox.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()}).build();
    private static final SdkField<LogsConfig> LOG_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logConfig").getter(Sandbox.getter(Sandbox::logConfig)).setter(Sandbox.setter(Builder::logConfig)).constructor(LogsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfig").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("encryptionKey").getter(Sandbox.getter(Sandbox::encryptionKey)).setter(Sandbox.setter(Builder::encryptionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKey").build()}).build();
    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceRole").getter(Sandbox.getter(Sandbox::serviceRole)).setter(Sandbox.setter(Builder::serviceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRole").build()}).build();
    private static final SdkField<SandboxSession> CURRENT_SESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("currentSession").getter(Sandbox.getter(Sandbox::currentSession)).setter(Sandbox.setter(Builder::currentSession)).constructor(SandboxSession::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentSession").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, PROJECT_NAME_FIELD, REQUEST_TIME_FIELD, START_TIME_FIELD, END_TIME_FIELD, STATUS_FIELD, SOURCE_FIELD, SOURCE_VERSION_FIELD, SECONDARY_SOURCES_FIELD, SECONDARY_SOURCE_VERSIONS_FIELD, ENVIRONMENT_FIELD, FILE_SYSTEM_LOCATIONS_FIELD, TIMEOUT_IN_MINUTES_FIELD, QUEUED_TIMEOUT_IN_MINUTES_FIELD, VPC_CONFIG_FIELD, LOG_CONFIG_FIELD, ENCRYPTION_KEY_FIELD, SERVICE_ROLE_FIELD, CURRENT_SESSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Sandbox.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String projectName;
    private final Instant requestTime;
    private final Instant startTime;
    private final Instant endTime;
    private final String status;
    private final ProjectSource source;
    private final String sourceVersion;
    private final List<ProjectSource> secondarySources;
    private final List<ProjectSourceVersion> secondarySourceVersions;
    private final ProjectEnvironment environment;
    private final List<ProjectFileSystemLocation> fileSystemLocations;
    private final Integer timeoutInMinutes;
    private final Integer queuedTimeoutInMinutes;
    private final VpcConfig vpcConfig;
    private final LogsConfig logConfig;
    private final String encryptionKey;
    private final String serviceRole;
    private final SandboxSession currentSession;

    private Sandbox(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.projectName = builder.projectName;
        this.requestTime = builder.requestTime;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.status = builder.status;
        this.source = builder.source;
        this.sourceVersion = builder.sourceVersion;
        this.secondarySources = builder.secondarySources;
        this.secondarySourceVersions = builder.secondarySourceVersions;
        this.environment = builder.environment;
        this.fileSystemLocations = builder.fileSystemLocations;
        this.timeoutInMinutes = builder.timeoutInMinutes;
        this.queuedTimeoutInMinutes = builder.queuedTimeoutInMinutes;
        this.vpcConfig = builder.vpcConfig;
        this.logConfig = builder.logConfig;
        this.encryptionKey = builder.encryptionKey;
        this.serviceRole = builder.serviceRole;
        this.currentSession = builder.currentSession;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final Instant requestTime() {
        return this.requestTime;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String status() {
        return this.status;
    }

    public final ProjectSource source() {
        return this.source;
    }

    public final String sourceVersion() {
        return this.sourceVersion;
    }

    public final boolean hasSecondarySources() {
        return this.secondarySources != null && !(this.secondarySources instanceof SdkAutoConstructList);
    }

    public final List<ProjectSource> secondarySources() {
        return this.secondarySources;
    }

    public final boolean hasSecondarySourceVersions() {
        return this.secondarySourceVersions != null && !(this.secondarySourceVersions instanceof SdkAutoConstructList);
    }

    public final List<ProjectSourceVersion> secondarySourceVersions() {
        return this.secondarySourceVersions;
    }

    public final ProjectEnvironment environment() {
        return this.environment;
    }

    public final boolean hasFileSystemLocations() {
        return this.fileSystemLocations != null && !(this.fileSystemLocations instanceof SdkAutoConstructList);
    }

    public final List<ProjectFileSystemLocation> fileSystemLocations() {
        return this.fileSystemLocations;
    }

    public final Integer timeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public final Integer queuedTimeoutInMinutes() {
        return this.queuedTimeoutInMinutes;
    }

    public final VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final LogsConfig logConfig() {
        return this.logConfig;
    }

    public final String encryptionKey() {
        return this.encryptionKey;
    }

    public final String serviceRole() {
        return this.serviceRole;
    }

    public final SandboxSession currentSession() {
        return this.currentSession;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecondarySources() ? this.secondarySources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecondarySourceVersions() ? this.secondarySourceVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.environment());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFileSystemLocations() ? this.fileSystemLocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.queuedTimeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.logConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentSession());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Sandbox)) {
            return false;
        }
        Sandbox other = (Sandbox)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.requestTime(), other.requestTime()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.sourceVersion(), other.sourceVersion()) && this.hasSecondarySources() == other.hasSecondarySources() && Objects.equals(this.secondarySources(), other.secondarySources()) && this.hasSecondarySourceVersions() == other.hasSecondarySourceVersions() && Objects.equals(this.secondarySourceVersions(), other.secondarySourceVersions()) && Objects.equals(this.environment(), other.environment()) && this.hasFileSystemLocations() == other.hasFileSystemLocations() && Objects.equals(this.fileSystemLocations(), other.fileSystemLocations()) && Objects.equals(this.timeoutInMinutes(), other.timeoutInMinutes()) && Objects.equals(this.queuedTimeoutInMinutes(), other.queuedTimeoutInMinutes()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.logConfig(), other.logConfig()) && Objects.equals(this.encryptionKey(), other.encryptionKey()) && Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.currentSession(), other.currentSession());
    }

    public final String toString() {
        return ToString.builder((String)"Sandbox").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("ProjectName", (Object)this.projectName()).add("RequestTime", (Object)this.requestTime()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Status", (Object)this.status()).add("Source", (Object)this.source()).add("SourceVersion", (Object)this.sourceVersion()).add("SecondarySources", this.hasSecondarySources() ? this.secondarySources() : null).add("SecondarySourceVersions", this.hasSecondarySourceVersions() ? this.secondarySourceVersions() : null).add("Environment", (Object)this.environment()).add("FileSystemLocations", this.hasFileSystemLocations() ? this.fileSystemLocations() : null).add("TimeoutInMinutes", (Object)this.timeoutInMinutes()).add("QueuedTimeoutInMinutes", (Object)this.queuedTimeoutInMinutes()).add("VpcConfig", (Object)this.vpcConfig()).add("LogConfig", (Object)this.logConfig()).add("EncryptionKey", (Object)this.encryptionKey()).add("ServiceRole", (Object)this.serviceRole()).add("CurrentSession", (Object)this.currentSession()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "projectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "requestTime": {
                return Optional.ofNullable(clazz.cast(this.requestTime()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "sourceVersion": {
                return Optional.ofNullable(clazz.cast(this.sourceVersion()));
            }
            case "secondarySources": {
                return Optional.ofNullable(clazz.cast(this.secondarySources()));
            }
            case "secondarySourceVersions": {
                return Optional.ofNullable(clazz.cast(this.secondarySourceVersions()));
            }
            case "environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "fileSystemLocations": {
                return Optional.ofNullable(clazz.cast(this.fileSystemLocations()));
            }
            case "timeoutInMinutes": {
                return Optional.ofNullable(clazz.cast(this.timeoutInMinutes()));
            }
            case "queuedTimeoutInMinutes": {
                return Optional.ofNullable(clazz.cast(this.queuedTimeoutInMinutes()));
            }
            case "vpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "logConfig": {
                return Optional.ofNullable(clazz.cast(this.logConfig()));
            }
            case "encryptionKey": {
                return Optional.ofNullable(clazz.cast(this.encryptionKey()));
            }
            case "serviceRole": {
                return Optional.ofNullable(clazz.cast(this.serviceRole()));
            }
            case "currentSession": {
                return Optional.ofNullable(clazz.cast(this.currentSession()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("projectName", PROJECT_NAME_FIELD);
        map.put("requestTime", REQUEST_TIME_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("sourceVersion", SOURCE_VERSION_FIELD);
        map.put("secondarySources", SECONDARY_SOURCES_FIELD);
        map.put("secondarySourceVersions", SECONDARY_SOURCE_VERSIONS_FIELD);
        map.put("environment", ENVIRONMENT_FIELD);
        map.put("fileSystemLocations", FILE_SYSTEM_LOCATIONS_FIELD);
        map.put("timeoutInMinutes", TIMEOUT_IN_MINUTES_FIELD);
        map.put("queuedTimeoutInMinutes", QUEUED_TIMEOUT_IN_MINUTES_FIELD);
        map.put("vpcConfig", VPC_CONFIG_FIELD);
        map.put("logConfig", LOG_CONFIG_FIELD);
        map.put("encryptionKey", ENCRYPTION_KEY_FIELD);
        map.put("serviceRole", SERVICE_ROLE_FIELD);
        map.put("currentSession", CURRENT_SESSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Sandbox, T> g) {
        return obj -> g.apply((Sandbox)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String projectName;
        private Instant requestTime;
        private Instant startTime;
        private Instant endTime;
        private String status;
        private ProjectSource source;
        private String sourceVersion;
        private List<ProjectSource> secondarySources = DefaultSdkAutoConstructList.getInstance();
        private List<ProjectSourceVersion> secondarySourceVersions = DefaultSdkAutoConstructList.getInstance();
        private ProjectEnvironment environment;
        private List<ProjectFileSystemLocation> fileSystemLocations = DefaultSdkAutoConstructList.getInstance();
        private Integer timeoutInMinutes;
        private Integer queuedTimeoutInMinutes;
        private VpcConfig vpcConfig;
        private LogsConfig logConfig;
        private String encryptionKey;
        private String serviceRole;
        private SandboxSession currentSession;

        private BuilderImpl() {
        }

        private BuilderImpl(Sandbox model) {
            this.id(model.id);
            this.arn(model.arn);
            this.projectName(model.projectName);
            this.requestTime(model.requestTime);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.status(model.status);
            this.source(model.source);
            this.sourceVersion(model.sourceVersion);
            this.secondarySources(model.secondarySources);
            this.secondarySourceVersions(model.secondarySourceVersions);
            this.environment(model.environment);
            this.fileSystemLocations(model.fileSystemLocations);
            this.timeoutInMinutes(model.timeoutInMinutes);
            this.queuedTimeoutInMinutes(model.queuedTimeoutInMinutes);
            this.vpcConfig(model.vpcConfig);
            this.logConfig(model.logConfig);
            this.encryptionKey(model.encryptionKey);
            this.serviceRole(model.serviceRole);
            this.currentSession(model.currentSession);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final Instant getRequestTime() {
            return this.requestTime;
        }

        public final void setRequestTime(Instant requestTime) {
            this.requestTime = requestTime;
        }

        @Override
        public final Builder requestTime(Instant requestTime) {
            this.requestTime = requestTime;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final ProjectSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(ProjectSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(ProjectSource source) {
            this.source = source;
            return this;
        }

        public final String getSourceVersion() {
            return this.sourceVersion;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public final List<ProjectSource.Builder> getSecondarySources() {
            List<ProjectSource.Builder> result = ProjectSourcesCopier.copyToBuilder(this.secondarySources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondarySources(Collection<ProjectSource.BuilderImpl> secondarySources) {
            this.secondarySources = ProjectSourcesCopier.copyFromBuilder(secondarySources);
        }

        @Override
        public final Builder secondarySources(Collection<ProjectSource> secondarySources) {
            this.secondarySources = ProjectSourcesCopier.copy(secondarySources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySources(ProjectSource ... secondarySources) {
            this.secondarySources(Arrays.asList(secondarySources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySources(Consumer<ProjectSource.Builder> ... secondarySources) {
            this.secondarySources(Stream.of(secondarySources).map(c -> (ProjectSource)((ProjectSource.Builder)ProjectSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ProjectSourceVersion.Builder> getSecondarySourceVersions() {
            List<ProjectSourceVersion.Builder> result = ProjectSecondarySourceVersionsCopier.copyToBuilder(this.secondarySourceVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondarySourceVersions(Collection<ProjectSourceVersion.BuilderImpl> secondarySourceVersions) {
            this.secondarySourceVersions = ProjectSecondarySourceVersionsCopier.copyFromBuilder(secondarySourceVersions);
        }

        @Override
        public final Builder secondarySourceVersions(Collection<ProjectSourceVersion> secondarySourceVersions) {
            this.secondarySourceVersions = ProjectSecondarySourceVersionsCopier.copy(secondarySourceVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourceVersions(ProjectSourceVersion ... secondarySourceVersions) {
            this.secondarySourceVersions(Arrays.asList(secondarySourceVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourceVersions(Consumer<ProjectSourceVersion.Builder> ... secondarySourceVersions) {
            this.secondarySourceVersions(Stream.of(secondarySourceVersions).map(c -> (ProjectSourceVersion)((ProjectSourceVersion.Builder)ProjectSourceVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ProjectEnvironment.Builder getEnvironment() {
            return this.environment != null ? this.environment.toBuilder() : null;
        }

        public final void setEnvironment(ProjectEnvironment.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        @Override
        public final Builder environment(ProjectEnvironment environment) {
            this.environment = environment;
            return this;
        }

        public final List<ProjectFileSystemLocation.Builder> getFileSystemLocations() {
            List<ProjectFileSystemLocation.Builder> result = ProjectFileSystemLocationsCopier.copyToBuilder(this.fileSystemLocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileSystemLocations(Collection<ProjectFileSystemLocation.BuilderImpl> fileSystemLocations) {
            this.fileSystemLocations = ProjectFileSystemLocationsCopier.copyFromBuilder(fileSystemLocations);
        }

        @Override
        public final Builder fileSystemLocations(Collection<ProjectFileSystemLocation> fileSystemLocations) {
            this.fileSystemLocations = ProjectFileSystemLocationsCopier.copy(fileSystemLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemLocations(ProjectFileSystemLocation ... fileSystemLocations) {
            this.fileSystemLocations(Arrays.asList(fileSystemLocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemLocations(Consumer<ProjectFileSystemLocation.Builder> ... fileSystemLocations) {
            this.fileSystemLocations(Stream.of(fileSystemLocations).map(c -> (ProjectFileSystemLocation)((ProjectFileSystemLocation.Builder)ProjectFileSystemLocation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getTimeoutInMinutes() {
            return this.timeoutInMinutes;
        }

        public final void setTimeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
        }

        @Override
        public final Builder timeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
            return this;
        }

        public final Integer getQueuedTimeoutInMinutes() {
            return this.queuedTimeoutInMinutes;
        }

        public final void setQueuedTimeoutInMinutes(Integer queuedTimeoutInMinutes) {
            this.queuedTimeoutInMinutes = queuedTimeoutInMinutes;
        }

        @Override
        public final Builder queuedTimeoutInMinutes(Integer queuedTimeoutInMinutes) {
            this.queuedTimeoutInMinutes = queuedTimeoutInMinutes;
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final LogsConfig.Builder getLogConfig() {
            return this.logConfig != null ? this.logConfig.toBuilder() : null;
        }

        public final void setLogConfig(LogsConfig.BuilderImpl logConfig) {
            this.logConfig = logConfig != null ? logConfig.build() : null;
        }

        @Override
        public final Builder logConfig(LogsConfig logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        public final String getEncryptionKey() {
            return this.encryptionKey;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        @Override
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final SandboxSession.Builder getCurrentSession() {
            return this.currentSession != null ? this.currentSession.toBuilder() : null;
        }

        public final void setCurrentSession(SandboxSession.BuilderImpl currentSession) {
            this.currentSession = currentSession != null ? currentSession.build() : null;
        }

        @Override
        public final Builder currentSession(SandboxSession currentSession) {
            this.currentSession = currentSession;
            return this;
        }

        public Sandbox build() {
            return new Sandbox(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Sandbox> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder projectName(String var1);

        public Builder requestTime(Instant var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder status(String var1);

        public Builder source(ProjectSource var1);

        default public Builder source(Consumer<ProjectSource.Builder> source) {
            return this.source((ProjectSource)((ProjectSource.Builder)ProjectSource.builder().applyMutation(source)).build());
        }

        public Builder sourceVersion(String var1);

        public Builder secondarySources(Collection<ProjectSource> var1);

        public Builder secondarySources(ProjectSource ... var1);

        public Builder secondarySources(Consumer<ProjectSource.Builder> ... var1);

        public Builder secondarySourceVersions(Collection<ProjectSourceVersion> var1);

        public Builder secondarySourceVersions(ProjectSourceVersion ... var1);

        public Builder secondarySourceVersions(Consumer<ProjectSourceVersion.Builder> ... var1);

        public Builder environment(ProjectEnvironment var1);

        default public Builder environment(Consumer<ProjectEnvironment.Builder> environment) {
            return this.environment((ProjectEnvironment)((ProjectEnvironment.Builder)ProjectEnvironment.builder().applyMutation(environment)).build());
        }

        public Builder fileSystemLocations(Collection<ProjectFileSystemLocation> var1);

        public Builder fileSystemLocations(ProjectFileSystemLocation ... var1);

        public Builder fileSystemLocations(Consumer<ProjectFileSystemLocation.Builder> ... var1);

        public Builder timeoutInMinutes(Integer var1);

        public Builder queuedTimeoutInMinutes(Integer var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder logConfig(LogsConfig var1);

        default public Builder logConfig(Consumer<LogsConfig.Builder> logConfig) {
            return this.logConfig((LogsConfig)((LogsConfig.Builder)LogsConfig.builder().applyMutation(logConfig)).build());
        }

        public Builder encryptionKey(String var1);

        public Builder serviceRole(String var1);

        public Builder currentSession(SandboxSession var1);

        default public Builder currentSession(Consumer<SandboxSession.Builder> currentSession) {
            return this.currentSession((SandboxSession)((SandboxSession.Builder)SandboxSession.builder().applyMutation(currentSession)).build());
        }
    }
}

