/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.CodeBuildResponse;
import software.amazon.awssdk.services.codebuild.model.CommandExecution;
import software.amazon.awssdk.services.codebuild.model.CommandExecutionIdsCopier;
import software.amazon.awssdk.services.codebuild.model.CommandExecutionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetCommandExecutionsResponse
extends CodeBuildResponse
implements ToCopyableBuilder<Builder, BatchGetCommandExecutionsResponse> {
    private static final SdkField<List<CommandExecution>> COMMAND_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("commandExecutions").getter(BatchGetCommandExecutionsResponse.getter(BatchGetCommandExecutionsResponse::commandExecutions)).setter(BatchGetCommandExecutionsResponse.setter(Builder::commandExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commandExecutions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CommandExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> COMMAND_EXECUTIONS_NOT_FOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("commandExecutionsNotFound").getter(BatchGetCommandExecutionsResponse.getter(BatchGetCommandExecutionsResponse::commandExecutionsNotFound)).setter(BatchGetCommandExecutionsResponse.setter(Builder::commandExecutionsNotFound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commandExecutionsNotFound").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_EXECUTIONS_FIELD, COMMAND_EXECUTIONS_NOT_FOUND_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetCommandExecutionsResponse.memberNameToFieldInitializer();
    private final List<CommandExecution> commandExecutions;
    private final List<String> commandExecutionsNotFound;

    private BatchGetCommandExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.commandExecutions = builder.commandExecutions;
        this.commandExecutionsNotFound = builder.commandExecutionsNotFound;
    }

    public final boolean hasCommandExecutions() {
        return this.commandExecutions != null && !(this.commandExecutions instanceof SdkAutoConstructList);
    }

    public final List<CommandExecution> commandExecutions() {
        return this.commandExecutions;
    }

    public final boolean hasCommandExecutionsNotFound() {
        return this.commandExecutionsNotFound != null && !(this.commandExecutionsNotFound instanceof SdkAutoConstructList);
    }

    public final List<String> commandExecutionsNotFound() {
        return this.commandExecutionsNotFound;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommandExecutions() ? this.commandExecutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommandExecutionsNotFound() ? this.commandExecutionsNotFound() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCommandExecutionsResponse)) {
            return false;
        }
        BatchGetCommandExecutionsResponse other = (BatchGetCommandExecutionsResponse)((Object)obj);
        return this.hasCommandExecutions() == other.hasCommandExecutions() && Objects.equals(this.commandExecutions(), other.commandExecutions()) && this.hasCommandExecutionsNotFound() == other.hasCommandExecutionsNotFound() && Objects.equals(this.commandExecutionsNotFound(), other.commandExecutionsNotFound());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetCommandExecutionsResponse").add("CommandExecutions", this.hasCommandExecutions() ? this.commandExecutions() : null).add("CommandExecutionsNotFound", this.hasCommandExecutionsNotFound() ? this.commandExecutionsNotFound() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "commandExecutions": {
                return Optional.ofNullable(clazz.cast(this.commandExecutions()));
            }
            case "commandExecutionsNotFound": {
                return Optional.ofNullable(clazz.cast(this.commandExecutionsNotFound()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("commandExecutions", COMMAND_EXECUTIONS_FIELD);
        map.put("commandExecutionsNotFound", COMMAND_EXECUTIONS_NOT_FOUND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCommandExecutionsResponse, T> g) {
        return obj -> g.apply((BatchGetCommandExecutionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildResponse.BuilderImpl
    implements Builder {
        private List<CommandExecution> commandExecutions = DefaultSdkAutoConstructList.getInstance();
        private List<String> commandExecutionsNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCommandExecutionsResponse model) {
            super(model);
            this.commandExecutions(model.commandExecutions);
            this.commandExecutionsNotFound(model.commandExecutionsNotFound);
        }

        public final List<CommandExecution.Builder> getCommandExecutions() {
            List<CommandExecution.Builder> result = CommandExecutionsCopier.copyToBuilder(this.commandExecutions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCommandExecutions(Collection<CommandExecution.BuilderImpl> commandExecutions) {
            this.commandExecutions = CommandExecutionsCopier.copyFromBuilder(commandExecutions);
        }

        @Override
        public final Builder commandExecutions(Collection<CommandExecution> commandExecutions) {
            this.commandExecutions = CommandExecutionsCopier.copy(commandExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandExecutions(CommandExecution ... commandExecutions) {
            this.commandExecutions(Arrays.asList(commandExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandExecutions(Consumer<CommandExecution.Builder> ... commandExecutions) {
            this.commandExecutions(Stream.of(commandExecutions).map(c -> (CommandExecution)((CommandExecution.Builder)CommandExecution.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getCommandExecutionsNotFound() {
            if (this.commandExecutionsNotFound instanceof SdkAutoConstructList) {
                return null;
            }
            return this.commandExecutionsNotFound;
        }

        public final void setCommandExecutionsNotFound(Collection<String> commandExecutionsNotFound) {
            this.commandExecutionsNotFound = CommandExecutionIdsCopier.copy(commandExecutionsNotFound);
        }

        @Override
        public final Builder commandExecutionsNotFound(Collection<String> commandExecutionsNotFound) {
            this.commandExecutionsNotFound = CommandExecutionIdsCopier.copy(commandExecutionsNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandExecutionsNotFound(String ... commandExecutionsNotFound) {
            this.commandExecutionsNotFound(Arrays.asList(commandExecutionsNotFound));
            return this;
        }

        @Override
        public BatchGetCommandExecutionsResponse build() {
            return new BatchGetCommandExecutionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeBuildResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetCommandExecutionsResponse> {
        public Builder commandExecutions(Collection<CommandExecution> var1);

        public Builder commandExecutions(CommandExecution ... var1);

        public Builder commandExecutions(Consumer<CommandExecution.Builder> ... var1);

        public Builder commandExecutionsNotFound(Collection<String> var1);

        public Builder commandExecutionsNotFound(String ... var1);
    }
}

