/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codebuild.model.CloudWatchLogsConfig;
import software.amazon.awssdk.services.codebuild.model.S3LogsConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogsConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogsConfig> {
    private static final SdkField<CloudWatchLogsConfig> CLOUD_WATCH_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cloudWatchLogs").getter(LogsConfig.getter(LogsConfig::cloudWatchLogs)).setter(LogsConfig.setter(Builder::cloudWatchLogs)).constructor(CloudWatchLogsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogs").build()}).build();
    private static final SdkField<S3LogsConfig> S3_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Logs").getter(LogsConfig.getter(LogsConfig::s3Logs)).setter(LogsConfig.setter(Builder::s3Logs)).constructor(S3LogsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Logs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_LOGS_FIELD, S3_LOGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("cloudWatchLogs", CLOUD_WATCH_LOGS_FIELD);
            this.put("s3Logs", S3_LOGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final CloudWatchLogsConfig cloudWatchLogs;
    private final S3LogsConfig s3Logs;

    private LogsConfig(BuilderImpl builder) {
        this.cloudWatchLogs = builder.cloudWatchLogs;
        this.s3Logs = builder.s3Logs;
    }

    public final CloudWatchLogsConfig cloudWatchLogs() {
        return this.cloudWatchLogs;
    }

    public final S3LogsConfig s3Logs() {
        return this.s3Logs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Logs());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogsConfig)) {
            return false;
        }
        LogsConfig other = (LogsConfig)obj;
        return Objects.equals(this.cloudWatchLogs(), other.cloudWatchLogs()) && Objects.equals(this.s3Logs(), other.s3Logs());
    }

    public final String toString() {
        return ToString.builder((String)"LogsConfig").add("CloudWatchLogs", (Object)this.cloudWatchLogs()).add("S3Logs", (Object)this.s3Logs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cloudWatchLogs": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogs()));
            }
            case "s3Logs": {
                return Optional.ofNullable(clazz.cast(this.s3Logs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LogsConfig, T> g) {
        return obj -> g.apply((LogsConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CloudWatchLogsConfig cloudWatchLogs;
        private S3LogsConfig s3Logs;

        private BuilderImpl() {
        }

        private BuilderImpl(LogsConfig model) {
            this.cloudWatchLogs(model.cloudWatchLogs);
            this.s3Logs(model.s3Logs);
        }

        public final CloudWatchLogsConfig.Builder getCloudWatchLogs() {
            return this.cloudWatchLogs != null ? this.cloudWatchLogs.toBuilder() : null;
        }

        public final void setCloudWatchLogs(CloudWatchLogsConfig.BuilderImpl cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs != null ? cloudWatchLogs.build() : null;
        }

        @Override
        public final Builder cloudWatchLogs(CloudWatchLogsConfig cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs;
            return this;
        }

        public final S3LogsConfig.Builder getS3Logs() {
            return this.s3Logs != null ? this.s3Logs.toBuilder() : null;
        }

        public final void setS3Logs(S3LogsConfig.BuilderImpl s3Logs) {
            this.s3Logs = s3Logs != null ? s3Logs.build() : null;
        }

        @Override
        public final Builder s3Logs(S3LogsConfig s3Logs) {
            this.s3Logs = s3Logs;
            return this;
        }

        public LogsConfig build() {
            return new LogsConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogsConfig> {
        public Builder cloudWatchLogs(CloudWatchLogsConfig var1);

        default public Builder cloudWatchLogs(Consumer<CloudWatchLogsConfig.Builder> cloudWatchLogs) {
            return this.cloudWatchLogs((CloudWatchLogsConfig)((CloudWatchLogsConfig.Builder)CloudWatchLogsConfig.builder().applyMutation(cloudWatchLogs)).build());
        }

        public Builder s3Logs(S3LogsConfig var1);

        default public Builder s3Logs(Consumer<S3LogsConfig.Builder> s3Logs) {
            return this.s3Logs((S3LogsConfig)((S3LogsConfig.Builder)S3LogsConfig.builder().applyMutation(s3Logs)).build());
        }
    }
}

