/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.EnvironmentLanguage;
import software.amazon.awssdk.services.codebuild.model.EnvironmentLanguagesCopier;
import software.amazon.awssdk.services.codebuild.model.PlatformType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentPlatform
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnvironmentPlatform> {
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platform").getter(EnvironmentPlatform.getter(EnvironmentPlatform::platformAsString)).setter(EnvironmentPlatform.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<List<EnvironmentLanguage>> LANGUAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("languages").getter(EnvironmentPlatform.getter(EnvironmentPlatform::languages)).setter(EnvironmentPlatform.setter(Builder::languages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnvironmentLanguage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_FIELD, LANGUAGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("platform", PLATFORM_FIELD);
            this.put("languages", LANGUAGES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String platform;
    private final List<EnvironmentLanguage> languages;

    private EnvironmentPlatform(BuilderImpl builder) {
        this.platform = builder.platform;
        this.languages = builder.languages;
    }

    public final PlatformType platform() {
        return PlatformType.fromValue(this.platform);
    }

    public final String platformAsString() {
        return this.platform;
    }

    public final boolean hasLanguages() {
        return this.languages != null && !(this.languages instanceof SdkAutoConstructList);
    }

    public final List<EnvironmentLanguage> languages() {
        return this.languages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLanguages() ? this.languages() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentPlatform)) {
            return false;
        }
        EnvironmentPlatform other = (EnvironmentPlatform)obj;
        return Objects.equals(this.platformAsString(), other.platformAsString()) && this.hasLanguages() == other.hasLanguages() && Objects.equals(this.languages(), other.languages());
    }

    public final String toString() {
        return ToString.builder((String)"EnvironmentPlatform").add("Platform", (Object)this.platformAsString()).add("Languages", this.hasLanguages() ? this.languages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "languages": {
                return Optional.ofNullable(clazz.cast(this.languages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentPlatform, T> g) {
        return obj -> g.apply((EnvironmentPlatform)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String platform;
        private List<EnvironmentLanguage> languages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentPlatform model) {
            this.platform(model.platform);
            this.languages(model.languages);
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformType platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final List<EnvironmentLanguage.Builder> getLanguages() {
            List<EnvironmentLanguage.Builder> result = EnvironmentLanguagesCopier.copyToBuilder(this.languages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLanguages(Collection<EnvironmentLanguage.BuilderImpl> languages) {
            this.languages = EnvironmentLanguagesCopier.copyFromBuilder(languages);
        }

        @Override
        public final Builder languages(Collection<EnvironmentLanguage> languages) {
            this.languages = EnvironmentLanguagesCopier.copy(languages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languages(EnvironmentLanguage ... languages) {
            this.languages(Arrays.asList(languages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languages(Consumer<EnvironmentLanguage.Builder> ... languages) {
            this.languages(Stream.of(languages).map(c -> (EnvironmentLanguage)((EnvironmentLanguage.Builder)EnvironmentLanguage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EnvironmentPlatform build() {
            return new EnvironmentPlatform(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnvironmentPlatform> {
        public Builder platform(String var1);

        public Builder platform(PlatformType var1);

        public Builder languages(Collection<EnvironmentLanguage> var1);

        public Builder languages(EnvironmentLanguage ... var1);

        public Builder languages(Consumer<EnvironmentLanguage.Builder> ... var1);
    }
}

