/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ArtifactPackaging {
    NONE("NONE"),
    ZIP("ZIP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ArtifactPackaging> VALUE_MAP;
    private final String value;

    private ArtifactPackaging(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ArtifactPackaging fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ArtifactPackaging> knownValues() {
        EnumSet<ArtifactPackaging> knownValues = EnumSet.allOf(ArtifactPackaging.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ArtifactPackaging.class, ArtifactPackaging::toString);
    }
}

