/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the results from running a series of test cases during the run of a build project. The test cases
 * are specified in the buildspec for the build project using one or more paths to the test case files. You can specify
 * any type of tests you want, such as unit tests, integration tests, and functional tests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Report implements SdkPojo, Serializable, ToCopyableBuilder<Report.Builder, Report> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Report::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Report::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Report::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> REPORT_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reportGroupArn").getter(getter(Report::reportGroupArn)).setter(setter(Builder::reportGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportGroupArn").build()).build();

    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionId").getter(getter(Report::executionId)).setter(setter(Builder::executionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Report::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("created").getter(getter(Report::created)).setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()).build();

    private static final SdkField<Instant> EXPIRED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("expired").getter(getter(Report::expired)).setter(setter(Builder::expired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expired").build()).build();

    private static final SdkField<ReportExportConfig> EXPORT_CONFIG_FIELD = SdkField
            .<ReportExportConfig> builder(MarshallingType.SDK_POJO).memberName("exportConfig")
            .getter(getter(Report::exportConfig)).setter(setter(Builder::exportConfig)).constructor(ReportExportConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportConfig").build()).build();

    private static final SdkField<Boolean> TRUNCATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("truncated").getter(getter(Report::truncated)).setter(setter(Builder::truncated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("truncated").build()).build();

    private static final SdkField<TestReportSummary> TEST_SUMMARY_FIELD = SdkField
            .<TestReportSummary> builder(MarshallingType.SDK_POJO).memberName("testSummary").getter(getter(Report::testSummary))
            .setter(setter(Builder::testSummary)).constructor(TestReportSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSummary").build()).build();

    private static final SdkField<CodeCoverageReportSummary> CODE_COVERAGE_SUMMARY_FIELD = SdkField
            .<CodeCoverageReportSummary> builder(MarshallingType.SDK_POJO).memberName("codeCoverageSummary")
            .getter(getter(Report::codeCoverageSummary)).setter(setter(Builder::codeCoverageSummary))
            .constructor(CodeCoverageReportSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeCoverageSummary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, TYPE_FIELD,
            NAME_FIELD, REPORT_GROUP_ARN_FIELD, EXECUTION_ID_FIELD, STATUS_FIELD, CREATED_FIELD, EXPIRED_FIELD,
            EXPORT_CONFIG_FIELD, TRUNCATED_FIELD, TEST_SUMMARY_FIELD, CODE_COVERAGE_SUMMARY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String type;

    private final String name;

    private final String reportGroupArn;

    private final String executionId;

    private final String status;

    private final Instant created;

    private final Instant expired;

    private final ReportExportConfig exportConfig;

    private final Boolean truncated;

    private final TestReportSummary testSummary;

    private final CodeCoverageReportSummary codeCoverageSummary;

    private Report(BuilderImpl builder) {
        this.arn = builder.arn;
        this.type = builder.type;
        this.name = builder.name;
        this.reportGroupArn = builder.reportGroupArn;
        this.executionId = builder.executionId;
        this.status = builder.status;
        this.created = builder.created;
        this.expired = builder.expired;
        this.exportConfig = builder.exportConfig;
        this.truncated = builder.truncated;
        this.testSummary = builder.testSummary;
        this.codeCoverageSummary = builder.codeCoverageSummary;
    }

    /**
     * <p>
     * The ARN of the report run.
     * </p>
     * 
     * @return The ARN of the report run.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The type of the report that was run.
     * </p>
     * <dl>
     * <dt>CODE_COVERAGE</dt>
     * <dd>
     * <p>
     * A code coverage report.
     * </p>
     * </dd>
     * <dt>TEST</dt>
     * <dd>
     * <p>
     * A test report.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ReportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the report that was run.</p>
     *         <dl>
     *         <dt>CODE_COVERAGE</dt>
     *         <dd>
     *         <p>
     *         A code coverage report.
     *         </p>
     *         </dd>
     *         <dt>TEST</dt>
     *         <dd>
     *         <p>
     *         A test report.
     *         </p>
     *         </dd>
     * @see ReportType
     */
    public final ReportType type() {
        return ReportType.fromValue(type);
    }

    /**
     * <p>
     * The type of the report that was run.
     * </p>
     * <dl>
     * <dt>CODE_COVERAGE</dt>
     * <dd>
     * <p>
     * A code coverage report.
     * </p>
     * </dd>
     * <dt>TEST</dt>
     * <dd>
     * <p>
     * A test report.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ReportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the report that was run.</p>
     *         <dl>
     *         <dt>CODE_COVERAGE</dt>
     *         <dd>
     *         <p>
     *         A code coverage report.
     *         </p>
     *         </dd>
     *         <dt>TEST</dt>
     *         <dd>
     *         <p>
     *         A test report.
     *         </p>
     *         </dd>
     * @see ReportType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the report that was run.
     * </p>
     * 
     * @return The name of the report that was run.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of the report group associated with this report.
     * </p>
     * 
     * @return The ARN of the report group associated with this report.
     */
    public final String reportGroupArn() {
        return reportGroupArn;
    }

    /**
     * <p>
     * The ARN of the build run that generated this report.
     * </p>
     * 
     * @return The ARN of the build run that generated this report.
     */
    public final String executionId() {
        return executionId;
    }

    /**
     * <p>
     * The status of this report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReportStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of this report.
     * @see ReportStatusType
     */
    public final ReportStatusType status() {
        return ReportStatusType.fromValue(status);
    }

    /**
     * <p>
     * The status of this report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReportStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of this report.
     * @see ReportStatusType
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time this report run occurred.
     * </p>
     * 
     * @return The date and time this report run occurred.
     */
    public final Instant created() {
        return created;
    }

    /**
     * <p>
     * The date and time a report expires. A report expires 30 days after it is created. An expired report is not
     * available to view in CodeBuild.
     * </p>
     * 
     * @return The date and time a report expires. A report expires 30 days after it is created. An expired report is
     *         not available to view in CodeBuild.
     */
    public final Instant expired() {
        return expired;
    }

    /**
     * <p>
     * Information about where the raw data used to generate this report was exported.
     * </p>
     * 
     * @return Information about where the raw data used to generate this report was exported.
     */
    public final ReportExportConfig exportConfig() {
        return exportConfig;
    }

    /**
     * <p>
     * A boolean that specifies if this report run is truncated. The list of test cases is truncated after the maximum
     * number of test cases is reached.
     * </p>
     * 
     * @return A boolean that specifies if this report run is truncated. The list of test cases is truncated after the
     *         maximum number of test cases is reached.
     */
    public final Boolean truncated() {
        return truncated;
    }

    /**
     * <p>
     * A <code>TestReportSummary</code> object that contains information about this test report.
     * </p>
     * 
     * @return A <code>TestReportSummary</code> object that contains information about this test report.
     */
    public final TestReportSummary testSummary() {
        return testSummary;
    }

    /**
     * <p>
     * A <code>CodeCoverageReportSummary</code> object that contains a code coverage summary for this report.
     * </p>
     * 
     * @return A <code>CodeCoverageReportSummary</code> object that contains a code coverage summary for this report.
     */
    public final CodeCoverageReportSummary codeCoverageSummary() {
        return codeCoverageSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(reportGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(executionId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(expired());
        hashCode = 31 * hashCode + Objects.hashCode(exportConfig());
        hashCode = 31 * hashCode + Objects.hashCode(truncated());
        hashCode = 31 * hashCode + Objects.hashCode(testSummary());
        hashCode = 31 * hashCode + Objects.hashCode(codeCoverageSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Report)) {
            return false;
        }
        Report other = (Report) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(name(), other.name()) && Objects.equals(reportGroupArn(), other.reportGroupArn())
                && Objects.equals(executionId(), other.executionId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(created(), other.created()) && Objects.equals(expired(), other.expired())
                && Objects.equals(exportConfig(), other.exportConfig()) && Objects.equals(truncated(), other.truncated())
                && Objects.equals(testSummary(), other.testSummary())
                && Objects.equals(codeCoverageSummary(), other.codeCoverageSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Report").add("Arn", arn()).add("Type", typeAsString()).add("Name", name())
                .add("ReportGroupArn", reportGroupArn()).add("ExecutionId", executionId()).add("Status", statusAsString())
                .add("Created", created()).add("Expired", expired()).add("ExportConfig", exportConfig())
                .add("Truncated", truncated()).add("TestSummary", testSummary())
                .add("CodeCoverageSummary", codeCoverageSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "reportGroupArn":
            return Optional.ofNullable(clazz.cast(reportGroupArn()));
        case "executionId":
            return Optional.ofNullable(clazz.cast(executionId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "created":
            return Optional.ofNullable(clazz.cast(created()));
        case "expired":
            return Optional.ofNullable(clazz.cast(expired()));
        case "exportConfig":
            return Optional.ofNullable(clazz.cast(exportConfig()));
        case "truncated":
            return Optional.ofNullable(clazz.cast(truncated()));
        case "testSummary":
            return Optional.ofNullable(clazz.cast(testSummary()));
        case "codeCoverageSummary":
            return Optional.ofNullable(clazz.cast(codeCoverageSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Report, T> g) {
        return obj -> g.apply((Report) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Report> {
        /**
         * <p>
         * The ARN of the report run.
         * </p>
         * 
         * @param arn
         *        The ARN of the report run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The type of the report that was run.
         * </p>
         * <dl>
         * <dt>CODE_COVERAGE</dt>
         * <dd>
         * <p>
         * A code coverage report.
         * </p>
         * </dd>
         * <dt>TEST</dt>
         * <dd>
         * <p>
         * A test report.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param type
         *        The type of the report that was run.</p>
         *        <dl>
         *        <dt>CODE_COVERAGE</dt>
         *        <dd>
         *        <p>
         *        A code coverage report.
         *        </p>
         *        </dd>
         *        <dt>TEST</dt>
         *        <dd>
         *        <p>
         *        A test report.
         *        </p>
         *        </dd>
         * @see ReportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the report that was run.
         * </p>
         * <dl>
         * <dt>CODE_COVERAGE</dt>
         * <dd>
         * <p>
         * A code coverage report.
         * </p>
         * </dd>
         * <dt>TEST</dt>
         * <dd>
         * <p>
         * A test report.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param type
         *        The type of the report that was run.</p>
         *        <dl>
         *        <dt>CODE_COVERAGE</dt>
         *        <dd>
         *        <p>
         *        A code coverage report.
         *        </p>
         *        </dd>
         *        <dt>TEST</dt>
         *        <dd>
         *        <p>
         *        A test report.
         *        </p>
         *        </dd>
         * @see ReportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportType
         */
        Builder type(ReportType type);

        /**
         * <p>
         * The name of the report that was run.
         * </p>
         * 
         * @param name
         *        The name of the report that was run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of the report group associated with this report.
         * </p>
         * 
         * @param reportGroupArn
         *        The ARN of the report group associated with this report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportGroupArn(String reportGroupArn);

        /**
         * <p>
         * The ARN of the build run that generated this report.
         * </p>
         * 
         * @param executionId
         *        The ARN of the build run that generated this report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionId(String executionId);

        /**
         * <p>
         * The status of this report.
         * </p>
         * 
         * @param status
         *        The status of this report.
         * @see ReportStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The status of this report.
         * </p>
         * 
         * @param status
         *        The status of this report.
         * @see ReportStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportStatusType
         */
        Builder status(ReportStatusType status);

        /**
         * <p>
         * The date and time this report run occurred.
         * </p>
         * 
         * @param created
         *        The date and time this report run occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * The date and time a report expires. A report expires 30 days after it is created. An expired report is not
         * available to view in CodeBuild.
         * </p>
         * 
         * @param expired
         *        The date and time a report expires. A report expires 30 days after it is created. An expired report is
         *        not available to view in CodeBuild.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expired(Instant expired);

        /**
         * <p>
         * Information about where the raw data used to generate this report was exported.
         * </p>
         * 
         * @param exportConfig
         *        Information about where the raw data used to generate this report was exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportConfig(ReportExportConfig exportConfig);

        /**
         * <p>
         * Information about where the raw data used to generate this report was exported.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReportExportConfig.Builder} avoiding the
         * need to create one manually via {@link ReportExportConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReportExportConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #exportConfig(ReportExportConfig)}.
         * 
         * @param exportConfig
         *        a consumer that will call methods on {@link ReportExportConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportConfig(ReportExportConfig)
         */
        default Builder exportConfig(Consumer<ReportExportConfig.Builder> exportConfig) {
            return exportConfig(ReportExportConfig.builder().applyMutation(exportConfig).build());
        }

        /**
         * <p>
         * A boolean that specifies if this report run is truncated. The list of test cases is truncated after the
         * maximum number of test cases is reached.
         * </p>
         * 
         * @param truncated
         *        A boolean that specifies if this report run is truncated. The list of test cases is truncated after
         *        the maximum number of test cases is reached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder truncated(Boolean truncated);

        /**
         * <p>
         * A <code>TestReportSummary</code> object that contains information about this test report.
         * </p>
         * 
         * @param testSummary
         *        A <code>TestReportSummary</code> object that contains information about this test report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSummary(TestReportSummary testSummary);

        /**
         * <p>
         * A <code>TestReportSummary</code> object that contains information about this test report.
         * </p>
         * This is a convenience method that creates an instance of the {@link TestReportSummary.Builder} avoiding the
         * need to create one manually via {@link TestReportSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TestReportSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #testSummary(TestReportSummary)}.
         * 
         * @param testSummary
         *        a consumer that will call methods on {@link TestReportSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #testSummary(TestReportSummary)
         */
        default Builder testSummary(Consumer<TestReportSummary.Builder> testSummary) {
            return testSummary(TestReportSummary.builder().applyMutation(testSummary).build());
        }

        /**
         * <p>
         * A <code>CodeCoverageReportSummary</code> object that contains a code coverage summary for this report.
         * </p>
         * 
         * @param codeCoverageSummary
         *        A <code>CodeCoverageReportSummary</code> object that contains a code coverage summary for this report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeCoverageSummary(CodeCoverageReportSummary codeCoverageSummary);

        /**
         * <p>
         * A <code>CodeCoverageReportSummary</code> object that contains a code coverage summary for this report.
         * </p>
         * This is a convenience method that creates an instance of the {@link CodeCoverageReportSummary.Builder}
         * avoiding the need to create one manually via {@link CodeCoverageReportSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CodeCoverageReportSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #codeCoverageSummary(CodeCoverageReportSummary)}.
         * 
         * @param codeCoverageSummary
         *        a consumer that will call methods on {@link CodeCoverageReportSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeCoverageSummary(CodeCoverageReportSummary)
         */
        default Builder codeCoverageSummary(Consumer<CodeCoverageReportSummary.Builder> codeCoverageSummary) {
            return codeCoverageSummary(CodeCoverageReportSummary.builder().applyMutation(codeCoverageSummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String type;

        private String name;

        private String reportGroupArn;

        private String executionId;

        private String status;

        private Instant created;

        private Instant expired;

        private ReportExportConfig exportConfig;

        private Boolean truncated;

        private TestReportSummary testSummary;

        private CodeCoverageReportSummary codeCoverageSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(Report model) {
            arn(model.arn);
            type(model.type);
            name(model.name);
            reportGroupArn(model.reportGroupArn);
            executionId(model.executionId);
            status(model.status);
            created(model.created);
            expired(model.expired);
            exportConfig(model.exportConfig);
            truncated(model.truncated);
            testSummary(model.testSummary);
            codeCoverageSummary(model.codeCoverageSummary);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ReportType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getReportGroupArn() {
            return reportGroupArn;
        }

        public final void setReportGroupArn(String reportGroupArn) {
            this.reportGroupArn = reportGroupArn;
        }

        @Override
        public final Builder reportGroupArn(String reportGroupArn) {
            this.reportGroupArn = reportGroupArn;
            return this;
        }

        public final String getExecutionId() {
            return executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReportStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreated() {
            return created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final Instant getExpired() {
            return expired;
        }

        public final void setExpired(Instant expired) {
            this.expired = expired;
        }

        @Override
        public final Builder expired(Instant expired) {
            this.expired = expired;
            return this;
        }

        public final ReportExportConfig.Builder getExportConfig() {
            return exportConfig != null ? exportConfig.toBuilder() : null;
        }

        public final void setExportConfig(ReportExportConfig.BuilderImpl exportConfig) {
            this.exportConfig = exportConfig != null ? exportConfig.build() : null;
        }

        @Override
        public final Builder exportConfig(ReportExportConfig exportConfig) {
            this.exportConfig = exportConfig;
            return this;
        }

        public final Boolean getTruncated() {
            return truncated;
        }

        public final void setTruncated(Boolean truncated) {
            this.truncated = truncated;
        }

        @Override
        public final Builder truncated(Boolean truncated) {
            this.truncated = truncated;
            return this;
        }

        public final TestReportSummary.Builder getTestSummary() {
            return testSummary != null ? testSummary.toBuilder() : null;
        }

        public final void setTestSummary(TestReportSummary.BuilderImpl testSummary) {
            this.testSummary = testSummary != null ? testSummary.build() : null;
        }

        @Override
        public final Builder testSummary(TestReportSummary testSummary) {
            this.testSummary = testSummary;
            return this;
        }

        public final CodeCoverageReportSummary.Builder getCodeCoverageSummary() {
            return codeCoverageSummary != null ? codeCoverageSummary.toBuilder() : null;
        }

        public final void setCodeCoverageSummary(CodeCoverageReportSummary.BuilderImpl codeCoverageSummary) {
            this.codeCoverageSummary = codeCoverageSummary != null ? codeCoverageSummary.build() : null;
        }

        @Override
        public final Builder codeCoverageSummary(CodeCoverageReportSummary codeCoverageSummary) {
            this.codeCoverageSummary = codeCoverageSummary;
            return this;
        }

        @Override
        public Report build() {
            return new Report(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
