/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.ComputeTypesAllowedCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchRestrictions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchRestrictions> {
    private static final SdkField<Integer> MAXIMUM_BUILDS_ALLOWED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maximumBuildsAllowed").getter(BatchRestrictions.getter(BatchRestrictions::maximumBuildsAllowed)).setter(BatchRestrictions.setter(Builder::maximumBuildsAllowed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumBuildsAllowed").build()}).build();
    private static final SdkField<List<String>> COMPUTE_TYPES_ALLOWED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("computeTypesAllowed").getter(BatchRestrictions.getter(BatchRestrictions::computeTypesAllowed)).setter(BatchRestrictions.setter(Builder::computeTypesAllowed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeTypesAllowed").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_BUILDS_ALLOWED_FIELD, COMPUTE_TYPES_ALLOWED_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer maximumBuildsAllowed;
    private final List<String> computeTypesAllowed;

    private BatchRestrictions(BuilderImpl builder) {
        this.maximumBuildsAllowed = builder.maximumBuildsAllowed;
        this.computeTypesAllowed = builder.computeTypesAllowed;
    }

    public final Integer maximumBuildsAllowed() {
        return this.maximumBuildsAllowed;
    }

    public final boolean hasComputeTypesAllowed() {
        return this.computeTypesAllowed != null && !(this.computeTypesAllowed instanceof SdkAutoConstructList);
    }

    public final List<String> computeTypesAllowed() {
        return this.computeTypesAllowed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumBuildsAllowed());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComputeTypesAllowed() ? this.computeTypesAllowed() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchRestrictions)) {
            return false;
        }
        BatchRestrictions other = (BatchRestrictions)obj;
        return Objects.equals(this.maximumBuildsAllowed(), other.maximumBuildsAllowed()) && this.hasComputeTypesAllowed() == other.hasComputeTypesAllowed() && Objects.equals(this.computeTypesAllowed(), other.computeTypesAllowed());
    }

    public final String toString() {
        return ToString.builder((String)"BatchRestrictions").add("MaximumBuildsAllowed", (Object)this.maximumBuildsAllowed()).add("ComputeTypesAllowed", this.hasComputeTypesAllowed() ? this.computeTypesAllowed() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maximumBuildsAllowed": {
                return Optional.ofNullable(clazz.cast(this.maximumBuildsAllowed()));
            }
            case "computeTypesAllowed": {
                return Optional.ofNullable(clazz.cast(this.computeTypesAllowed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchRestrictions, T> g) {
        return obj -> g.apply((BatchRestrictions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maximumBuildsAllowed;
        private List<String> computeTypesAllowed = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchRestrictions model) {
            this.maximumBuildsAllowed(model.maximumBuildsAllowed);
            this.computeTypesAllowed(model.computeTypesAllowed);
        }

        public final Integer getMaximumBuildsAllowed() {
            return this.maximumBuildsAllowed;
        }

        public final void setMaximumBuildsAllowed(Integer maximumBuildsAllowed) {
            this.maximumBuildsAllowed = maximumBuildsAllowed;
        }

        @Override
        public final Builder maximumBuildsAllowed(Integer maximumBuildsAllowed) {
            this.maximumBuildsAllowed = maximumBuildsAllowed;
            return this;
        }

        public final Collection<String> getComputeTypesAllowed() {
            if (this.computeTypesAllowed instanceof SdkAutoConstructList) {
                return null;
            }
            return this.computeTypesAllowed;
        }

        public final void setComputeTypesAllowed(Collection<String> computeTypesAllowed) {
            this.computeTypesAllowed = ComputeTypesAllowedCopier.copy(computeTypesAllowed);
        }

        @Override
        public final Builder computeTypesAllowed(Collection<String> computeTypesAllowed) {
            this.computeTypesAllowed = ComputeTypesAllowedCopier.copy(computeTypesAllowed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeTypesAllowed(String ... computeTypesAllowed) {
            this.computeTypesAllowed(Arrays.asList(computeTypesAllowed));
            return this;
        }

        public BatchRestrictions build() {
            return new BatchRestrictions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchRestrictions> {
        public Builder maximumBuildsAllowed(Integer var1);

        public Builder computeTypesAllowed(Collection<String> var1);

        public Builder computeTypesAllowed(String ... var1);
    }
}

