/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.CodeBuildResponse;
import software.amazon.awssdk.services.codebuild.model.CodeCoverage;
import software.amazon.awssdk.services.codebuild.model.CodeCoveragesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCodeCoveragesResponse
extends CodeBuildResponse
implements ToCopyableBuilder<Builder, DescribeCodeCoveragesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeCodeCoveragesResponse.getter(DescribeCodeCoveragesResponse::nextToken)).setter(DescribeCodeCoveragesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<CodeCoverage>> CODE_COVERAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("codeCoverages").getter(DescribeCodeCoveragesResponse.getter(DescribeCodeCoveragesResponse::codeCoverages)).setter(DescribeCodeCoveragesResponse.setter(Builder::codeCoverages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeCoverages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CodeCoverage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CODE_COVERAGES_FIELD));
    private final String nextToken;
    private final List<CodeCoverage> codeCoverages;

    private DescribeCodeCoveragesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.codeCoverages = builder.codeCoverages;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasCodeCoverages() {
        return this.codeCoverages != null && !(this.codeCoverages instanceof SdkAutoConstructList);
    }

    public final List<CodeCoverage> codeCoverages() {
        return this.codeCoverages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCodeCoverages() ? this.codeCoverages() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCodeCoveragesResponse)) {
            return false;
        }
        DescribeCodeCoveragesResponse other = (DescribeCodeCoveragesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasCodeCoverages() == other.hasCodeCoverages() && Objects.equals(this.codeCoverages(), other.codeCoverages());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCodeCoveragesResponse").add("NextToken", (Object)this.nextToken()).add("CodeCoverages", this.hasCodeCoverages() ? this.codeCoverages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "codeCoverages": {
                return Optional.ofNullable(clazz.cast(this.codeCoverages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCodeCoveragesResponse, T> g) {
        return obj -> g.apply((DescribeCodeCoveragesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CodeCoverage> codeCoverages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCodeCoveragesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.codeCoverages(model.codeCoverages);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CodeCoverage.Builder> getCodeCoverages() {
            List<CodeCoverage.Builder> result = CodeCoveragesCopier.copyToBuilder(this.codeCoverages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCodeCoverages(Collection<CodeCoverage.BuilderImpl> codeCoverages) {
            this.codeCoverages = CodeCoveragesCopier.copyFromBuilder(codeCoverages);
        }

        @Override
        @Transient
        public final Builder codeCoverages(Collection<CodeCoverage> codeCoverages) {
            this.codeCoverages = CodeCoveragesCopier.copy(codeCoverages);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder codeCoverages(CodeCoverage ... codeCoverages) {
            this.codeCoverages(Arrays.asList(codeCoverages));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder codeCoverages(Consumer<CodeCoverage.Builder> ... codeCoverages) {
            this.codeCoverages(Stream.of(codeCoverages).map(c -> (CodeCoverage)((CodeCoverage.Builder)CodeCoverage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeCodeCoveragesResponse build() {
            return new DescribeCodeCoveragesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeBuildResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCodeCoveragesResponse> {
        public Builder nextToken(String var1);

        public Builder codeCoverages(Collection<CodeCoverage> var1);

        public Builder codeCoverages(CodeCoverage ... var1);

        public Builder codeCoverages(Consumer<CodeCoverage.Builder> ... var1);
    }
}

