/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.CodeBuildResponse;
import software.amazon.awssdk.services.codebuild.model.ReportGroup;
import software.amazon.awssdk.services.codebuild.model.ReportGroupArnsCopier;
import software.amazon.awssdk.services.codebuild.model.ReportGroupsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetReportGroupsResponse
extends CodeBuildResponse
implements ToCopyableBuilder<Builder, BatchGetReportGroupsResponse> {
    private static final SdkField<List<ReportGroup>> REPORT_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("reportGroups").getter(BatchGetReportGroupsResponse.getter(BatchGetReportGroupsResponse::reportGroups)).setter(BatchGetReportGroupsResponse.setter(Builder::reportGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReportGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REPORT_GROUPS_NOT_FOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("reportGroupsNotFound").getter(BatchGetReportGroupsResponse.getter(BatchGetReportGroupsResponse::reportGroupsNotFound)).setter(BatchGetReportGroupsResponse.setter(Builder::reportGroupsNotFound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportGroupsNotFound").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_GROUPS_FIELD, REPORT_GROUPS_NOT_FOUND_FIELD));
    private final List<ReportGroup> reportGroups;
    private final List<String> reportGroupsNotFound;

    private BatchGetReportGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.reportGroups = builder.reportGroups;
        this.reportGroupsNotFound = builder.reportGroupsNotFound;
    }

    public final boolean hasReportGroups() {
        return this.reportGroups != null && !(this.reportGroups instanceof SdkAutoConstructList);
    }

    public final List<ReportGroup> reportGroups() {
        return this.reportGroups;
    }

    public final boolean hasReportGroupsNotFound() {
        return this.reportGroupsNotFound != null && !(this.reportGroupsNotFound instanceof SdkAutoConstructList);
    }

    public final List<String> reportGroupsNotFound() {
        return this.reportGroupsNotFound;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReportGroups() ? this.reportGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReportGroupsNotFound() ? this.reportGroupsNotFound() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetReportGroupsResponse)) {
            return false;
        }
        BatchGetReportGroupsResponse other = (BatchGetReportGroupsResponse)((Object)obj);
        return this.hasReportGroups() == other.hasReportGroups() && Objects.equals(this.reportGroups(), other.reportGroups()) && this.hasReportGroupsNotFound() == other.hasReportGroupsNotFound() && Objects.equals(this.reportGroupsNotFound(), other.reportGroupsNotFound());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetReportGroupsResponse").add("ReportGroups", this.hasReportGroups() ? this.reportGroups() : null).add("ReportGroupsNotFound", this.hasReportGroupsNotFound() ? this.reportGroupsNotFound() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "reportGroups": {
                return Optional.ofNullable(clazz.cast(this.reportGroups()));
            }
            case "reportGroupsNotFound": {
                return Optional.ofNullable(clazz.cast(this.reportGroupsNotFound()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetReportGroupsResponse, T> g) {
        return obj -> g.apply((BatchGetReportGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildResponse.BuilderImpl
    implements Builder {
        private List<ReportGroup> reportGroups = DefaultSdkAutoConstructList.getInstance();
        private List<String> reportGroupsNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetReportGroupsResponse model) {
            super(model);
            this.reportGroups(model.reportGroups);
            this.reportGroupsNotFound(model.reportGroupsNotFound);
        }

        public final List<ReportGroup.Builder> getReportGroups() {
            List<ReportGroup.Builder> result = ReportGroupsCopier.copyToBuilder(this.reportGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReportGroups(Collection<ReportGroup.BuilderImpl> reportGroups) {
            this.reportGroups = ReportGroupsCopier.copyFromBuilder(reportGroups);
        }

        @Override
        @Transient
        public final Builder reportGroups(Collection<ReportGroup> reportGroups) {
            this.reportGroups = ReportGroupsCopier.copy(reportGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reportGroups(ReportGroup ... reportGroups) {
            this.reportGroups(Arrays.asList(reportGroups));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reportGroups(Consumer<ReportGroup.Builder> ... reportGroups) {
            this.reportGroups(Stream.of(reportGroups).map(c -> (ReportGroup)((ReportGroup.Builder)ReportGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getReportGroupsNotFound() {
            if (this.reportGroupsNotFound instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reportGroupsNotFound;
        }

        public final void setReportGroupsNotFound(Collection<String> reportGroupsNotFound) {
            this.reportGroupsNotFound = ReportGroupArnsCopier.copy(reportGroupsNotFound);
        }

        @Override
        @Transient
        public final Builder reportGroupsNotFound(Collection<String> reportGroupsNotFound) {
            this.reportGroupsNotFound = ReportGroupArnsCopier.copy(reportGroupsNotFound);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reportGroupsNotFound(String ... reportGroupsNotFound) {
            this.reportGroupsNotFound(Arrays.asList(reportGroupsNotFound));
            return this;
        }

        @Override
        public BatchGetReportGroupsResponse build() {
            return new BatchGetReportGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeBuildResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetReportGroupsResponse> {
        public Builder reportGroups(Collection<ReportGroup> var1);

        public Builder reportGroups(ReportGroup ... var1);

        public Builder reportGroups(Consumer<ReportGroup.Builder> ... var1);

        public Builder reportGroupsNotFound(Collection<String> var1);

        public Builder reportGroupsNotFound(String ... var1);
    }
}

