/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codebuild.CodeBuildClient;
import software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectRequest;
import software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectResponse;

public class ListBuildsForProjectIterable
implements SdkIterable<ListBuildsForProjectResponse> {
    private final CodeBuildClient client;
    private final ListBuildsForProjectRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBuildsForProjectIterable(CodeBuildClient client, ListBuildsForProjectRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListBuildsForProjectResponseFetcher();
    }

    public Iterator<ListBuildsForProjectResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> ids() {
        Function<ListBuildsForProjectResponse, Iterator> getIterator = response -> {
            if (response != null && response.ids() != null) {
                return response.ids().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBuildsForProjectResponseFetcher
    implements SyncPageFetcher<ListBuildsForProjectResponse> {
        private ListBuildsForProjectResponseFetcher() {
        }

        public boolean hasNextPage(ListBuildsForProjectResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBuildsForProjectResponse nextPage(ListBuildsForProjectResponse previousPage) {
            if (previousPage == null) {
                return ListBuildsForProjectIterable.this.client.listBuildsForProject(ListBuildsForProjectIterable.this.firstRequest);
            }
            return ListBuildsForProjectIterable.this.client.listBuildsForProject((ListBuildsForProjectRequest)((Object)ListBuildsForProjectIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

