/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.BuildArtifacts;
import software.amazon.awssdk.services.codebuild.model.BuildArtifactsListCopier;
import software.amazon.awssdk.services.codebuild.model.BuildPhase;
import software.amazon.awssdk.services.codebuild.model.BuildPhasesCopier;
import software.amazon.awssdk.services.codebuild.model.BuildReportArnsCopier;
import software.amazon.awssdk.services.codebuild.model.DebugSession;
import software.amazon.awssdk.services.codebuild.model.ExportedEnvironmentVariable;
import software.amazon.awssdk.services.codebuild.model.ExportedEnvironmentVariablesCopier;
import software.amazon.awssdk.services.codebuild.model.LogsLocation;
import software.amazon.awssdk.services.codebuild.model.NetworkInterface;
import software.amazon.awssdk.services.codebuild.model.ProjectCache;
import software.amazon.awssdk.services.codebuild.model.ProjectEnvironment;
import software.amazon.awssdk.services.codebuild.model.ProjectFileSystemLocation;
import software.amazon.awssdk.services.codebuild.model.ProjectFileSystemLocationsCopier;
import software.amazon.awssdk.services.codebuild.model.ProjectSecondarySourceVersionsCopier;
import software.amazon.awssdk.services.codebuild.model.ProjectSource;
import software.amazon.awssdk.services.codebuild.model.ProjectSourceVersion;
import software.amazon.awssdk.services.codebuild.model.ProjectSourcesCopier;
import software.amazon.awssdk.services.codebuild.model.StatusType;
import software.amazon.awssdk.services.codebuild.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Build
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Build> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Build.getter(Build::id)).setter(Build.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Build.getter(Build::arn)).setter(Build.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Long> BUILD_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("buildNumber").getter(Build.getter(Build::buildNumber)).setter(Build.setter(Builder::buildNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildNumber").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(Build.getter(Build::startTime)).setter(Build.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(Build.getter(Build::endTime)).setter(Build.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> CURRENT_PHASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currentPhase").getter(Build.getter(Build::currentPhase)).setter(Build.setter(Builder::currentPhase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentPhase").build()}).build();
    private static final SdkField<String> BUILD_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("buildStatus").getter(Build.getter(Build::buildStatusAsString)).setter(Build.setter(Builder::buildStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildStatus").build()}).build();
    private static final SdkField<String> SOURCE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceVersion").getter(Build.getter(Build::sourceVersion)).setter(Build.setter(Builder::sourceVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceVersion").build()}).build();
    private static final SdkField<String> RESOLVED_SOURCE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resolvedSourceVersion").getter(Build.getter(Build::resolvedSourceVersion)).setter(Build.setter(Builder::resolvedSourceVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolvedSourceVersion").build()}).build();
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectName").getter(Build.getter(Build::projectName)).setter(Build.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()}).build();
    private static final SdkField<List<BuildPhase>> PHASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("phases").getter(Build.getter(Build::phases)).setter(Build.setter(Builder::phases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BuildPhase::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProjectSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("source").getter(Build.getter(Build::source)).setter(Build.setter(Builder::source)).constructor(ProjectSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<List<ProjectSource>> SECONDARY_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("secondarySources").getter(Build.getter(Build::secondarySources)).setter(Build.setter(Builder::secondarySources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondarySources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ProjectSourceVersion>> SECONDARY_SOURCE_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("secondarySourceVersions").getter(Build.getter(Build::secondarySourceVersions)).setter(Build.setter(Builder::secondarySourceVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondarySourceVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectSourceVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<BuildArtifacts> ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("artifacts").getter(Build.getter(Build::artifacts)).setter(Build.setter(Builder::artifacts)).constructor(BuildArtifacts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifacts").build()}).build();
    private static final SdkField<List<BuildArtifacts>> SECONDARY_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("secondaryArtifacts").getter(Build.getter(Build::secondaryArtifacts)).setter(Build.setter(Builder::secondaryArtifacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondaryArtifacts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BuildArtifacts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProjectCache> CACHE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cache").getter(Build.getter(Build::cache)).setter(Build.setter(Builder::cache)).constructor(ProjectCache::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cache").build()}).build();
    private static final SdkField<ProjectEnvironment> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("environment").getter(Build.getter(Build::environment)).setter(Build.setter(Builder::environment)).constructor(ProjectEnvironment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environment").build()}).build();
    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceRole").getter(Build.getter(Build::serviceRole)).setter(Build.setter(Builder::serviceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRole").build()}).build();
    private static final SdkField<LogsLocation> LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logs").getter(Build.getter(Build::logs)).setter(Build.setter(Builder::logs)).constructor(LogsLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logs").build()}).build();
    private static final SdkField<Integer> TIMEOUT_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("timeoutInMinutes").getter(Build.getter(Build::timeoutInMinutes)).setter(Build.setter(Builder::timeoutInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInMinutes").build()}).build();
    private static final SdkField<Integer> QUEUED_TIMEOUT_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("queuedTimeoutInMinutes").getter(Build.getter(Build::queuedTimeoutInMinutes)).setter(Build.setter(Builder::queuedTimeoutInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queuedTimeoutInMinutes").build()}).build();
    private static final SdkField<Boolean> BUILD_COMPLETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("buildComplete").getter(Build.getter(Build::buildComplete)).setter(Build.setter(Builder::buildComplete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildComplete").build()}).build();
    private static final SdkField<String> INITIATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("initiator").getter(Build.getter(Build::initiator)).setter(Build.setter(Builder::initiator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initiator").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpcConfig").getter(Build.getter(Build::vpcConfig)).setter(Build.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()}).build();
    private static final SdkField<NetworkInterface> NETWORK_INTERFACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkInterface").getter(Build.getter(Build::networkInterface)).setter(Build.setter(Builder::networkInterface)).constructor(NetworkInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterface").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("encryptionKey").getter(Build.getter(Build::encryptionKey)).setter(Build.setter(Builder::encryptionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKey").build()}).build();
    private static final SdkField<List<ExportedEnvironmentVariable>> EXPORTED_ENVIRONMENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("exportedEnvironmentVariables").getter(Build.getter(Build::exportedEnvironmentVariables)).setter(Build.setter(Builder::exportedEnvironmentVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportedEnvironmentVariables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExportedEnvironmentVariable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REPORT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("reportArns").getter(Build.getter(Build::reportArns)).setter(Build.setter(Builder::reportArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ProjectFileSystemLocation>> FILE_SYSTEM_LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fileSystemLocations").getter(Build.getter(Build::fileSystemLocations)).setter(Build.setter(Builder::fileSystemLocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSystemLocations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectFileSystemLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DebugSession> DEBUG_SESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("debugSession").getter(Build.getter(Build::debugSession)).setter(Build.setter(Builder::debugSession)).constructor(DebugSession::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("debugSession").build()}).build();
    private static final SdkField<String> BUILD_BATCH_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("buildBatchArn").getter(Build.getter(Build::buildBatchArn)).setter(Build.setter(Builder::buildBatchArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildBatchArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, BUILD_NUMBER_FIELD, START_TIME_FIELD, END_TIME_FIELD, CURRENT_PHASE_FIELD, BUILD_STATUS_FIELD, SOURCE_VERSION_FIELD, RESOLVED_SOURCE_VERSION_FIELD, PROJECT_NAME_FIELD, PHASES_FIELD, SOURCE_FIELD, SECONDARY_SOURCES_FIELD, SECONDARY_SOURCE_VERSIONS_FIELD, ARTIFACTS_FIELD, SECONDARY_ARTIFACTS_FIELD, CACHE_FIELD, ENVIRONMENT_FIELD, SERVICE_ROLE_FIELD, LOGS_FIELD, TIMEOUT_IN_MINUTES_FIELD, QUEUED_TIMEOUT_IN_MINUTES_FIELD, BUILD_COMPLETE_FIELD, INITIATOR_FIELD, VPC_CONFIG_FIELD, NETWORK_INTERFACE_FIELD, ENCRYPTION_KEY_FIELD, EXPORTED_ENVIRONMENT_VARIABLES_FIELD, REPORT_ARNS_FIELD, FILE_SYSTEM_LOCATIONS_FIELD, DEBUG_SESSION_FIELD, BUILD_BATCH_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final Long buildNumber;
    private final Instant startTime;
    private final Instant endTime;
    private final String currentPhase;
    private final String buildStatus;
    private final String sourceVersion;
    private final String resolvedSourceVersion;
    private final String projectName;
    private final List<BuildPhase> phases;
    private final ProjectSource source;
    private final List<ProjectSource> secondarySources;
    private final List<ProjectSourceVersion> secondarySourceVersions;
    private final BuildArtifacts artifacts;
    private final List<BuildArtifacts> secondaryArtifacts;
    private final ProjectCache cache;
    private final ProjectEnvironment environment;
    private final String serviceRole;
    private final LogsLocation logs;
    private final Integer timeoutInMinutes;
    private final Integer queuedTimeoutInMinutes;
    private final Boolean buildComplete;
    private final String initiator;
    private final VpcConfig vpcConfig;
    private final NetworkInterface networkInterface;
    private final String encryptionKey;
    private final List<ExportedEnvironmentVariable> exportedEnvironmentVariables;
    private final List<String> reportArns;
    private final List<ProjectFileSystemLocation> fileSystemLocations;
    private final DebugSession debugSession;
    private final String buildBatchArn;

    private Build(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.buildNumber = builder.buildNumber;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.currentPhase = builder.currentPhase;
        this.buildStatus = builder.buildStatus;
        this.sourceVersion = builder.sourceVersion;
        this.resolvedSourceVersion = builder.resolvedSourceVersion;
        this.projectName = builder.projectName;
        this.phases = builder.phases;
        this.source = builder.source;
        this.secondarySources = builder.secondarySources;
        this.secondarySourceVersions = builder.secondarySourceVersions;
        this.artifacts = builder.artifacts;
        this.secondaryArtifacts = builder.secondaryArtifacts;
        this.cache = builder.cache;
        this.environment = builder.environment;
        this.serviceRole = builder.serviceRole;
        this.logs = builder.logs;
        this.timeoutInMinutes = builder.timeoutInMinutes;
        this.queuedTimeoutInMinutes = builder.queuedTimeoutInMinutes;
        this.buildComplete = builder.buildComplete;
        this.initiator = builder.initiator;
        this.vpcConfig = builder.vpcConfig;
        this.networkInterface = builder.networkInterface;
        this.encryptionKey = builder.encryptionKey;
        this.exportedEnvironmentVariables = builder.exportedEnvironmentVariables;
        this.reportArns = builder.reportArns;
        this.fileSystemLocations = builder.fileSystemLocations;
        this.debugSession = builder.debugSession;
        this.buildBatchArn = builder.buildBatchArn;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final Long buildNumber() {
        return this.buildNumber;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String currentPhase() {
        return this.currentPhase;
    }

    public final StatusType buildStatus() {
        return StatusType.fromValue(this.buildStatus);
    }

    public final String buildStatusAsString() {
        return this.buildStatus;
    }

    public final String sourceVersion() {
        return this.sourceVersion;
    }

    public final String resolvedSourceVersion() {
        return this.resolvedSourceVersion;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final boolean hasPhases() {
        return this.phases != null && !(this.phases instanceof SdkAutoConstructList);
    }

    public final List<BuildPhase> phases() {
        return this.phases;
    }

    public final ProjectSource source() {
        return this.source;
    }

    public final boolean hasSecondarySources() {
        return this.secondarySources != null && !(this.secondarySources instanceof SdkAutoConstructList);
    }

    public final List<ProjectSource> secondarySources() {
        return this.secondarySources;
    }

    public final boolean hasSecondarySourceVersions() {
        return this.secondarySourceVersions != null && !(this.secondarySourceVersions instanceof SdkAutoConstructList);
    }

    public final List<ProjectSourceVersion> secondarySourceVersions() {
        return this.secondarySourceVersions;
    }

    public final BuildArtifacts artifacts() {
        return this.artifacts;
    }

    public final boolean hasSecondaryArtifacts() {
        return this.secondaryArtifacts != null && !(this.secondaryArtifacts instanceof SdkAutoConstructList);
    }

    public final List<BuildArtifacts> secondaryArtifacts() {
        return this.secondaryArtifacts;
    }

    public final ProjectCache cache() {
        return this.cache;
    }

    public final ProjectEnvironment environment() {
        return this.environment;
    }

    public final String serviceRole() {
        return this.serviceRole;
    }

    public final LogsLocation logs() {
        return this.logs;
    }

    public final Integer timeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public final Integer queuedTimeoutInMinutes() {
        return this.queuedTimeoutInMinutes;
    }

    public final Boolean buildComplete() {
        return this.buildComplete;
    }

    public final String initiator() {
        return this.initiator;
    }

    public final VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final NetworkInterface networkInterface() {
        return this.networkInterface;
    }

    public final String encryptionKey() {
        return this.encryptionKey;
    }

    public final boolean hasExportedEnvironmentVariables() {
        return this.exportedEnvironmentVariables != null && !(this.exportedEnvironmentVariables instanceof SdkAutoConstructList);
    }

    public final List<ExportedEnvironmentVariable> exportedEnvironmentVariables() {
        return this.exportedEnvironmentVariables;
    }

    public final boolean hasReportArns() {
        return this.reportArns != null && !(this.reportArns instanceof SdkAutoConstructList);
    }

    public final List<String> reportArns() {
        return this.reportArns;
    }

    public final boolean hasFileSystemLocations() {
        return this.fileSystemLocations != null && !(this.fileSystemLocations instanceof SdkAutoConstructList);
    }

    public final List<ProjectFileSystemLocation> fileSystemLocations() {
        return this.fileSystemLocations;
    }

    public final DebugSession debugSession() {
        return this.debugSession;
    }

    public final String buildBatchArn() {
        return this.buildBatchArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentPhase());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolvedSourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhases() ? this.phases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecondarySources() ? this.secondarySources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecondarySourceVersions() ? this.secondarySourceVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.artifacts());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecondaryArtifacts() ? this.secondaryArtifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cache());
        hashCode = 31 * hashCode + Objects.hashCode(this.environment());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.logs());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.queuedTimeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildComplete());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiator());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterface());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExportedEnvironmentVariables() ? this.exportedEnvironmentVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReportArns() ? this.reportArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFileSystemLocations() ? this.fileSystemLocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.debugSession());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildBatchArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Build)) {
            return false;
        }
        Build other = (Build)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.buildNumber(), other.buildNumber()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.currentPhase(), other.currentPhase()) && Objects.equals(this.buildStatusAsString(), other.buildStatusAsString()) && Objects.equals(this.sourceVersion(), other.sourceVersion()) && Objects.equals(this.resolvedSourceVersion(), other.resolvedSourceVersion()) && Objects.equals(this.projectName(), other.projectName()) && this.hasPhases() == other.hasPhases() && Objects.equals(this.phases(), other.phases()) && Objects.equals(this.source(), other.source()) && this.hasSecondarySources() == other.hasSecondarySources() && Objects.equals(this.secondarySources(), other.secondarySources()) && this.hasSecondarySourceVersions() == other.hasSecondarySourceVersions() && Objects.equals(this.secondarySourceVersions(), other.secondarySourceVersions()) && Objects.equals(this.artifacts(), other.artifacts()) && this.hasSecondaryArtifacts() == other.hasSecondaryArtifacts() && Objects.equals(this.secondaryArtifacts(), other.secondaryArtifacts()) && Objects.equals(this.cache(), other.cache()) && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.logs(), other.logs()) && Objects.equals(this.timeoutInMinutes(), other.timeoutInMinutes()) && Objects.equals(this.queuedTimeoutInMinutes(), other.queuedTimeoutInMinutes()) && Objects.equals(this.buildComplete(), other.buildComplete()) && Objects.equals(this.initiator(), other.initiator()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.networkInterface(), other.networkInterface()) && Objects.equals(this.encryptionKey(), other.encryptionKey()) && this.hasExportedEnvironmentVariables() == other.hasExportedEnvironmentVariables() && Objects.equals(this.exportedEnvironmentVariables(), other.exportedEnvironmentVariables()) && this.hasReportArns() == other.hasReportArns() && Objects.equals(this.reportArns(), other.reportArns()) && this.hasFileSystemLocations() == other.hasFileSystemLocations() && Objects.equals(this.fileSystemLocations(), other.fileSystemLocations()) && Objects.equals(this.debugSession(), other.debugSession()) && Objects.equals(this.buildBatchArn(), other.buildBatchArn());
    }

    public final String toString() {
        return ToString.builder((String)"Build").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("BuildNumber", (Object)this.buildNumber()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("CurrentPhase", (Object)this.currentPhase()).add("BuildStatus", (Object)this.buildStatusAsString()).add("SourceVersion", (Object)this.sourceVersion()).add("ResolvedSourceVersion", (Object)this.resolvedSourceVersion()).add("ProjectName", (Object)this.projectName()).add("Phases", this.hasPhases() ? this.phases() : null).add("Source", (Object)this.source()).add("SecondarySources", this.hasSecondarySources() ? this.secondarySources() : null).add("SecondarySourceVersions", this.hasSecondarySourceVersions() ? this.secondarySourceVersions() : null).add("Artifacts", (Object)this.artifacts()).add("SecondaryArtifacts", this.hasSecondaryArtifacts() ? this.secondaryArtifacts() : null).add("Cache", (Object)this.cache()).add("Environment", (Object)this.environment()).add("ServiceRole", (Object)this.serviceRole()).add("Logs", (Object)this.logs()).add("TimeoutInMinutes", (Object)this.timeoutInMinutes()).add("QueuedTimeoutInMinutes", (Object)this.queuedTimeoutInMinutes()).add("BuildComplete", (Object)this.buildComplete()).add("Initiator", (Object)this.initiator()).add("VpcConfig", (Object)this.vpcConfig()).add("NetworkInterface", (Object)this.networkInterface()).add("EncryptionKey", (Object)this.encryptionKey()).add("ExportedEnvironmentVariables", this.hasExportedEnvironmentVariables() ? this.exportedEnvironmentVariables() : null).add("ReportArns", this.hasReportArns() ? this.reportArns() : null).add("FileSystemLocations", this.hasFileSystemLocations() ? this.fileSystemLocations() : null).add("DebugSession", (Object)this.debugSession()).add("BuildBatchArn", (Object)this.buildBatchArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "buildNumber": {
                return Optional.ofNullable(clazz.cast(this.buildNumber()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "currentPhase": {
                return Optional.ofNullable(clazz.cast(this.currentPhase()));
            }
            case "buildStatus": {
                return Optional.ofNullable(clazz.cast(this.buildStatusAsString()));
            }
            case "sourceVersion": {
                return Optional.ofNullable(clazz.cast(this.sourceVersion()));
            }
            case "resolvedSourceVersion": {
                return Optional.ofNullable(clazz.cast(this.resolvedSourceVersion()));
            }
            case "projectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "phases": {
                return Optional.ofNullable(clazz.cast(this.phases()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "secondarySources": {
                return Optional.ofNullable(clazz.cast(this.secondarySources()));
            }
            case "secondarySourceVersions": {
                return Optional.ofNullable(clazz.cast(this.secondarySourceVersions()));
            }
            case "artifacts": {
                return Optional.ofNullable(clazz.cast(this.artifacts()));
            }
            case "secondaryArtifacts": {
                return Optional.ofNullable(clazz.cast(this.secondaryArtifacts()));
            }
            case "cache": {
                return Optional.ofNullable(clazz.cast(this.cache()));
            }
            case "environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "serviceRole": {
                return Optional.ofNullable(clazz.cast(this.serviceRole()));
            }
            case "logs": {
                return Optional.ofNullable(clazz.cast(this.logs()));
            }
            case "timeoutInMinutes": {
                return Optional.ofNullable(clazz.cast(this.timeoutInMinutes()));
            }
            case "queuedTimeoutInMinutes": {
                return Optional.ofNullable(clazz.cast(this.queuedTimeoutInMinutes()));
            }
            case "buildComplete": {
                return Optional.ofNullable(clazz.cast(this.buildComplete()));
            }
            case "initiator": {
                return Optional.ofNullable(clazz.cast(this.initiator()));
            }
            case "vpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "networkInterface": {
                return Optional.ofNullable(clazz.cast(this.networkInterface()));
            }
            case "encryptionKey": {
                return Optional.ofNullable(clazz.cast(this.encryptionKey()));
            }
            case "exportedEnvironmentVariables": {
                return Optional.ofNullable(clazz.cast(this.exportedEnvironmentVariables()));
            }
            case "reportArns": {
                return Optional.ofNullable(clazz.cast(this.reportArns()));
            }
            case "fileSystemLocations": {
                return Optional.ofNullable(clazz.cast(this.fileSystemLocations()));
            }
            case "debugSession": {
                return Optional.ofNullable(clazz.cast(this.debugSession()));
            }
            case "buildBatchArn": {
                return Optional.ofNullable(clazz.cast(this.buildBatchArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Build, T> g) {
        return obj -> g.apply((Build)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private Long buildNumber;
        private Instant startTime;
        private Instant endTime;
        private String currentPhase;
        private String buildStatus;
        private String sourceVersion;
        private String resolvedSourceVersion;
        private String projectName;
        private List<BuildPhase> phases = DefaultSdkAutoConstructList.getInstance();
        private ProjectSource source;
        private List<ProjectSource> secondarySources = DefaultSdkAutoConstructList.getInstance();
        private List<ProjectSourceVersion> secondarySourceVersions = DefaultSdkAutoConstructList.getInstance();
        private BuildArtifacts artifacts;
        private List<BuildArtifacts> secondaryArtifacts = DefaultSdkAutoConstructList.getInstance();
        private ProjectCache cache;
        private ProjectEnvironment environment;
        private String serviceRole;
        private LogsLocation logs;
        private Integer timeoutInMinutes;
        private Integer queuedTimeoutInMinutes;
        private Boolean buildComplete;
        private String initiator;
        private VpcConfig vpcConfig;
        private NetworkInterface networkInterface;
        private String encryptionKey;
        private List<ExportedEnvironmentVariable> exportedEnvironmentVariables = DefaultSdkAutoConstructList.getInstance();
        private List<String> reportArns = DefaultSdkAutoConstructList.getInstance();
        private List<ProjectFileSystemLocation> fileSystemLocations = DefaultSdkAutoConstructList.getInstance();
        private DebugSession debugSession;
        private String buildBatchArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Build model) {
            this.id(model.id);
            this.arn(model.arn);
            this.buildNumber(model.buildNumber);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.currentPhase(model.currentPhase);
            this.buildStatus(model.buildStatus);
            this.sourceVersion(model.sourceVersion);
            this.resolvedSourceVersion(model.resolvedSourceVersion);
            this.projectName(model.projectName);
            this.phases(model.phases);
            this.source(model.source);
            this.secondarySources(model.secondarySources);
            this.secondarySourceVersions(model.secondarySourceVersions);
            this.artifacts(model.artifacts);
            this.secondaryArtifacts(model.secondaryArtifacts);
            this.cache(model.cache);
            this.environment(model.environment);
            this.serviceRole(model.serviceRole);
            this.logs(model.logs);
            this.timeoutInMinutes(model.timeoutInMinutes);
            this.queuedTimeoutInMinutes(model.queuedTimeoutInMinutes);
            this.buildComplete(model.buildComplete);
            this.initiator(model.initiator);
            this.vpcConfig(model.vpcConfig);
            this.networkInterface(model.networkInterface);
            this.encryptionKey(model.encryptionKey);
            this.exportedEnvironmentVariables(model.exportedEnvironmentVariables);
            this.reportArns(model.reportArns);
            this.fileSystemLocations(model.fileSystemLocations);
            this.debugSession(model.debugSession);
            this.buildBatchArn(model.buildBatchArn);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Long getBuildNumber() {
            return this.buildNumber;
        }

        public final void setBuildNumber(Long buildNumber) {
            this.buildNumber = buildNumber;
        }

        @Override
        public final Builder buildNumber(Long buildNumber) {
            this.buildNumber = buildNumber;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getCurrentPhase() {
            return this.currentPhase;
        }

        public final void setCurrentPhase(String currentPhase) {
            this.currentPhase = currentPhase;
        }

        @Override
        public final Builder currentPhase(String currentPhase) {
            this.currentPhase = currentPhase;
            return this;
        }

        public final String getBuildStatus() {
            return this.buildStatus;
        }

        public final void setBuildStatus(String buildStatus) {
            this.buildStatus = buildStatus;
        }

        @Override
        public final Builder buildStatus(String buildStatus) {
            this.buildStatus = buildStatus;
            return this;
        }

        @Override
        public final Builder buildStatus(StatusType buildStatus) {
            this.buildStatus(buildStatus == null ? null : buildStatus.toString());
            return this;
        }

        public final String getSourceVersion() {
            return this.sourceVersion;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public final String getResolvedSourceVersion() {
            return this.resolvedSourceVersion;
        }

        public final void setResolvedSourceVersion(String resolvedSourceVersion) {
            this.resolvedSourceVersion = resolvedSourceVersion;
        }

        @Override
        public final Builder resolvedSourceVersion(String resolvedSourceVersion) {
            this.resolvedSourceVersion = resolvedSourceVersion;
            return this;
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final List<BuildPhase.Builder> getPhases() {
            List<BuildPhase.Builder> result = BuildPhasesCopier.copyToBuilder(this.phases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhases(Collection<BuildPhase.BuilderImpl> phases) {
            this.phases = BuildPhasesCopier.copyFromBuilder(phases);
        }

        @Override
        public final Builder phases(Collection<BuildPhase> phases) {
            this.phases = BuildPhasesCopier.copy(phases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phases(BuildPhase ... phases) {
            this.phases(Arrays.asList(phases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phases(Consumer<BuildPhase.Builder> ... phases) {
            this.phases(Stream.of(phases).map(c -> (BuildPhase)((BuildPhase.Builder)BuildPhase.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ProjectSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(ProjectSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(ProjectSource source) {
            this.source = source;
            return this;
        }

        public final List<ProjectSource.Builder> getSecondarySources() {
            List<ProjectSource.Builder> result = ProjectSourcesCopier.copyToBuilder(this.secondarySources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondarySources(Collection<ProjectSource.BuilderImpl> secondarySources) {
            this.secondarySources = ProjectSourcesCopier.copyFromBuilder(secondarySources);
        }

        @Override
        public final Builder secondarySources(Collection<ProjectSource> secondarySources) {
            this.secondarySources = ProjectSourcesCopier.copy(secondarySources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySources(ProjectSource ... secondarySources) {
            this.secondarySources(Arrays.asList(secondarySources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySources(Consumer<ProjectSource.Builder> ... secondarySources) {
            this.secondarySources(Stream.of(secondarySources).map(c -> (ProjectSource)((ProjectSource.Builder)ProjectSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ProjectSourceVersion.Builder> getSecondarySourceVersions() {
            List<ProjectSourceVersion.Builder> result = ProjectSecondarySourceVersionsCopier.copyToBuilder(this.secondarySourceVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondarySourceVersions(Collection<ProjectSourceVersion.BuilderImpl> secondarySourceVersions) {
            this.secondarySourceVersions = ProjectSecondarySourceVersionsCopier.copyFromBuilder(secondarySourceVersions);
        }

        @Override
        public final Builder secondarySourceVersions(Collection<ProjectSourceVersion> secondarySourceVersions) {
            this.secondarySourceVersions = ProjectSecondarySourceVersionsCopier.copy(secondarySourceVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourceVersions(ProjectSourceVersion ... secondarySourceVersions) {
            this.secondarySourceVersions(Arrays.asList(secondarySourceVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourceVersions(Consumer<ProjectSourceVersion.Builder> ... secondarySourceVersions) {
            this.secondarySourceVersions(Stream.of(secondarySourceVersions).map(c -> (ProjectSourceVersion)((ProjectSourceVersion.Builder)ProjectSourceVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final BuildArtifacts.Builder getArtifacts() {
            return this.artifacts != null ? this.artifacts.toBuilder() : null;
        }

        public final void setArtifacts(BuildArtifacts.BuilderImpl artifacts) {
            this.artifacts = artifacts != null ? artifacts.build() : null;
        }

        @Override
        public final Builder artifacts(BuildArtifacts artifacts) {
            this.artifacts = artifacts;
            return this;
        }

        public final List<BuildArtifacts.Builder> getSecondaryArtifacts() {
            List<BuildArtifacts.Builder> result = BuildArtifactsListCopier.copyToBuilder(this.secondaryArtifacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondaryArtifacts(Collection<BuildArtifacts.BuilderImpl> secondaryArtifacts) {
            this.secondaryArtifacts = BuildArtifactsListCopier.copyFromBuilder(secondaryArtifacts);
        }

        @Override
        public final Builder secondaryArtifacts(Collection<BuildArtifacts> secondaryArtifacts) {
            this.secondaryArtifacts = BuildArtifactsListCopier.copy(secondaryArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryArtifacts(BuildArtifacts ... secondaryArtifacts) {
            this.secondaryArtifacts(Arrays.asList(secondaryArtifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryArtifacts(Consumer<BuildArtifacts.Builder> ... secondaryArtifacts) {
            this.secondaryArtifacts(Stream.of(secondaryArtifacts).map(c -> (BuildArtifacts)((BuildArtifacts.Builder)BuildArtifacts.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ProjectCache.Builder getCache() {
            return this.cache != null ? this.cache.toBuilder() : null;
        }

        public final void setCache(ProjectCache.BuilderImpl cache) {
            this.cache = cache != null ? cache.build() : null;
        }

        @Override
        public final Builder cache(ProjectCache cache) {
            this.cache = cache;
            return this;
        }

        public final ProjectEnvironment.Builder getEnvironment() {
            return this.environment != null ? this.environment.toBuilder() : null;
        }

        public final void setEnvironment(ProjectEnvironment.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        @Override
        public final Builder environment(ProjectEnvironment environment) {
            this.environment = environment;
            return this;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final LogsLocation.Builder getLogs() {
            return this.logs != null ? this.logs.toBuilder() : null;
        }

        public final void setLogs(LogsLocation.BuilderImpl logs) {
            this.logs = logs != null ? logs.build() : null;
        }

        @Override
        public final Builder logs(LogsLocation logs) {
            this.logs = logs;
            return this;
        }

        public final Integer getTimeoutInMinutes() {
            return this.timeoutInMinutes;
        }

        public final void setTimeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
        }

        @Override
        public final Builder timeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
            return this;
        }

        public final Integer getQueuedTimeoutInMinutes() {
            return this.queuedTimeoutInMinutes;
        }

        public final void setQueuedTimeoutInMinutes(Integer queuedTimeoutInMinutes) {
            this.queuedTimeoutInMinutes = queuedTimeoutInMinutes;
        }

        @Override
        public final Builder queuedTimeoutInMinutes(Integer queuedTimeoutInMinutes) {
            this.queuedTimeoutInMinutes = queuedTimeoutInMinutes;
            return this;
        }

        public final Boolean getBuildComplete() {
            return this.buildComplete;
        }

        public final void setBuildComplete(Boolean buildComplete) {
            this.buildComplete = buildComplete;
        }

        @Override
        public final Builder buildComplete(Boolean buildComplete) {
            this.buildComplete = buildComplete;
            return this;
        }

        public final String getInitiator() {
            return this.initiator;
        }

        public final void setInitiator(String initiator) {
            this.initiator = initiator;
        }

        @Override
        public final Builder initiator(String initiator) {
            this.initiator = initiator;
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final NetworkInterface.Builder getNetworkInterface() {
            return this.networkInterface != null ? this.networkInterface.toBuilder() : null;
        }

        public final void setNetworkInterface(NetworkInterface.BuilderImpl networkInterface) {
            this.networkInterface = networkInterface != null ? networkInterface.build() : null;
        }

        @Override
        public final Builder networkInterface(NetworkInterface networkInterface) {
            this.networkInterface = networkInterface;
            return this;
        }

        public final String getEncryptionKey() {
            return this.encryptionKey;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        @Override
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final List<ExportedEnvironmentVariable.Builder> getExportedEnvironmentVariables() {
            List<ExportedEnvironmentVariable.Builder> result = ExportedEnvironmentVariablesCopier.copyToBuilder(this.exportedEnvironmentVariables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExportedEnvironmentVariables(Collection<ExportedEnvironmentVariable.BuilderImpl> exportedEnvironmentVariables) {
            this.exportedEnvironmentVariables = ExportedEnvironmentVariablesCopier.copyFromBuilder(exportedEnvironmentVariables);
        }

        @Override
        public final Builder exportedEnvironmentVariables(Collection<ExportedEnvironmentVariable> exportedEnvironmentVariables) {
            this.exportedEnvironmentVariables = ExportedEnvironmentVariablesCopier.copy(exportedEnvironmentVariables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportedEnvironmentVariables(ExportedEnvironmentVariable ... exportedEnvironmentVariables) {
            this.exportedEnvironmentVariables(Arrays.asList(exportedEnvironmentVariables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportedEnvironmentVariables(Consumer<ExportedEnvironmentVariable.Builder> ... exportedEnvironmentVariables) {
            this.exportedEnvironmentVariables(Stream.of(exportedEnvironmentVariables).map(c -> (ExportedEnvironmentVariable)((ExportedEnvironmentVariable.Builder)ExportedEnvironmentVariable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getReportArns() {
            if (this.reportArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reportArns;
        }

        public final void setReportArns(Collection<String> reportArns) {
            this.reportArns = BuildReportArnsCopier.copy(reportArns);
        }

        @Override
        public final Builder reportArns(Collection<String> reportArns) {
            this.reportArns = BuildReportArnsCopier.copy(reportArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportArns(String ... reportArns) {
            this.reportArns(Arrays.asList(reportArns));
            return this;
        }

        public final List<ProjectFileSystemLocation.Builder> getFileSystemLocations() {
            List<ProjectFileSystemLocation.Builder> result = ProjectFileSystemLocationsCopier.copyToBuilder(this.fileSystemLocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileSystemLocations(Collection<ProjectFileSystemLocation.BuilderImpl> fileSystemLocations) {
            this.fileSystemLocations = ProjectFileSystemLocationsCopier.copyFromBuilder(fileSystemLocations);
        }

        @Override
        public final Builder fileSystemLocations(Collection<ProjectFileSystemLocation> fileSystemLocations) {
            this.fileSystemLocations = ProjectFileSystemLocationsCopier.copy(fileSystemLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemLocations(ProjectFileSystemLocation ... fileSystemLocations) {
            this.fileSystemLocations(Arrays.asList(fileSystemLocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemLocations(Consumer<ProjectFileSystemLocation.Builder> ... fileSystemLocations) {
            this.fileSystemLocations(Stream.of(fileSystemLocations).map(c -> (ProjectFileSystemLocation)((ProjectFileSystemLocation.Builder)ProjectFileSystemLocation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DebugSession.Builder getDebugSession() {
            return this.debugSession != null ? this.debugSession.toBuilder() : null;
        }

        public final void setDebugSession(DebugSession.BuilderImpl debugSession) {
            this.debugSession = debugSession != null ? debugSession.build() : null;
        }

        @Override
        public final Builder debugSession(DebugSession debugSession) {
            this.debugSession = debugSession;
            return this;
        }

        public final String getBuildBatchArn() {
            return this.buildBatchArn;
        }

        public final void setBuildBatchArn(String buildBatchArn) {
            this.buildBatchArn = buildBatchArn;
        }

        @Override
        public final Builder buildBatchArn(String buildBatchArn) {
            this.buildBatchArn = buildBatchArn;
            return this;
        }

        public Build build() {
            return new Build(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Build> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder buildNumber(Long var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder currentPhase(String var1);

        public Builder buildStatus(String var1);

        public Builder buildStatus(StatusType var1);

        public Builder sourceVersion(String var1);

        public Builder resolvedSourceVersion(String var1);

        public Builder projectName(String var1);

        public Builder phases(Collection<BuildPhase> var1);

        public Builder phases(BuildPhase ... var1);

        public Builder phases(Consumer<BuildPhase.Builder> ... var1);

        public Builder source(ProjectSource var1);

        default public Builder source(Consumer<ProjectSource.Builder> source) {
            return this.source((ProjectSource)((ProjectSource.Builder)ProjectSource.builder().applyMutation(source)).build());
        }

        public Builder secondarySources(Collection<ProjectSource> var1);

        public Builder secondarySources(ProjectSource ... var1);

        public Builder secondarySources(Consumer<ProjectSource.Builder> ... var1);

        public Builder secondarySourceVersions(Collection<ProjectSourceVersion> var1);

        public Builder secondarySourceVersions(ProjectSourceVersion ... var1);

        public Builder secondarySourceVersions(Consumer<ProjectSourceVersion.Builder> ... var1);

        public Builder artifacts(BuildArtifacts var1);

        default public Builder artifacts(Consumer<BuildArtifacts.Builder> artifacts) {
            return this.artifacts((BuildArtifacts)((BuildArtifacts.Builder)BuildArtifacts.builder().applyMutation(artifacts)).build());
        }

        public Builder secondaryArtifacts(Collection<BuildArtifacts> var1);

        public Builder secondaryArtifacts(BuildArtifacts ... var1);

        public Builder secondaryArtifacts(Consumer<BuildArtifacts.Builder> ... var1);

        public Builder cache(ProjectCache var1);

        default public Builder cache(Consumer<ProjectCache.Builder> cache) {
            return this.cache((ProjectCache)((ProjectCache.Builder)ProjectCache.builder().applyMutation(cache)).build());
        }

        public Builder environment(ProjectEnvironment var1);

        default public Builder environment(Consumer<ProjectEnvironment.Builder> environment) {
            return this.environment((ProjectEnvironment)((ProjectEnvironment.Builder)ProjectEnvironment.builder().applyMutation(environment)).build());
        }

        public Builder serviceRole(String var1);

        public Builder logs(LogsLocation var1);

        default public Builder logs(Consumer<LogsLocation.Builder> logs) {
            return this.logs((LogsLocation)((LogsLocation.Builder)LogsLocation.builder().applyMutation(logs)).build());
        }

        public Builder timeoutInMinutes(Integer var1);

        public Builder queuedTimeoutInMinutes(Integer var1);

        public Builder buildComplete(Boolean var1);

        public Builder initiator(String var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder networkInterface(NetworkInterface var1);

        default public Builder networkInterface(Consumer<NetworkInterface.Builder> networkInterface) {
            return this.networkInterface((NetworkInterface)((NetworkInterface.Builder)NetworkInterface.builder().applyMutation(networkInterface)).build());
        }

        public Builder encryptionKey(String var1);

        public Builder exportedEnvironmentVariables(Collection<ExportedEnvironmentVariable> var1);

        public Builder exportedEnvironmentVariables(ExportedEnvironmentVariable ... var1);

        public Builder exportedEnvironmentVariables(Consumer<ExportedEnvironmentVariable.Builder> ... var1);

        public Builder reportArns(Collection<String> var1);

        public Builder reportArns(String ... var1);

        public Builder fileSystemLocations(Collection<ProjectFileSystemLocation> var1);

        public Builder fileSystemLocations(ProjectFileSystemLocation ... var1);

        public Builder fileSystemLocations(Consumer<ProjectFileSystemLocation.Builder> ... var1);

        public Builder debugSession(DebugSession var1);

        default public Builder debugSession(Consumer<DebugSession.Builder> debugSession) {
            return this.debugSession((DebugSession)((DebugSession.Builder)DebugSession.builder().applyMutation(debugSession)).build());
        }

        public Builder buildBatchArn(String var1);
    }
}

