/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.LogsConfig;
import software.amazon.awssdk.services.codebuild.model.ProjectArtifacts;
import software.amazon.awssdk.services.codebuild.model.ProjectArtifactsListCopier;
import software.amazon.awssdk.services.codebuild.model.ProjectBadge;
import software.amazon.awssdk.services.codebuild.model.ProjectBuildBatchConfig;
import software.amazon.awssdk.services.codebuild.model.ProjectCache;
import software.amazon.awssdk.services.codebuild.model.ProjectEnvironment;
import software.amazon.awssdk.services.codebuild.model.ProjectFileSystemLocation;
import software.amazon.awssdk.services.codebuild.model.ProjectFileSystemLocationsCopier;
import software.amazon.awssdk.services.codebuild.model.ProjectSecondarySourceVersionsCopier;
import software.amazon.awssdk.services.codebuild.model.ProjectSource;
import software.amazon.awssdk.services.codebuild.model.ProjectSourceVersion;
import software.amazon.awssdk.services.codebuild.model.ProjectSourcesCopier;
import software.amazon.awssdk.services.codebuild.model.ProjectVisibilityType;
import software.amazon.awssdk.services.codebuild.model.Tag;
import software.amazon.awssdk.services.codebuild.model.TagListCopier;
import software.amazon.awssdk.services.codebuild.model.VpcConfig;
import software.amazon.awssdk.services.codebuild.model.Webhook;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Project
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Project> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Project.getter(Project::name)).setter(Project.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Project.getter(Project::arn)).setter(Project.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Project.getter(Project::description)).setter(Project.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<ProjectSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("source").getter(Project.getter(Project::source)).setter(Project.setter(Builder::source)).constructor(ProjectSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<List<ProjectSource>> SECONDARY_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("secondarySources").getter(Project.getter(Project::secondarySources)).setter(Project.setter(Builder::secondarySources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondarySources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceVersion").getter(Project.getter(Project::sourceVersion)).setter(Project.setter(Builder::sourceVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceVersion").build()}).build();
    private static final SdkField<List<ProjectSourceVersion>> SECONDARY_SOURCE_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("secondarySourceVersions").getter(Project.getter(Project::secondarySourceVersions)).setter(Project.setter(Builder::secondarySourceVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondarySourceVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectSourceVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProjectArtifacts> ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("artifacts").getter(Project.getter(Project::artifacts)).setter(Project.setter(Builder::artifacts)).constructor(ProjectArtifacts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifacts").build()}).build();
    private static final SdkField<List<ProjectArtifacts>> SECONDARY_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("secondaryArtifacts").getter(Project.getter(Project::secondaryArtifacts)).setter(Project.setter(Builder::secondaryArtifacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondaryArtifacts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectArtifacts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProjectCache> CACHE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cache").getter(Project.getter(Project::cache)).setter(Project.setter(Builder::cache)).constructor(ProjectCache::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cache").build()}).build();
    private static final SdkField<ProjectEnvironment> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("environment").getter(Project.getter(Project::environment)).setter(Project.setter(Builder::environment)).constructor(ProjectEnvironment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environment").build()}).build();
    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceRole").getter(Project.getter(Project::serviceRole)).setter(Project.setter(Builder::serviceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRole").build()}).build();
    private static final SdkField<Integer> TIMEOUT_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("timeoutInMinutes").getter(Project.getter(Project::timeoutInMinutes)).setter(Project.setter(Builder::timeoutInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInMinutes").build()}).build();
    private static final SdkField<Integer> QUEUED_TIMEOUT_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("queuedTimeoutInMinutes").getter(Project.getter(Project::queuedTimeoutInMinutes)).setter(Project.setter(Builder::queuedTimeoutInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queuedTimeoutInMinutes").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("encryptionKey").getter(Project.getter(Project::encryptionKey)).setter(Project.setter(Builder::encryptionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKey").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(Project.getter(Project::tags)).setter(Project.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("created").getter(Project.getter(Project::created)).setter(Project.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModified").getter(Project.getter(Project::lastModified)).setter(Project.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModified").build()}).build();
    private static final SdkField<Webhook> WEBHOOK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("webhook").getter(Project.getter(Project::webhook)).setter(Project.setter(Builder::webhook)).constructor(Webhook::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webhook").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpcConfig").getter(Project.getter(Project::vpcConfig)).setter(Project.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()}).build();
    private static final SdkField<ProjectBadge> BADGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("badge").getter(Project.getter(Project::badge)).setter(Project.setter(Builder::badge)).constructor(ProjectBadge::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("badge").build()}).build();
    private static final SdkField<LogsConfig> LOGS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logsConfig").getter(Project.getter(Project::logsConfig)).setter(Project.setter(Builder::logsConfig)).constructor(LogsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logsConfig").build()}).build();
    private static final SdkField<List<ProjectFileSystemLocation>> FILE_SYSTEM_LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fileSystemLocations").getter(Project.getter(Project::fileSystemLocations)).setter(Project.setter(Builder::fileSystemLocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSystemLocations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectFileSystemLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProjectBuildBatchConfig> BUILD_BATCH_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("buildBatchConfig").getter(Project.getter(Project::buildBatchConfig)).setter(Project.setter(Builder::buildBatchConfig)).constructor(ProjectBuildBatchConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildBatchConfig").build()}).build();
    private static final SdkField<Integer> CONCURRENT_BUILD_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("concurrentBuildLimit").getter(Project.getter(Project::concurrentBuildLimit)).setter(Project.setter(Builder::concurrentBuildLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("concurrentBuildLimit").build()}).build();
    private static final SdkField<String> PROJECT_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectVisibility").getter(Project.getter(Project::projectVisibilityAsString)).setter(Project.setter(Builder::projectVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectVisibility").build()}).build();
    private static final SdkField<String> PUBLIC_PROJECT_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("publicProjectAlias").getter(Project.getter(Project::publicProjectAlias)).setter(Project.setter(Builder::publicProjectAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicProjectAlias").build()}).build();
    private static final SdkField<String> RESOURCE_ACCESS_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceAccessRole").getter(Project.getter(Project::resourceAccessRole)).setter(Project.setter(Builder::resourceAccessRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceAccessRole").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, DESCRIPTION_FIELD, SOURCE_FIELD, SECONDARY_SOURCES_FIELD, SOURCE_VERSION_FIELD, SECONDARY_SOURCE_VERSIONS_FIELD, ARTIFACTS_FIELD, SECONDARY_ARTIFACTS_FIELD, CACHE_FIELD, ENVIRONMENT_FIELD, SERVICE_ROLE_FIELD, TIMEOUT_IN_MINUTES_FIELD, QUEUED_TIMEOUT_IN_MINUTES_FIELD, ENCRYPTION_KEY_FIELD, TAGS_FIELD, CREATED_FIELD, LAST_MODIFIED_FIELD, WEBHOOK_FIELD, VPC_CONFIG_FIELD, BADGE_FIELD, LOGS_CONFIG_FIELD, FILE_SYSTEM_LOCATIONS_FIELD, BUILD_BATCH_CONFIG_FIELD, CONCURRENT_BUILD_LIMIT_FIELD, PROJECT_VISIBILITY_FIELD, PUBLIC_PROJECT_ALIAS_FIELD, RESOURCE_ACCESS_ROLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String description;
    private final ProjectSource source;
    private final List<ProjectSource> secondarySources;
    private final String sourceVersion;
    private final List<ProjectSourceVersion> secondarySourceVersions;
    private final ProjectArtifacts artifacts;
    private final List<ProjectArtifacts> secondaryArtifacts;
    private final ProjectCache cache;
    private final ProjectEnvironment environment;
    private final String serviceRole;
    private final Integer timeoutInMinutes;
    private final Integer queuedTimeoutInMinutes;
    private final String encryptionKey;
    private final List<Tag> tags;
    private final Instant created;
    private final Instant lastModified;
    private final Webhook webhook;
    private final VpcConfig vpcConfig;
    private final ProjectBadge badge;
    private final LogsConfig logsConfig;
    private final List<ProjectFileSystemLocation> fileSystemLocations;
    private final ProjectBuildBatchConfig buildBatchConfig;
    private final Integer concurrentBuildLimit;
    private final String projectVisibility;
    private final String publicProjectAlias;
    private final String resourceAccessRole;

    private Project(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.description = builder.description;
        this.source = builder.source;
        this.secondarySources = builder.secondarySources;
        this.sourceVersion = builder.sourceVersion;
        this.secondarySourceVersions = builder.secondarySourceVersions;
        this.artifacts = builder.artifacts;
        this.secondaryArtifacts = builder.secondaryArtifacts;
        this.cache = builder.cache;
        this.environment = builder.environment;
        this.serviceRole = builder.serviceRole;
        this.timeoutInMinutes = builder.timeoutInMinutes;
        this.queuedTimeoutInMinutes = builder.queuedTimeoutInMinutes;
        this.encryptionKey = builder.encryptionKey;
        this.tags = builder.tags;
        this.created = builder.created;
        this.lastModified = builder.lastModified;
        this.webhook = builder.webhook;
        this.vpcConfig = builder.vpcConfig;
        this.badge = builder.badge;
        this.logsConfig = builder.logsConfig;
        this.fileSystemLocations = builder.fileSystemLocations;
        this.buildBatchConfig = builder.buildBatchConfig;
        this.concurrentBuildLimit = builder.concurrentBuildLimit;
        this.projectVisibility = builder.projectVisibility;
        this.publicProjectAlias = builder.publicProjectAlias;
        this.resourceAccessRole = builder.resourceAccessRole;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String description() {
        return this.description;
    }

    public final ProjectSource source() {
        return this.source;
    }

    public final boolean hasSecondarySources() {
        return this.secondarySources != null && !(this.secondarySources instanceof SdkAutoConstructList);
    }

    public final List<ProjectSource> secondarySources() {
        return this.secondarySources;
    }

    public final String sourceVersion() {
        return this.sourceVersion;
    }

    public final boolean hasSecondarySourceVersions() {
        return this.secondarySourceVersions != null && !(this.secondarySourceVersions instanceof SdkAutoConstructList);
    }

    public final List<ProjectSourceVersion> secondarySourceVersions() {
        return this.secondarySourceVersions;
    }

    public final ProjectArtifacts artifacts() {
        return this.artifacts;
    }

    public final boolean hasSecondaryArtifacts() {
        return this.secondaryArtifacts != null && !(this.secondaryArtifacts instanceof SdkAutoConstructList);
    }

    public final List<ProjectArtifacts> secondaryArtifacts() {
        return this.secondaryArtifacts;
    }

    public final ProjectCache cache() {
        return this.cache;
    }

    public final ProjectEnvironment environment() {
        return this.environment;
    }

    public final String serviceRole() {
        return this.serviceRole;
    }

    public final Integer timeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public final Integer queuedTimeoutInMinutes() {
        return this.queuedTimeoutInMinutes;
    }

    public final String encryptionKey() {
        return this.encryptionKey;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Instant created() {
        return this.created;
    }

    public final Instant lastModified() {
        return this.lastModified;
    }

    public final Webhook webhook() {
        return this.webhook;
    }

    public final VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final ProjectBadge badge() {
        return this.badge;
    }

    public final LogsConfig logsConfig() {
        return this.logsConfig;
    }

    public final boolean hasFileSystemLocations() {
        return this.fileSystemLocations != null && !(this.fileSystemLocations instanceof SdkAutoConstructList);
    }

    public final List<ProjectFileSystemLocation> fileSystemLocations() {
        return this.fileSystemLocations;
    }

    public final ProjectBuildBatchConfig buildBatchConfig() {
        return this.buildBatchConfig;
    }

    public final Integer concurrentBuildLimit() {
        return this.concurrentBuildLimit;
    }

    public final ProjectVisibilityType projectVisibility() {
        return ProjectVisibilityType.fromValue(this.projectVisibility);
    }

    public final String projectVisibilityAsString() {
        return this.projectVisibility;
    }

    public final String publicProjectAlias() {
        return this.publicProjectAlias;
    }

    public final String resourceAccessRole() {
        return this.resourceAccessRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecondarySources() ? this.secondarySources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecondarySourceVersions() ? this.secondarySourceVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.artifacts());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecondaryArtifacts() ? this.secondaryArtifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cache());
        hashCode = 31 * hashCode + Objects.hashCode(this.environment());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.queuedTimeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.webhook());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.badge());
        hashCode = 31 * hashCode + Objects.hashCode(this.logsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFileSystemLocations() ? this.fileSystemLocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.buildBatchConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.concurrentBuildLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicProjectAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceAccessRole());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Project)) {
            return false;
        }
        Project other = (Project)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.source(), other.source()) && this.hasSecondarySources() == other.hasSecondarySources() && Objects.equals(this.secondarySources(), other.secondarySources()) && Objects.equals(this.sourceVersion(), other.sourceVersion()) && this.hasSecondarySourceVersions() == other.hasSecondarySourceVersions() && Objects.equals(this.secondarySourceVersions(), other.secondarySourceVersions()) && Objects.equals(this.artifacts(), other.artifacts()) && this.hasSecondaryArtifacts() == other.hasSecondaryArtifacts() && Objects.equals(this.secondaryArtifacts(), other.secondaryArtifacts()) && Objects.equals(this.cache(), other.cache()) && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.timeoutInMinutes(), other.timeoutInMinutes()) && Objects.equals(this.queuedTimeoutInMinutes(), other.queuedTimeoutInMinutes()) && Objects.equals(this.encryptionKey(), other.encryptionKey()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.webhook(), other.webhook()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.badge(), other.badge()) && Objects.equals(this.logsConfig(), other.logsConfig()) && this.hasFileSystemLocations() == other.hasFileSystemLocations() && Objects.equals(this.fileSystemLocations(), other.fileSystemLocations()) && Objects.equals(this.buildBatchConfig(), other.buildBatchConfig()) && Objects.equals(this.concurrentBuildLimit(), other.concurrentBuildLimit()) && Objects.equals(this.projectVisibilityAsString(), other.projectVisibilityAsString()) && Objects.equals(this.publicProjectAlias(), other.publicProjectAlias()) && Objects.equals(this.resourceAccessRole(), other.resourceAccessRole());
    }

    public final String toString() {
        return ToString.builder((String)"Project").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("Description", (Object)this.description()).add("Source", (Object)this.source()).add("SecondarySources", this.hasSecondarySources() ? this.secondarySources() : null).add("SourceVersion", (Object)this.sourceVersion()).add("SecondarySourceVersions", this.hasSecondarySourceVersions() ? this.secondarySourceVersions() : null).add("Artifacts", (Object)this.artifacts()).add("SecondaryArtifacts", this.hasSecondaryArtifacts() ? this.secondaryArtifacts() : null).add("Cache", (Object)this.cache()).add("Environment", (Object)this.environment()).add("ServiceRole", (Object)this.serviceRole()).add("TimeoutInMinutes", (Object)this.timeoutInMinutes()).add("QueuedTimeoutInMinutes", (Object)this.queuedTimeoutInMinutes()).add("EncryptionKey", (Object)this.encryptionKey()).add("Tags", this.hasTags() ? this.tags() : null).add("Created", (Object)this.created()).add("LastModified", (Object)this.lastModified()).add("Webhook", (Object)this.webhook()).add("VpcConfig", (Object)this.vpcConfig()).add("Badge", (Object)this.badge()).add("LogsConfig", (Object)this.logsConfig()).add("FileSystemLocations", this.hasFileSystemLocations() ? this.fileSystemLocations() : null).add("BuildBatchConfig", (Object)this.buildBatchConfig()).add("ConcurrentBuildLimit", (Object)this.concurrentBuildLimit()).add("ProjectVisibility", (Object)this.projectVisibilityAsString()).add("PublicProjectAlias", (Object)this.publicProjectAlias()).add("ResourceAccessRole", (Object)this.resourceAccessRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "secondarySources": {
                return Optional.ofNullable(clazz.cast(this.secondarySources()));
            }
            case "sourceVersion": {
                return Optional.ofNullable(clazz.cast(this.sourceVersion()));
            }
            case "secondarySourceVersions": {
                return Optional.ofNullable(clazz.cast(this.secondarySourceVersions()));
            }
            case "artifacts": {
                return Optional.ofNullable(clazz.cast(this.artifacts()));
            }
            case "secondaryArtifacts": {
                return Optional.ofNullable(clazz.cast(this.secondaryArtifacts()));
            }
            case "cache": {
                return Optional.ofNullable(clazz.cast(this.cache()));
            }
            case "environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "serviceRole": {
                return Optional.ofNullable(clazz.cast(this.serviceRole()));
            }
            case "timeoutInMinutes": {
                return Optional.ofNullable(clazz.cast(this.timeoutInMinutes()));
            }
            case "queuedTimeoutInMinutes": {
                return Optional.ofNullable(clazz.cast(this.queuedTimeoutInMinutes()));
            }
            case "encryptionKey": {
                return Optional.ofNullable(clazz.cast(this.encryptionKey()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "lastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "webhook": {
                return Optional.ofNullable(clazz.cast(this.webhook()));
            }
            case "vpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "badge": {
                return Optional.ofNullable(clazz.cast(this.badge()));
            }
            case "logsConfig": {
                return Optional.ofNullable(clazz.cast(this.logsConfig()));
            }
            case "fileSystemLocations": {
                return Optional.ofNullable(clazz.cast(this.fileSystemLocations()));
            }
            case "buildBatchConfig": {
                return Optional.ofNullable(clazz.cast(this.buildBatchConfig()));
            }
            case "concurrentBuildLimit": {
                return Optional.ofNullable(clazz.cast(this.concurrentBuildLimit()));
            }
            case "projectVisibility": {
                return Optional.ofNullable(clazz.cast(this.projectVisibilityAsString()));
            }
            case "publicProjectAlias": {
                return Optional.ofNullable(clazz.cast(this.publicProjectAlias()));
            }
            case "resourceAccessRole": {
                return Optional.ofNullable(clazz.cast(this.resourceAccessRole()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Project, T> g) {
        return obj -> g.apply((Project)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String description;
        private ProjectSource source;
        private List<ProjectSource> secondarySources = DefaultSdkAutoConstructList.getInstance();
        private String sourceVersion;
        private List<ProjectSourceVersion> secondarySourceVersions = DefaultSdkAutoConstructList.getInstance();
        private ProjectArtifacts artifacts;
        private List<ProjectArtifacts> secondaryArtifacts = DefaultSdkAutoConstructList.getInstance();
        private ProjectCache cache;
        private ProjectEnvironment environment;
        private String serviceRole;
        private Integer timeoutInMinutes;
        private Integer queuedTimeoutInMinutes;
        private String encryptionKey;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Instant created;
        private Instant lastModified;
        private Webhook webhook;
        private VpcConfig vpcConfig;
        private ProjectBadge badge;
        private LogsConfig logsConfig;
        private List<ProjectFileSystemLocation> fileSystemLocations = DefaultSdkAutoConstructList.getInstance();
        private ProjectBuildBatchConfig buildBatchConfig;
        private Integer concurrentBuildLimit;
        private String projectVisibility;
        private String publicProjectAlias;
        private String resourceAccessRole;

        private BuilderImpl() {
        }

        private BuilderImpl(Project model) {
            this.name(model.name);
            this.arn(model.arn);
            this.description(model.description);
            this.source(model.source);
            this.secondarySources(model.secondarySources);
            this.sourceVersion(model.sourceVersion);
            this.secondarySourceVersions(model.secondarySourceVersions);
            this.artifacts(model.artifacts);
            this.secondaryArtifacts(model.secondaryArtifacts);
            this.cache(model.cache);
            this.environment(model.environment);
            this.serviceRole(model.serviceRole);
            this.timeoutInMinutes(model.timeoutInMinutes);
            this.queuedTimeoutInMinutes(model.queuedTimeoutInMinutes);
            this.encryptionKey(model.encryptionKey);
            this.tags(model.tags);
            this.created(model.created);
            this.lastModified(model.lastModified);
            this.webhook(model.webhook);
            this.vpcConfig(model.vpcConfig);
            this.badge(model.badge);
            this.logsConfig(model.logsConfig);
            this.fileSystemLocations(model.fileSystemLocations);
            this.buildBatchConfig(model.buildBatchConfig);
            this.concurrentBuildLimit(model.concurrentBuildLimit);
            this.projectVisibility(model.projectVisibility);
            this.publicProjectAlias(model.publicProjectAlias);
            this.resourceAccessRole(model.resourceAccessRole);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ProjectSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(ProjectSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        @Transient
        public final Builder source(ProjectSource source) {
            this.source = source;
            return this;
        }

        public final List<ProjectSource.Builder> getSecondarySources() {
            List<ProjectSource.Builder> result = ProjectSourcesCopier.copyToBuilder(this.secondarySources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondarySources(Collection<ProjectSource.BuilderImpl> secondarySources) {
            this.secondarySources = ProjectSourcesCopier.copyFromBuilder(secondarySources);
        }

        @Override
        @Transient
        public final Builder secondarySources(Collection<ProjectSource> secondarySources) {
            this.secondarySources = ProjectSourcesCopier.copy(secondarySources);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder secondarySources(ProjectSource ... secondarySources) {
            this.secondarySources(Arrays.asList(secondarySources));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder secondarySources(Consumer<ProjectSource.Builder> ... secondarySources) {
            this.secondarySources(Stream.of(secondarySources).map(c -> (ProjectSource)((ProjectSource.Builder)ProjectSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSourceVersion() {
            return this.sourceVersion;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        @Override
        @Transient
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public final List<ProjectSourceVersion.Builder> getSecondarySourceVersions() {
            List<ProjectSourceVersion.Builder> result = ProjectSecondarySourceVersionsCopier.copyToBuilder(this.secondarySourceVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondarySourceVersions(Collection<ProjectSourceVersion.BuilderImpl> secondarySourceVersions) {
            this.secondarySourceVersions = ProjectSecondarySourceVersionsCopier.copyFromBuilder(secondarySourceVersions);
        }

        @Override
        @Transient
        public final Builder secondarySourceVersions(Collection<ProjectSourceVersion> secondarySourceVersions) {
            this.secondarySourceVersions = ProjectSecondarySourceVersionsCopier.copy(secondarySourceVersions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder secondarySourceVersions(ProjectSourceVersion ... secondarySourceVersions) {
            this.secondarySourceVersions(Arrays.asList(secondarySourceVersions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder secondarySourceVersions(Consumer<ProjectSourceVersion.Builder> ... secondarySourceVersions) {
            this.secondarySourceVersions(Stream.of(secondarySourceVersions).map(c -> (ProjectSourceVersion)((ProjectSourceVersion.Builder)ProjectSourceVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ProjectArtifacts.Builder getArtifacts() {
            return this.artifacts != null ? this.artifacts.toBuilder() : null;
        }

        public final void setArtifacts(ProjectArtifacts.BuilderImpl artifacts) {
            this.artifacts = artifacts != null ? artifacts.build() : null;
        }

        @Override
        @Transient
        public final Builder artifacts(ProjectArtifacts artifacts) {
            this.artifacts = artifacts;
            return this;
        }

        public final List<ProjectArtifacts.Builder> getSecondaryArtifacts() {
            List<ProjectArtifacts.Builder> result = ProjectArtifactsListCopier.copyToBuilder(this.secondaryArtifacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondaryArtifacts(Collection<ProjectArtifacts.BuilderImpl> secondaryArtifacts) {
            this.secondaryArtifacts = ProjectArtifactsListCopier.copyFromBuilder(secondaryArtifacts);
        }

        @Override
        @Transient
        public final Builder secondaryArtifacts(Collection<ProjectArtifacts> secondaryArtifacts) {
            this.secondaryArtifacts = ProjectArtifactsListCopier.copy(secondaryArtifacts);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder secondaryArtifacts(ProjectArtifacts ... secondaryArtifacts) {
            this.secondaryArtifacts(Arrays.asList(secondaryArtifacts));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder secondaryArtifacts(Consumer<ProjectArtifacts.Builder> ... secondaryArtifacts) {
            this.secondaryArtifacts(Stream.of(secondaryArtifacts).map(c -> (ProjectArtifacts)((ProjectArtifacts.Builder)ProjectArtifacts.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ProjectCache.Builder getCache() {
            return this.cache != null ? this.cache.toBuilder() : null;
        }

        public final void setCache(ProjectCache.BuilderImpl cache) {
            this.cache = cache != null ? cache.build() : null;
        }

        @Override
        @Transient
        public final Builder cache(ProjectCache cache) {
            this.cache = cache;
            return this;
        }

        public final ProjectEnvironment.Builder getEnvironment() {
            return this.environment != null ? this.environment.toBuilder() : null;
        }

        public final void setEnvironment(ProjectEnvironment.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        @Override
        @Transient
        public final Builder environment(ProjectEnvironment environment) {
            this.environment = environment;
            return this;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        @Transient
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final Integer getTimeoutInMinutes() {
            return this.timeoutInMinutes;
        }

        public final void setTimeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
        }

        @Override
        @Transient
        public final Builder timeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
            return this;
        }

        public final Integer getQueuedTimeoutInMinutes() {
            return this.queuedTimeoutInMinutes;
        }

        public final void setQueuedTimeoutInMinutes(Integer queuedTimeoutInMinutes) {
            this.queuedTimeoutInMinutes = queuedTimeoutInMinutes;
        }

        @Override
        @Transient
        public final Builder queuedTimeoutInMinutes(Integer queuedTimeoutInMinutes) {
            this.queuedTimeoutInMinutes = queuedTimeoutInMinutes;
            return this;
        }

        public final String getEncryptionKey() {
            return this.encryptionKey;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        @Override
        @Transient
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreated() {
            return this.created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        @Transient
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        @Transient
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final Webhook.Builder getWebhook() {
            return this.webhook != null ? this.webhook.toBuilder() : null;
        }

        public final void setWebhook(Webhook.BuilderImpl webhook) {
            this.webhook = webhook != null ? webhook.build() : null;
        }

        @Override
        @Transient
        public final Builder webhook(Webhook webhook) {
            this.webhook = webhook;
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final ProjectBadge.Builder getBadge() {
            return this.badge != null ? this.badge.toBuilder() : null;
        }

        public final void setBadge(ProjectBadge.BuilderImpl badge) {
            this.badge = badge != null ? badge.build() : null;
        }

        @Override
        @Transient
        public final Builder badge(ProjectBadge badge) {
            this.badge = badge;
            return this;
        }

        public final LogsConfig.Builder getLogsConfig() {
            return this.logsConfig != null ? this.logsConfig.toBuilder() : null;
        }

        public final void setLogsConfig(LogsConfig.BuilderImpl logsConfig) {
            this.logsConfig = logsConfig != null ? logsConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder logsConfig(LogsConfig logsConfig) {
            this.logsConfig = logsConfig;
            return this;
        }

        public final List<ProjectFileSystemLocation.Builder> getFileSystemLocations() {
            List<ProjectFileSystemLocation.Builder> result = ProjectFileSystemLocationsCopier.copyToBuilder(this.fileSystemLocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileSystemLocations(Collection<ProjectFileSystemLocation.BuilderImpl> fileSystemLocations) {
            this.fileSystemLocations = ProjectFileSystemLocationsCopier.copyFromBuilder(fileSystemLocations);
        }

        @Override
        @Transient
        public final Builder fileSystemLocations(Collection<ProjectFileSystemLocation> fileSystemLocations) {
            this.fileSystemLocations = ProjectFileSystemLocationsCopier.copy(fileSystemLocations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder fileSystemLocations(ProjectFileSystemLocation ... fileSystemLocations) {
            this.fileSystemLocations(Arrays.asList(fileSystemLocations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder fileSystemLocations(Consumer<ProjectFileSystemLocation.Builder> ... fileSystemLocations) {
            this.fileSystemLocations(Stream.of(fileSystemLocations).map(c -> (ProjectFileSystemLocation)((ProjectFileSystemLocation.Builder)ProjectFileSystemLocation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ProjectBuildBatchConfig.Builder getBuildBatchConfig() {
            return this.buildBatchConfig != null ? this.buildBatchConfig.toBuilder() : null;
        }

        public final void setBuildBatchConfig(ProjectBuildBatchConfig.BuilderImpl buildBatchConfig) {
            this.buildBatchConfig = buildBatchConfig != null ? buildBatchConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder buildBatchConfig(ProjectBuildBatchConfig buildBatchConfig) {
            this.buildBatchConfig = buildBatchConfig;
            return this;
        }

        public final Integer getConcurrentBuildLimit() {
            return this.concurrentBuildLimit;
        }

        public final void setConcurrentBuildLimit(Integer concurrentBuildLimit) {
            this.concurrentBuildLimit = concurrentBuildLimit;
        }

        @Override
        @Transient
        public final Builder concurrentBuildLimit(Integer concurrentBuildLimit) {
            this.concurrentBuildLimit = concurrentBuildLimit;
            return this;
        }

        public final String getProjectVisibility() {
            return this.projectVisibility;
        }

        public final void setProjectVisibility(String projectVisibility) {
            this.projectVisibility = projectVisibility;
        }

        @Override
        @Transient
        public final Builder projectVisibility(String projectVisibility) {
            this.projectVisibility = projectVisibility;
            return this;
        }

        @Override
        @Transient
        public final Builder projectVisibility(ProjectVisibilityType projectVisibility) {
            this.projectVisibility(projectVisibility == null ? null : projectVisibility.toString());
            return this;
        }

        public final String getPublicProjectAlias() {
            return this.publicProjectAlias;
        }

        public final void setPublicProjectAlias(String publicProjectAlias) {
            this.publicProjectAlias = publicProjectAlias;
        }

        @Override
        @Transient
        public final Builder publicProjectAlias(String publicProjectAlias) {
            this.publicProjectAlias = publicProjectAlias;
            return this;
        }

        public final String getResourceAccessRole() {
            return this.resourceAccessRole;
        }

        public final void setResourceAccessRole(String resourceAccessRole) {
            this.resourceAccessRole = resourceAccessRole;
        }

        @Override
        @Transient
        public final Builder resourceAccessRole(String resourceAccessRole) {
            this.resourceAccessRole = resourceAccessRole;
            return this;
        }

        public Project build() {
            return new Project(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Project> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder description(String var1);

        public Builder source(ProjectSource var1);

        default public Builder source(Consumer<ProjectSource.Builder> source) {
            return this.source((ProjectSource)((ProjectSource.Builder)ProjectSource.builder().applyMutation(source)).build());
        }

        public Builder secondarySources(Collection<ProjectSource> var1);

        public Builder secondarySources(ProjectSource ... var1);

        public Builder secondarySources(Consumer<ProjectSource.Builder> ... var1);

        public Builder sourceVersion(String var1);

        public Builder secondarySourceVersions(Collection<ProjectSourceVersion> var1);

        public Builder secondarySourceVersions(ProjectSourceVersion ... var1);

        public Builder secondarySourceVersions(Consumer<ProjectSourceVersion.Builder> ... var1);

        public Builder artifacts(ProjectArtifacts var1);

        default public Builder artifacts(Consumer<ProjectArtifacts.Builder> artifacts) {
            return this.artifacts((ProjectArtifacts)((ProjectArtifacts.Builder)ProjectArtifacts.builder().applyMutation(artifacts)).build());
        }

        public Builder secondaryArtifacts(Collection<ProjectArtifacts> var1);

        public Builder secondaryArtifacts(ProjectArtifacts ... var1);

        public Builder secondaryArtifacts(Consumer<ProjectArtifacts.Builder> ... var1);

        public Builder cache(ProjectCache var1);

        default public Builder cache(Consumer<ProjectCache.Builder> cache) {
            return this.cache((ProjectCache)((ProjectCache.Builder)ProjectCache.builder().applyMutation(cache)).build());
        }

        public Builder environment(ProjectEnvironment var1);

        default public Builder environment(Consumer<ProjectEnvironment.Builder> environment) {
            return this.environment((ProjectEnvironment)((ProjectEnvironment.Builder)ProjectEnvironment.builder().applyMutation(environment)).build());
        }

        public Builder serviceRole(String var1);

        public Builder timeoutInMinutes(Integer var1);

        public Builder queuedTimeoutInMinutes(Integer var1);

        public Builder encryptionKey(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder created(Instant var1);

        public Builder lastModified(Instant var1);

        public Builder webhook(Webhook var1);

        default public Builder webhook(Consumer<Webhook.Builder> webhook) {
            return this.webhook((Webhook)((Webhook.Builder)Webhook.builder().applyMutation(webhook)).build());
        }

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder badge(ProjectBadge var1);

        default public Builder badge(Consumer<ProjectBadge.Builder> badge) {
            return this.badge((ProjectBadge)((ProjectBadge.Builder)ProjectBadge.builder().applyMutation(badge)).build());
        }

        public Builder logsConfig(LogsConfig var1);

        default public Builder logsConfig(Consumer<LogsConfig.Builder> logsConfig) {
            return this.logsConfig((LogsConfig)((LogsConfig.Builder)LogsConfig.builder().applyMutation(logsConfig)).build());
        }

        public Builder fileSystemLocations(Collection<ProjectFileSystemLocation> var1);

        public Builder fileSystemLocations(ProjectFileSystemLocation ... var1);

        public Builder fileSystemLocations(Consumer<ProjectFileSystemLocation.Builder> ... var1);

        public Builder buildBatchConfig(ProjectBuildBatchConfig var1);

        default public Builder buildBatchConfig(Consumer<ProjectBuildBatchConfig.Builder> buildBatchConfig) {
            return this.buildBatchConfig((ProjectBuildBatchConfig)((ProjectBuildBatchConfig.Builder)ProjectBuildBatchConfig.builder().applyMutation(buildBatchConfig)).build());
        }

        public Builder concurrentBuildLimit(Integer var1);

        public Builder projectVisibility(String var1);

        public Builder projectVisibility(ProjectVisibilityType var1);

        public Builder publicProjectAlias(String var1);

        public Builder resourceAccessRole(String var1);
    }
}

