/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.CodeBuildResponse;
import software.amazon.awssdk.services.codebuild.model.ReportArnsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListReportsForReportGroupResponse
extends CodeBuildResponse
implements ToCopyableBuilder<Builder, ListReportsForReportGroupResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListReportsForReportGroupResponse.getter(ListReportsForReportGroupResponse::nextToken)).setter(ListReportsForReportGroupResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<String>> REPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("reports").getter(ListReportsForReportGroupResponse.getter(ListReportsForReportGroupResponse::reports)).setter(ListReportsForReportGroupResponse.setter(Builder::reports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, REPORTS_FIELD));
    private final String nextToken;
    private final List<String> reports;

    private ListReportsForReportGroupResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.reports = builder.reports;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasReports() {
        return this.reports != null && !(this.reports instanceof SdkAutoConstructList);
    }

    public final List<String> reports() {
        return this.reports;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReports() ? this.reports() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReportsForReportGroupResponse)) {
            return false;
        }
        ListReportsForReportGroupResponse other = (ListReportsForReportGroupResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasReports() == other.hasReports() && Objects.equals(this.reports(), other.reports());
    }

    public final String toString() {
        return ToString.builder((String)"ListReportsForReportGroupResponse").add("NextToken", (Object)this.nextToken()).add("Reports", this.hasReports() ? this.reports() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "reports": {
                return Optional.ofNullable(clazz.cast(this.reports()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListReportsForReportGroupResponse, T> g) {
        return obj -> g.apply((ListReportsForReportGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<String> reports = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListReportsForReportGroupResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.reports(model.reports);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getReports() {
            if (this.reports instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reports;
        }

        public final void setReports(Collection<String> reports) {
            this.reports = ReportArnsCopier.copy(reports);
        }

        @Override
        @Transient
        public final Builder reports(Collection<String> reports) {
            this.reports = ReportArnsCopier.copy(reports);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reports(String ... reports) {
            this.reports(Arrays.asList(reports));
            return this;
        }

        @Override
        public ListReportsForReportGroupResponse build() {
            return new ListReportsForReportGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeBuildResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListReportsForReportGroupResponse> {
        public Builder nextToken(String var1);

        public Builder reports(Collection<String> var1);

        public Builder reports(String ... var1);
    }
}

