/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codebuild.CodeBuildClient;
import software.amazon.awssdk.services.codebuild.model.CodeCoverage;
import software.amazon.awssdk.services.codebuild.model.DescribeCodeCoveragesRequest;
import software.amazon.awssdk.services.codebuild.model.DescribeCodeCoveragesResponse;

public class DescribeCodeCoveragesIterable
implements SdkIterable<DescribeCodeCoveragesResponse> {
    private final CodeBuildClient client;
    private final DescribeCodeCoveragesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeCodeCoveragesIterable(CodeBuildClient client, DescribeCodeCoveragesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeCodeCoveragesResponseFetcher();
    }

    public Iterator<DescribeCodeCoveragesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CodeCoverage> codeCoverages() {
        Function<DescribeCodeCoveragesResponse, Iterator> getIterator = response -> {
            if (response != null && response.codeCoverages() != null) {
                return response.codeCoverages().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeCodeCoveragesResponseFetcher
    implements SyncPageFetcher<DescribeCodeCoveragesResponse> {
        private DescribeCodeCoveragesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCodeCoveragesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeCodeCoveragesResponse nextPage(DescribeCodeCoveragesResponse previousPage) {
            if (previousPage == null) {
                return DescribeCodeCoveragesIterable.this.client.describeCodeCoverages(DescribeCodeCoveragesIterable.this.firstRequest);
            }
            return DescribeCodeCoveragesIterable.this.client.describeCodeCoverages((DescribeCodeCoveragesRequest)((Object)DescribeCodeCoveragesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

