/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.CodeBuildResponse;
import software.amazon.awssdk.services.codebuild.model.ReportGroupTrendRawDataListCopier;
import software.amazon.awssdk.services.codebuild.model.ReportGroupTrendStats;
import software.amazon.awssdk.services.codebuild.model.ReportWithRawData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetReportGroupTrendResponse
extends CodeBuildResponse
implements ToCopyableBuilder<Builder, GetReportGroupTrendResponse> {
    private static final SdkField<ReportGroupTrendStats> STATS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("stats").getter(GetReportGroupTrendResponse.getter(GetReportGroupTrendResponse::stats)).setter(GetReportGroupTrendResponse.setter(Builder::stats)).constructor(ReportGroupTrendStats::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stats").build()}).build();
    private static final SdkField<List<ReportWithRawData>> RAW_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rawData").getter(GetReportGroupTrendResponse.getter(GetReportGroupTrendResponse::rawData)).setter(GetReportGroupTrendResponse.setter(Builder::rawData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rawData").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReportWithRawData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATS_FIELD, RAW_DATA_FIELD));
    private final ReportGroupTrendStats stats;
    private final List<ReportWithRawData> rawData;

    private GetReportGroupTrendResponse(BuilderImpl builder) {
        super(builder);
        this.stats = builder.stats;
        this.rawData = builder.rawData;
    }

    public final ReportGroupTrendStats stats() {
        return this.stats;
    }

    public final boolean hasRawData() {
        return this.rawData != null && !(this.rawData instanceof SdkAutoConstructList);
    }

    public final List<ReportWithRawData> rawData() {
        return this.rawData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stats());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRawData() ? this.rawData() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReportGroupTrendResponse)) {
            return false;
        }
        GetReportGroupTrendResponse other = (GetReportGroupTrendResponse)((Object)obj);
        return Objects.equals(this.stats(), other.stats()) && this.hasRawData() == other.hasRawData() && Objects.equals(this.rawData(), other.rawData());
    }

    public final String toString() {
        return ToString.builder((String)"GetReportGroupTrendResponse").add("Stats", (Object)this.stats()).add("RawData", this.hasRawData() ? this.rawData() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stats": {
                return Optional.ofNullable(clazz.cast(this.stats()));
            }
            case "rawData": {
                return Optional.ofNullable(clazz.cast(this.rawData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReportGroupTrendResponse, T> g) {
        return obj -> g.apply((GetReportGroupTrendResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildResponse.BuilderImpl
    implements Builder {
        private ReportGroupTrendStats stats;
        private List<ReportWithRawData> rawData = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetReportGroupTrendResponse model) {
            super(model);
            this.stats(model.stats);
            this.rawData(model.rawData);
        }

        public final ReportGroupTrendStats.Builder getStats() {
            return this.stats != null ? this.stats.toBuilder() : null;
        }

        @Override
        public final Builder stats(ReportGroupTrendStats stats) {
            this.stats = stats;
            return this;
        }

        public final void setStats(ReportGroupTrendStats.BuilderImpl stats) {
            this.stats = stats != null ? stats.build() : null;
        }

        public final List<ReportWithRawData.Builder> getRawData() {
            List<ReportWithRawData.Builder> result = ReportGroupTrendRawDataListCopier.copyToBuilder(this.rawData);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder rawData(Collection<ReportWithRawData> rawData) {
            this.rawData = ReportGroupTrendRawDataListCopier.copy(rawData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rawData(ReportWithRawData ... rawData) {
            this.rawData(Arrays.asList(rawData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rawData(Consumer<ReportWithRawData.Builder> ... rawData) {
            this.rawData(Stream.of(rawData).map(c -> (ReportWithRawData)((ReportWithRawData.Builder)ReportWithRawData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRawData(Collection<ReportWithRawData.BuilderImpl> rawData) {
            this.rawData = ReportGroupTrendRawDataListCopier.copyFromBuilder(rawData);
        }

        @Override
        public GetReportGroupTrendResponse build() {
            return new GetReportGroupTrendResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeBuildResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetReportGroupTrendResponse> {
        public Builder stats(ReportGroupTrendStats var1);

        default public Builder stats(Consumer<ReportGroupTrendStats.Builder> stats) {
            return this.stats((ReportGroupTrendStats)((ReportGroupTrendStats.Builder)ReportGroupTrendStats.builder().applyMutation(stats)).build());
        }

        public Builder rawData(Collection<ReportWithRawData> var1);

        public Builder rawData(ReportWithRawData ... var1);

        public Builder rawData(Consumer<ReportWithRawData.Builder> ... var1);
    }
}

