/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codebuild.CodeBuildAsyncClient;
import software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectRequest;
import software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectResponse;

public class ListBuildBatchesForProjectPublisher
implements SdkPublisher<ListBuildBatchesForProjectResponse> {
    private final CodeBuildAsyncClient client;
    private final ListBuildBatchesForProjectRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBuildBatchesForProjectPublisher(CodeBuildAsyncClient client, ListBuildBatchesForProjectRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBuildBatchesForProjectPublisher(CodeBuildAsyncClient client, ListBuildBatchesForProjectRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBuildBatchesForProjectResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBuildBatchesForProjectResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> ids() {
        Function<ListBuildBatchesForProjectResponse, Iterator> getIterator = response -> {
            if (response != null && response.ids() != null) {
                return response.ids().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBuildBatchesForProjectResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBuildBatchesForProjectResponseFetcher
    implements AsyncPageFetcher<ListBuildBatchesForProjectResponse> {
        private ListBuildBatchesForProjectResponseFetcher() {
        }

        public boolean hasNextPage(ListBuildBatchesForProjectResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBuildBatchesForProjectResponse> nextPage(ListBuildBatchesForProjectResponse previousPage) {
            if (previousPage == null) {
                return ListBuildBatchesForProjectPublisher.this.client.listBuildBatchesForProject(ListBuildBatchesForProjectPublisher.this.firstRequest);
            }
            return ListBuildBatchesForProjectPublisher.this.client.listBuildBatchesForProject((ListBuildBatchesForProjectRequest)((Object)ListBuildBatchesForProjectPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

