/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.EnvironmentImage;
import software.amazon.awssdk.services.codebuild.model.EnvironmentImagesCopier;
import software.amazon.awssdk.services.codebuild.model.LanguageType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentLanguage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnvironmentLanguage> {
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("language").getter(EnvironmentLanguage.getter(EnvironmentLanguage::languageAsString)).setter(EnvironmentLanguage.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()}).build();
    private static final SdkField<List<EnvironmentImage>> IMAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("images").getter(EnvironmentLanguage.getter(EnvironmentLanguage::images)).setter(EnvironmentLanguage.setter(Builder::images)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("images").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnvironmentImage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_FIELD, IMAGES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String language;
    private final List<EnvironmentImage> images;

    private EnvironmentLanguage(BuilderImpl builder) {
        this.language = builder.language;
        this.images = builder.images;
    }

    public LanguageType language() {
        return LanguageType.fromValue(this.language);
    }

    public String languageAsString() {
        return this.language;
    }

    public boolean hasImages() {
        return this.images != null && !(this.images instanceof SdkAutoConstructList);
    }

    public List<EnvironmentImage> images() {
        return this.images;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.languageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImages() ? this.images() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentLanguage)) {
            return false;
        }
        EnvironmentLanguage other = (EnvironmentLanguage)obj;
        return Objects.equals(this.languageAsString(), other.languageAsString()) && this.hasImages() == other.hasImages() && Objects.equals(this.images(), other.images());
    }

    public String toString() {
        return ToString.builder((String)"EnvironmentLanguage").add("Language", (Object)this.languageAsString()).add("Images", this.hasImages() ? this.images() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "language": {
                return Optional.ofNullable(clazz.cast(this.languageAsString()));
            }
            case "images": {
                return Optional.ofNullable(clazz.cast(this.images()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentLanguage, T> g) {
        return obj -> g.apply((EnvironmentLanguage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String language;
        private List<EnvironmentImage> images = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentLanguage model) {
            this.language(model.language);
            this.images(model.images);
        }

        public final String getLanguage() {
            return this.language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        @Override
        public final Builder language(LanguageType language) {
            this.language(language == null ? null : language.toString());
            return this;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        public final Collection<EnvironmentImage.Builder> getImages() {
            if (this.images instanceof SdkAutoConstructList) {
                return null;
            }
            return this.images != null ? (Collection)this.images.stream().map(EnvironmentImage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder images(Collection<EnvironmentImage> images) {
            this.images = EnvironmentImagesCopier.copy(images);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(EnvironmentImage ... images) {
            this.images(Arrays.asList(images));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(Consumer<EnvironmentImage.Builder> ... images) {
            this.images(Stream.of(images).map(c -> (EnvironmentImage)((EnvironmentImage.Builder)EnvironmentImage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setImages(Collection<EnvironmentImage.BuilderImpl> images) {
            this.images = EnvironmentImagesCopier.copyFromBuilder(images);
        }

        public EnvironmentLanguage build() {
            return new EnvironmentLanguage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnvironmentLanguage> {
        public Builder language(String var1);

        public Builder language(LanguageType var1);

        public Builder images(Collection<EnvironmentImage> var1);

        public Builder images(EnvironmentImage ... var1);

        public Builder images(Consumer<EnvironmentImage.Builder> ... var1);
    }
}

