/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codebuild.model.FileSystemType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProjectFileSystemLocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProjectFileSystemLocation> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProjectFileSystemLocation.getter(ProjectFileSystemLocation::typeAsString)).setter(ProjectFileSystemLocation.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProjectFileSystemLocation.getter(ProjectFileSystemLocation::location)).setter(ProjectFileSystemLocation.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> MOUNT_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProjectFileSystemLocation.getter(ProjectFileSystemLocation::mountPoint)).setter(ProjectFileSystemLocation.setter(Builder::mountPoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mountPoint").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProjectFileSystemLocation.getter(ProjectFileSystemLocation::identifier)).setter(ProjectFileSystemLocation.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()}).build();
    private static final SdkField<String> MOUNT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProjectFileSystemLocation.getter(ProjectFileSystemLocation::mountOptions)).setter(ProjectFileSystemLocation.setter(Builder::mountOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mountOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, LOCATION_FIELD, MOUNT_POINT_FIELD, IDENTIFIER_FIELD, MOUNT_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String location;
    private final String mountPoint;
    private final String identifier;
    private final String mountOptions;

    private ProjectFileSystemLocation(BuilderImpl builder) {
        this.type = builder.type;
        this.location = builder.location;
        this.mountPoint = builder.mountPoint;
        this.identifier = builder.identifier;
        this.mountOptions = builder.mountOptions;
    }

    public FileSystemType type() {
        return FileSystemType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String location() {
        return this.location;
    }

    public String mountPoint() {
        return this.mountPoint;
    }

    public String identifier() {
        return this.identifier;
    }

    public String mountOptions() {
        return this.mountOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.mountPoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.mountOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectFileSystemLocation)) {
            return false;
        }
        ProjectFileSystemLocation other = (ProjectFileSystemLocation)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.mountPoint(), other.mountPoint()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.mountOptions(), other.mountOptions());
    }

    public String toString() {
        return ToString.builder((String)"ProjectFileSystemLocation").add("Type", (Object)this.typeAsString()).add("Location", (Object)this.location()).add("MountPoint", (Object)this.mountPoint()).add("Identifier", (Object)this.identifier()).add("MountOptions", (Object)this.mountOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "mountPoint": {
                return Optional.ofNullable(clazz.cast(this.mountPoint()));
            }
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "mountOptions": {
                return Optional.ofNullable(clazz.cast(this.mountOptions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProjectFileSystemLocation, T> g) {
        return obj -> g.apply((ProjectFileSystemLocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String location;
        private String mountPoint;
        private String identifier;
        private String mountOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectFileSystemLocation model) {
            this.type(model.type);
            this.location(model.location);
            this.mountPoint(model.mountPoint);
            this.identifier(model.identifier);
            this.mountOptions(model.mountOptions);
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FileSystemType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getMountPoint() {
            return this.mountPoint;
        }

        @Override
        public final Builder mountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
            return this;
        }

        public final void setMountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public final String getMountOptions() {
            return this.mountOptions;
        }

        @Override
        public final Builder mountOptions(String mountOptions) {
            this.mountOptions = mountOptions;
            return this;
        }

        public final void setMountOptions(String mountOptions) {
            this.mountOptions = mountOptions;
        }

        public ProjectFileSystemLocation build() {
            return new ProjectFileSystemLocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProjectFileSystemLocation> {
        public Builder type(String var1);

        public Builder type(FileSystemType var1);

        public Builder location(String var1);

        public Builder mountPoint(String var1);

        public Builder identifier(String var1);

        public Builder mountOptions(String var1);
    }
}

