/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codebuild.model.WebhookFilterType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WebhookFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WebhookFilter> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WebhookFilter.getter(WebhookFilter::typeAsString)).setter(WebhookFilter.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WebhookFilter.getter(WebhookFilter::pattern)).setter(WebhookFilter.setter(Builder::pattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pattern").build()}).build();
    private static final SdkField<Boolean> EXCLUDE_MATCHED_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(WebhookFilter.getter(WebhookFilter::excludeMatchedPattern)).setter(WebhookFilter.setter(Builder::excludeMatchedPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludeMatchedPattern").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, PATTERN_FIELD, EXCLUDE_MATCHED_PATTERN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String pattern;
    private final Boolean excludeMatchedPattern;

    private WebhookFilter(BuilderImpl builder) {
        this.type = builder.type;
        this.pattern = builder.pattern;
        this.excludeMatchedPattern = builder.excludeMatchedPattern;
    }

    public WebhookFilterType type() {
        return WebhookFilterType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String pattern() {
        return this.pattern;
    }

    public Boolean excludeMatchedPattern() {
        return this.excludeMatchedPattern;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludeMatchedPattern());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebhookFilter)) {
            return false;
        }
        WebhookFilter other = (WebhookFilter)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.pattern(), other.pattern()) && Objects.equals(this.excludeMatchedPattern(), other.excludeMatchedPattern());
    }

    public String toString() {
        return ToString.builder((String)"WebhookFilter").add("Type", (Object)this.typeAsString()).add("Pattern", (Object)this.pattern()).add("ExcludeMatchedPattern", (Object)this.excludeMatchedPattern()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "pattern": {
                return Optional.ofNullable(clazz.cast(this.pattern()));
            }
            case "excludeMatchedPattern": {
                return Optional.ofNullable(clazz.cast(this.excludeMatchedPattern()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WebhookFilter, T> g) {
        return obj -> g.apply((WebhookFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String pattern;
        private Boolean excludeMatchedPattern;

        private BuilderImpl() {
        }

        private BuilderImpl(WebhookFilter model) {
            this.type(model.type);
            this.pattern(model.pattern);
            this.excludeMatchedPattern(model.excludeMatchedPattern);
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(WebhookFilterType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getPattern() {
            return this.pattern;
        }

        @Override
        public final Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public final void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public final Boolean getExcludeMatchedPattern() {
            return this.excludeMatchedPattern;
        }

        @Override
        public final Builder excludeMatchedPattern(Boolean excludeMatchedPattern) {
            this.excludeMatchedPattern = excludeMatchedPattern;
            return this;
        }

        public final void setExcludeMatchedPattern(Boolean excludeMatchedPattern) {
            this.excludeMatchedPattern = excludeMatchedPattern;
        }

        public WebhookFilter build() {
            return new WebhookFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WebhookFilter> {
        public Builder type(String var1);

        public Builder type(WebhookFilterType var1);

        public Builder pattern(String var1);

        public Builder excludeMatchedPattern(Boolean var1);
    }
}

