/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.transform.PhaseContextMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PhaseContext
implements StructuredPojo,
ToCopyableBuilder<Builder, PhaseContext> {
    private final String statusCode;
    private final String message;

    private PhaseContext(BuilderImpl builder) {
        this.statusCode = builder.statusCode;
        this.message = builder.message;
    }

    public String statusCode() {
        return this.statusCode;
    }

    public String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhaseContext)) {
            return false;
        }
        PhaseContext other = (PhaseContext)obj;
        return Objects.equals(this.statusCode(), other.statusCode()) && Objects.equals(this.message(), other.message());
    }

    public String toString() {
        return ToString.builder((String)"PhaseContext").add("StatusCode", (Object)this.statusCode()).add("Message", (Object)this.message()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "statusCode": {
                return Optional.of(clazz.cast(this.statusCode()));
            }
            case "message": {
                return Optional.of(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PhaseContextMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String statusCode;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(PhaseContext model) {
            this.statusCode(model.statusCode);
            this.message(model.message);
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public PhaseContext build() {
            return new PhaseContext(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PhaseContext> {
        public Builder statusCode(String var1);

        public Builder message(String var1);
    }
}

