/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codebuild.model.EnvironmentLanguage;

@SdkInternalApi
public class EnvironmentLanguageMarshaller {
    private static final MarshallingInfo<String> LANGUAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("language").build();
    private static final MarshallingInfo<List> IMAGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("images").build();
    private static final EnvironmentLanguageMarshaller INSTANCE = new EnvironmentLanguageMarshaller();

    public static EnvironmentLanguageMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EnvironmentLanguage environmentLanguage, ProtocolMarshaller protocolMarshaller) {
        if (environmentLanguage == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)environmentLanguage.languageString(), LANGUAGE_BINDING);
            protocolMarshaller.marshall(environmentLanguage.images(), IMAGES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

