/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codebuild.model.EnvironmentVariable;
import software.amazon.awssdk.services.codebuild.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.codebuild.model.ProjectArtifacts;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StartBuildRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, StartBuildRequest> {
    private final String projectName;
    private final String sourceVersion;
    private final ProjectArtifacts artifactsOverride;
    private final List<EnvironmentVariable> environmentVariablesOverride;
    private final String buildspecOverride;
    private final Integer timeoutInMinutesOverride;

    private StartBuildRequest(BuilderImpl builder) {
        this.projectName = builder.projectName;
        this.sourceVersion = builder.sourceVersion;
        this.artifactsOverride = builder.artifactsOverride;
        this.environmentVariablesOverride = builder.environmentVariablesOverride;
        this.buildspecOverride = builder.buildspecOverride;
        this.timeoutInMinutesOverride = builder.timeoutInMinutesOverride;
    }

    public String projectName() {
        return this.projectName;
    }

    public String sourceVersion() {
        return this.sourceVersion;
    }

    public ProjectArtifacts artifactsOverride() {
        return this.artifactsOverride;
    }

    public List<EnvironmentVariable> environmentVariablesOverride() {
        return this.environmentVariablesOverride;
    }

    public String buildspecOverride() {
        return this.buildspecOverride;
    }

    public Integer timeoutInMinutesOverride() {
        return this.timeoutInMinutesOverride;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.projectName() == null ? 0 : this.projectName().hashCode());
        hashCode = 31 * hashCode + (this.sourceVersion() == null ? 0 : this.sourceVersion().hashCode());
        hashCode = 31 * hashCode + (this.artifactsOverride() == null ? 0 : this.artifactsOverride().hashCode());
        hashCode = 31 * hashCode + (this.environmentVariablesOverride() == null ? 0 : this.environmentVariablesOverride().hashCode());
        hashCode = 31 * hashCode + (this.buildspecOverride() == null ? 0 : this.buildspecOverride().hashCode());
        hashCode = 31 * hashCode + (this.timeoutInMinutesOverride() == null ? 0 : this.timeoutInMinutesOverride().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartBuildRequest)) {
            return false;
        }
        StartBuildRequest other = (StartBuildRequest)((Object)obj);
        if (other.projectName() == null ^ this.projectName() == null) {
            return false;
        }
        if (other.projectName() != null && !other.projectName().equals(this.projectName())) {
            return false;
        }
        if (other.sourceVersion() == null ^ this.sourceVersion() == null) {
            return false;
        }
        if (other.sourceVersion() != null && !other.sourceVersion().equals(this.sourceVersion())) {
            return false;
        }
        if (other.artifactsOverride() == null ^ this.artifactsOverride() == null) {
            return false;
        }
        if (other.artifactsOverride() != null && !other.artifactsOverride().equals(this.artifactsOverride())) {
            return false;
        }
        if (other.environmentVariablesOverride() == null ^ this.environmentVariablesOverride() == null) {
            return false;
        }
        if (other.environmentVariablesOverride() != null && !other.environmentVariablesOverride().equals(this.environmentVariablesOverride())) {
            return false;
        }
        if (other.buildspecOverride() == null ^ this.buildspecOverride() == null) {
            return false;
        }
        if (other.buildspecOverride() != null && !other.buildspecOverride().equals(this.buildspecOverride())) {
            return false;
        }
        if (other.timeoutInMinutesOverride() == null ^ this.timeoutInMinutesOverride() == null) {
            return false;
        }
        return other.timeoutInMinutesOverride() == null || other.timeoutInMinutesOverride().equals(this.timeoutInMinutesOverride());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.projectName() != null) {
            sb.append("ProjectName: ").append(this.projectName()).append(",");
        }
        if (this.sourceVersion() != null) {
            sb.append("SourceVersion: ").append(this.sourceVersion()).append(",");
        }
        if (this.artifactsOverride() != null) {
            sb.append("ArtifactsOverride: ").append(this.artifactsOverride()).append(",");
        }
        if (this.environmentVariablesOverride() != null) {
            sb.append("EnvironmentVariablesOverride: ").append(this.environmentVariablesOverride()).append(",");
        }
        if (this.buildspecOverride() != null) {
            sb.append("BuildspecOverride: ").append(this.buildspecOverride()).append(",");
        }
        if (this.timeoutInMinutesOverride() != null) {
            sb.append("TimeoutInMinutesOverride: ").append(this.timeoutInMinutesOverride()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectName": {
                return Optional.of(clazz.cast(this.projectName()));
            }
            case "sourceVersion": {
                return Optional.of(clazz.cast(this.sourceVersion()));
            }
            case "artifactsOverride": {
                return Optional.of(clazz.cast(this.artifactsOverride()));
            }
            case "environmentVariablesOverride": {
                return Optional.of(clazz.cast(this.environmentVariablesOverride()));
            }
            case "buildspecOverride": {
                return Optional.of(clazz.cast(this.buildspecOverride()));
            }
            case "timeoutInMinutesOverride": {
                return Optional.of(clazz.cast(this.timeoutInMinutesOverride()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String projectName;
        private String sourceVersion;
        private ProjectArtifacts artifactsOverride;
        private List<EnvironmentVariable> environmentVariablesOverride;
        private String buildspecOverride;
        private Integer timeoutInMinutesOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(StartBuildRequest model) {
            this.projectName(model.projectName);
            this.sourceVersion(model.sourceVersion);
            this.artifactsOverride(model.artifactsOverride);
            this.environmentVariablesOverride(model.environmentVariablesOverride);
            this.buildspecOverride(model.buildspecOverride);
            this.timeoutInMinutesOverride(model.timeoutInMinutesOverride);
        }

        public final String getProjectName() {
            return this.projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public final String getSourceVersion() {
            return this.sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        public final ProjectArtifacts.Builder getArtifactsOverride() {
            return this.artifactsOverride != null ? this.artifactsOverride.toBuilder() : null;
        }

        @Override
        public final Builder artifactsOverride(ProjectArtifacts artifactsOverride) {
            this.artifactsOverride = artifactsOverride;
            return this;
        }

        public final void setArtifactsOverride(ProjectArtifacts.BuilderImpl artifactsOverride) {
            this.artifactsOverride = artifactsOverride != null ? artifactsOverride.build() : null;
        }

        public final Collection<EnvironmentVariable.Builder> getEnvironmentVariablesOverride() {
            return this.environmentVariablesOverride != null ? (Collection)this.environmentVariablesOverride.stream().map(EnvironmentVariable::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder environmentVariablesOverride(Collection<EnvironmentVariable> environmentVariablesOverride) {
            this.environmentVariablesOverride = EnvironmentVariablesCopier.copy(environmentVariablesOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentVariablesOverride(EnvironmentVariable ... environmentVariablesOverride) {
            this.environmentVariablesOverride(Arrays.asList(environmentVariablesOverride));
            return this;
        }

        public final void setEnvironmentVariablesOverride(Collection<EnvironmentVariable.BuilderImpl> environmentVariablesOverride) {
            this.environmentVariablesOverride = EnvironmentVariablesCopier.copyFromBuilder(environmentVariablesOverride);
        }

        public final String getBuildspecOverride() {
            return this.buildspecOverride;
        }

        @Override
        public final Builder buildspecOverride(String buildspecOverride) {
            this.buildspecOverride = buildspecOverride;
            return this;
        }

        public final void setBuildspecOverride(String buildspecOverride) {
            this.buildspecOverride = buildspecOverride;
        }

        public final Integer getTimeoutInMinutesOverride() {
            return this.timeoutInMinutesOverride;
        }

        @Override
        public final Builder timeoutInMinutesOverride(Integer timeoutInMinutesOverride) {
            this.timeoutInMinutesOverride = timeoutInMinutesOverride;
            return this;
        }

        public final void setTimeoutInMinutesOverride(Integer timeoutInMinutesOverride) {
            this.timeoutInMinutesOverride = timeoutInMinutesOverride;
        }

        public StartBuildRequest build() {
            return new StartBuildRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StartBuildRequest> {
        public Builder projectName(String var1);

        public Builder sourceVersion(String var1);

        public Builder artifactsOverride(ProjectArtifacts var1);

        public Builder environmentVariablesOverride(Collection<EnvironmentVariable> var1);

        public Builder environmentVariablesOverride(EnvironmentVariable ... var1);

        public Builder buildspecOverride(String var1);

        public Builder timeoutInMinutesOverride(Integer var1);
    }
}

