/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.codebuild.model.ProjectNamesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListProjectsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListProjectsResponse> {
    private final String nextToken;
    private final List<String> projects;

    private ListProjectsResponse(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.projects = builder.projects;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<String> projects() {
        return this.projects;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.projects() == null ? 0 : this.projects().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProjectsResponse)) {
            return false;
        }
        ListProjectsResponse other = (ListProjectsResponse)((Object)obj);
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.projects() == null ^ this.projects() == null) {
            return false;
        }
        return other.projects() == null || other.projects().equals(this.projects());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.projects() != null) {
            sb.append("Projects: ").append(this.projects()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "projects": {
                return Optional.of(clazz.cast(this.projects()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String nextToken;
        private List<String> projects;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProjectsResponse model) {
            this.nextToken(model.nextToken);
            this.projects(model.projects);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getProjects() {
            return this.projects;
        }

        @Override
        public final Builder projects(Collection<String> projects) {
            this.projects = ProjectNamesCopier.copy(projects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projects(String ... projects) {
            this.projects(Arrays.asList(projects));
            return this;
        }

        public final void setProjects(Collection<String> projects) {
            this.projects = ProjectNamesCopier.copy(projects);
        }

        public ListProjectsResponse build() {
            return new ListProjectsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListProjectsResponse> {
        public Builder nextToken(String var1);

        public Builder projects(Collection<String> var1);

        public Builder projects(String ... var1);
    }
}

