/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.model.BuildPhaseType;
import software.amazon.awssdk.services.codebuild.model.PhaseContext;
import software.amazon.awssdk.services.codebuild.model.PhaseContextsCopier;
import software.amazon.awssdk.services.codebuild.model.StatusType;
import software.amazon.awssdk.services.codebuild.transform.BuildPhaseMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BuildPhase
implements StructuredPojo,
ToCopyableBuilder<Builder, BuildPhase> {
    private final String phaseType;
    private final String phaseStatus;
    private final Instant startTime;
    private final Instant endTime;
    private final Long durationInSeconds;
    private final List<PhaseContext> contexts;

    private BuildPhase(BuilderImpl builder) {
        this.phaseType = builder.phaseType;
        this.phaseStatus = builder.phaseStatus;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.durationInSeconds = builder.durationInSeconds;
        this.contexts = builder.contexts;
    }

    public String phaseType() {
        return this.phaseType;
    }

    public String phaseStatus() {
        return this.phaseStatus;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public Long durationInSeconds() {
        return this.durationInSeconds;
    }

    public List<PhaseContext> contexts() {
        return this.contexts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.phaseType() == null ? 0 : this.phaseType().hashCode());
        hashCode = 31 * hashCode + (this.phaseStatus() == null ? 0 : this.phaseStatus().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.durationInSeconds() == null ? 0 : this.durationInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.contexts() == null ? 0 : this.contexts().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuildPhase)) {
            return false;
        }
        BuildPhase other = (BuildPhase)obj;
        if (other.phaseType() == null ^ this.phaseType() == null) {
            return false;
        }
        if (other.phaseType() != null && !other.phaseType().equals(this.phaseType())) {
            return false;
        }
        if (other.phaseStatus() == null ^ this.phaseStatus() == null) {
            return false;
        }
        if (other.phaseStatus() != null && !other.phaseStatus().equals(this.phaseStatus())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.durationInSeconds() == null ^ this.durationInSeconds() == null) {
            return false;
        }
        if (other.durationInSeconds() != null && !other.durationInSeconds().equals(this.durationInSeconds())) {
            return false;
        }
        if (other.contexts() == null ^ this.contexts() == null) {
            return false;
        }
        return other.contexts() == null || other.contexts().equals(this.contexts());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.phaseType() != null) {
            sb.append("PhaseType: ").append(this.phaseType()).append(",");
        }
        if (this.phaseStatus() != null) {
            sb.append("PhaseStatus: ").append(this.phaseStatus()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.durationInSeconds() != null) {
            sb.append("DurationInSeconds: ").append(this.durationInSeconds()).append(",");
        }
        if (this.contexts() != null) {
            sb.append("Contexts: ").append(this.contexts()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BuildPhaseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String phaseType;
        private String phaseStatus;
        private Instant startTime;
        private Instant endTime;
        private Long durationInSeconds;
        private List<PhaseContext> contexts;

        private BuilderImpl() {
        }

        private BuilderImpl(BuildPhase model) {
            this.setPhaseType(model.phaseType);
            this.setPhaseStatus(model.phaseStatus);
            this.setStartTime(model.startTime);
            this.setEndTime(model.endTime);
            this.setDurationInSeconds(model.durationInSeconds);
            this.setContexts(model.contexts);
        }

        public final String getPhaseType() {
            return this.phaseType;
        }

        @Override
        public final Builder phaseType(String phaseType) {
            this.phaseType = phaseType;
            return this;
        }

        @Override
        public final Builder phaseType(BuildPhaseType phaseType) {
            this.phaseType(phaseType.toString());
            return this;
        }

        public final void setPhaseType(String phaseType) {
            this.phaseType = phaseType;
        }

        public final String getPhaseStatus() {
            return this.phaseStatus;
        }

        @Override
        public final Builder phaseStatus(String phaseStatus) {
            this.phaseStatus = phaseStatus;
            return this;
        }

        @Override
        public final Builder phaseStatus(StatusType phaseStatus) {
            this.phaseStatus(phaseStatus.toString());
            return this;
        }

        public final void setPhaseStatus(String phaseStatus) {
            this.phaseStatus = phaseStatus;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Long getDurationInSeconds() {
            return this.durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Long durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public final void setDurationInSeconds(Long durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        public final Collection<PhaseContext> getContexts() {
            return this.contexts;
        }

        @Override
        public final Builder contexts(Collection<PhaseContext> contexts) {
            this.contexts = PhaseContextsCopier.copy(contexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contexts(PhaseContext ... contexts) {
            this.contexts(Arrays.asList(contexts));
            return this;
        }

        public final void setContexts(Collection<PhaseContext> contexts) {
            this.contexts = PhaseContextsCopier.copy(contexts);
        }

        public BuildPhase build() {
            return new BuildPhase(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BuildPhase> {
        public Builder phaseType(String var1);

        public Builder phaseType(BuildPhaseType var1);

        public Builder phaseStatus(String var1);

        public Builder phaseStatus(StatusType var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder durationInSeconds(Long var1);

        public Builder contexts(Collection<PhaseContext> var1);

        public Builder contexts(PhaseContext ... var1);
    }
}

