/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.model.Build;

@SdkInternalApi
public class BuildMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").build();
    private static final MarshallingInfo<Instant> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTime").build();
    private static final MarshallingInfo<String> CURRENTPHASE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("currentPhase").build();
    private static final MarshallingInfo<String> BUILDSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("buildStatus").build();
    private static final MarshallingInfo<String> SOURCEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceVersion").build();
    private static final MarshallingInfo<String> PROJECTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("projectName").build();
    private static final MarshallingInfo<List> PHASES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("phases").build();
    private static final MarshallingInfo<StructuredPojo> SOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("source").build();
    private static final MarshallingInfo<StructuredPojo> ARTIFACTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("artifacts").build();
    private static final MarshallingInfo<StructuredPojo> ENVIRONMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("environment").build();
    private static final MarshallingInfo<StructuredPojo> LOGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logs").build();
    private static final MarshallingInfo<Integer> TIMEOUTINMINUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timeoutInMinutes").build();
    private static final MarshallingInfo<Boolean> BUILDCOMPLETE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("buildComplete").build();
    private static final MarshallingInfo<String> INITIATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("initiator").build();
    private static final BuildMarshaller instance = new BuildMarshaller();

    public static BuildMarshaller getInstance() {
        return instance;
    }

    public void marshall(Build build, ProtocolMarshaller protocolMarshaller) {
        if (build == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)build.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)build.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)build.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)build.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)build.currentPhase(), CURRENTPHASE_BINDING);
            protocolMarshaller.marshall((Object)build.buildStatus(), BUILDSTATUS_BINDING);
            protocolMarshaller.marshall((Object)build.sourceVersion(), SOURCEVERSION_BINDING);
            protocolMarshaller.marshall((Object)build.projectName(), PROJECTNAME_BINDING);
            protocolMarshaller.marshall(build.phases(), PHASES_BINDING);
            protocolMarshaller.marshall((Object)build.source(), SOURCE_BINDING);
            protocolMarshaller.marshall((Object)build.artifacts(), ARTIFACTS_BINDING);
            protocolMarshaller.marshall((Object)build.environment(), ENVIRONMENT_BINDING);
            protocolMarshaller.marshall((Object)build.logs(), LOGS_BINDING);
            protocolMarshaller.marshall((Object)build.timeoutInMinutes(), TIMEOUTINMINUTES_BINDING);
            protocolMarshaller.marshall((Object)build.buildComplete(), BUILDCOMPLETE_BINDING);
            protocolMarshaller.marshall((Object)build.initiator(), INITIATOR_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

