/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codebuild.model.Webhook;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class WebhookMarshaller {
    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("url").isBinary(false).build();
    private static final MarshallingInfo<String> PAYLOADURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("payloadUrl").isBinary(false).build();
    private static final MarshallingInfo<String> SECRET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("secret").isBinary(false).build();
    private static final MarshallingInfo<String> BRANCHFILTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("branchFilter").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTMODIFIEDSECRET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastModifiedSecret").isBinary(false).build();
    private static final WebhookMarshaller INSTANCE = new WebhookMarshaller();

    private WebhookMarshaller() {
    }

    public static WebhookMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Webhook webhook, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)webhook, (String)"webhook");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)webhook.url(), URL_BINDING);
            protocolMarshaller.marshall((Object)webhook.payloadUrl(), PAYLOADURL_BINDING);
            protocolMarshaller.marshall((Object)webhook.secret(), SECRET_BINDING);
            protocolMarshaller.marshall((Object)webhook.branchFilter(), BRANCHFILTER_BINDING);
            protocolMarshaller.marshall((Object)webhook.lastModifiedSecret(), LASTMODIFIEDSECRET_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

